/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintGraphicElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class JRTemplatePrintImage
extends JRTemplatePrintGraphicElement
implements JRPrintImage {
    private static final long serialVersionUID = 10200L;
    private static final int SERIALIZATION_FLAG_CACHED_RENDERER = 1;
    private static final int SERIALIZATION_FLAG_ANCHOR = 2;
    private static final int SERIALIZATION_FLAG_HYPERLINK = 4;
    private Renderable renderable;
    private String anchorName;
    private String hyperlinkReference;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected int bookmarkLevel = 0;
    private JRRenderable renderer;

    public JRTemplatePrintImage() {
    }

    public JRTemplatePrintImage(JRTemplateImage image) {
        super(image);
    }

    public JRTemplatePrintImage(JRTemplateImage image, int sourceElementId) {
        super(image, sourceElementId);
    }

    @Override
    public Renderable getRenderable() {
        return this.renderable;
    }

    @Override
    public void setRenderable(Renderable renderable) {
        this.renderable = renderable;
    }

    @Override
    public JRRenderable getRenderer() {
        return this.getRenderable();
    }

    @Override
    public void setRenderer(JRRenderable renderer) {
        this.setRenderable(RenderableUtil.getWrappingRenderable(renderer));
    }

    @Override
    public ScaleImageEnum getScaleImageValue() {
        return ((JRTemplateImage)this.template).getScaleImageValue();
    }

    @Override
    public ScaleImageEnum getOwnScaleImageValue() {
        return ((JRTemplateImage)this.template).getOwnScaleImageValue();
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUsingCache() {
        return ((JRTemplateImage)this.template).isUsingCache();
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return ((JRTemplateImage)this.template).getHorizontalAlignmentValue();
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return ((JRTemplateImage)this.template).getOwnHorizontalAlignmentValue();
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return ((JRTemplateImage)this.template).getVerticalAlignmentValue();
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return ((JRTemplateImage)this.template).getOwnVerticalAlignmentValue();
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLazy() {
        return ((JRTemplateImage)this.template).isLazy();
    }

    @Override
    public void setLazy(boolean isLazy) {
    }

    @Override
    public OnErrorTypeEnum getOnErrorTypeValue() {
        return ((JRTemplateImage)this.template).getOnErrorTypeValue();
    }

    @Override
    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRLineBox getLineBox() {
        return ((JRTemplateImage)this.template).getLineBox();
    }

    @Override
    public String getAnchorName() {
        return this.anchorName;
    }

    @Override
    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return ((JRTemplateImage)this.template).getHyperlinkTypeValue();
    }

    @Override
    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HyperlinkTargetEnum getHyperlinkTargetValue() {
        return ((JRTemplateImage)this.template).getHyperlinkTargetValue();
    }

    @Override
    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    @Override
    public void setHyperlinkReference(String hyperlinkReference) {
        this.hyperlinkReference = hyperlinkReference;
    }

    @Override
    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    @Override
    public void setHyperlinkAnchor(String hyperlinkAnchor) {
        this.hyperlinkAnchor = hyperlinkAnchor;
    }

    @Override
    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    @Override
    public void setHyperlinkPage(Integer hyperlinkPage) {
        this.hyperlinkPage = hyperlinkPage;
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    @Override
    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public void setHyperlinkParameters(JRPrintHyperlinkParameters parameters) {
        this.hyperlinkParameters = parameters;
    }

    @Override
    public String getLinkType() {
        return ((JRTemplateImage)this.template).getLinkType();
    }

    @Override
    public void setLinkType(String type) {
    }

    @Override
    public String getLinkTarget() {
        return ((JRTemplateImage)this.template).getLinkTarget();
    }

    @Override
    public void setLinkTarget(String target) {
    }

    @Override
    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    @Override
    public void setHyperlinkTooltip(String hyperlinkTooltip) {
        this.hyperlinkTooltip = hyperlinkTooltip;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.renderer != null && this.renderable == null) {
            this.renderable = this.renderer instanceof Renderable ? (Renderable)this.renderer : RenderableUtil.getWrappingRenderable(this.renderer);
        }
    }

    @Override
    public <T> void accept(PrintElementVisitor<T> visitor, T arg) {
        visitor.visit(this, arg);
    }

    @Override
    public void writeVirtualized(VirtualizationOutput out) throws IOException {
        boolean hasHyperlink;
        super.writeVirtualized(out);
        JRVirtualizationContext context = out.getVirtualizationContext();
        int flags = 0;
        boolean cachedRenderer = this.renderable != null && context.hasCachedRenderer(this.renderable.getId());
        boolean hasAnchor = this.anchorName != null || this.bookmarkLevel != 0;
        boolean bl = hasHyperlink = this.hyperlinkReference != null || this.hyperlinkAnchor != null || this.hyperlinkPage != null || this.hyperlinkTooltip != null || this.hyperlinkParameters != null;
        if (cachedRenderer) {
            flags |= 1;
        }
        if (hasAnchor) {
            flags |= 2;
        }
        if (hasHyperlink) {
            flags |= 4;
        }
        out.writeByte(flags);
        if (cachedRenderer) {
            out.writeJRObject(this.renderable.getId());
        } else {
            out.writeJRObject(this.renderable);
        }
        if (hasAnchor) {
            out.writeJRObject(this.anchorName);
            out.writeIntCompressed(this.bookmarkLevel);
        }
        if (hasHyperlink) {
            out.writeJRObject(this.hyperlinkReference);
            out.writeJRObject(this.hyperlinkAnchor);
            out.writeJRObject(this.hyperlinkPage);
            out.writeJRObject(this.hyperlinkTooltip);
            out.writeJRObject(this.hyperlinkParameters);
        }
    }

    @Override
    public void readVirtualized(VirtualizationInput in) throws IOException {
        super.readVirtualized(in);
        JRVirtualizationContext context = in.getVirtualizationContext();
        int flags = in.readUnsignedByte();
        if ((flags & 1) != 0) {
            String renderedId = (String)in.readJRObject();
            this.renderable = context.getCachedRenderer(renderedId);
            if (this.renderable == null) {
                throw new RuntimeException();
            }
        } else {
            this.renderable = (Renderable)in.readJRObject();
        }
        if ((flags & 2) != 0) {
            this.anchorName = (String)in.readJRObject();
            this.bookmarkLevel = in.readIntCompressed();
        } else {
            this.bookmarkLevel = 0;
        }
        if ((flags & 4) != 0) {
            this.hyperlinkReference = (String)in.readJRObject();
            this.hyperlinkAnchor = (String)in.readJRObject();
            this.hyperlinkPage = (Integer)in.readJRObject();
            this.hyperlinkTooltip = (String)in.readJRObject();
            this.hyperlinkParameters = (JRPrintHyperlinkParameters)in.readJRObject();
        }
    }
}

