/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.util.RequirejsModuleMapping;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequirejsConfigServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(RequirejsConfigServlet.class);
    private static final String REQUIREJS_CONFIG_TEMPLATE = "net/sf/jasperreports/web/servlets/resources/templates/RequirejsConfigTemplate.vm";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/javascript; charset=UTF-8");
        this.setNoExpire(response);
        PrintWriter out = response.getWriter();
        WebUtil webUtil = WebUtil.getInstance(this.getJasperReportsContext());
        List<RequirejsModuleMapping> requirejsMappings = this.getJasperReportsContext().getExtensions(RequirejsModuleMapping.class);
        LinkedHashMap<String, String> modulePaths = new LinkedHashMap<String, String>();
        for (RequirejsModuleMapping requirejsMapping : requirejsMappings) {
            String modulePath = requirejsMapping.getPath();
            if (requirejsMapping.isClasspathResource()) {
                modulePath = request.getContextPath() + webUtil.getResourcesBasePath() + modulePath;
            }
            modulePaths.put(requirejsMapping.getName(), modulePath);
        }
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("contextPath", request.getContextPath());
        contextMap.put("modulePaths", modulePaths.entrySet());
        out.write(VelocityUtil.processTemplate(REQUIREJS_CONFIG_TEMPLATE, contextMap));
    }
}

