/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ldap;

import gnu.inet.ldap.BERException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class BERDecoder {
    private byte[] buffer;
    private int offset;
    private int type;
    private int len;
    private boolean control;
    private boolean utf8;

    public BERDecoder(byte[] data, boolean utf8) {
        this.buffer = data;
        this.offset = 0;
        this.control = true;
        this.utf8 = utf8;
    }

    public int parseType() throws BERException {
        if (this.offset >= this.buffer.length) {
            return -1;
        }
        this.type = BERDecoder.byteToInt(this.buffer[this.offset++]);
        this.len = BERDecoder.byteToInt(this.buffer[this.offset++]);
        if ((this.len & 0x80) != 0) {
            int lsize = this.len - 128;
            if (lsize > 4) {
                throw new BERException("Data too long: " + lsize);
            }
            if (this.buffer.length - this.offset < lsize) {
                throw new BERException("Insufficient data");
            }
            this.len = 0;
            for (int i = 0; i < lsize; ++i) {
                this.len = (this.len << 8) + BERDecoder.byteToInt(this.buffer[this.offset++]);
            }
            if (this.buffer.length - this.offset < this.len) {
                throw new BERException("Insufficient data");
            }
        }
        this.control = false;
        return this.type;
    }

    static int byteToInt(byte b) {
        int ret = b;
        if (ret < 0) {
            ret += 256;
        }
        return ret;
    }

    int getLength() {
        return this.len;
    }

    public boolean available() {
        return this.offset < this.buffer.length;
    }

    public void skip() {
        this.offset += this.len;
        this.control = true;
    }

    public boolean parseBoolean() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.type != 1) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte c = this.buffer[this.offset++];
        this.control = true;
        return c != 0;
    }

    public int parseInt() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.type != 2 && this.type != 10) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte c = this.buffer[this.offset++];
        int val = c & 0x7F;
        for (int i = 1; i < this.len; ++i) {
            val <<= 8;
            val |= this.buffer[this.offset++] & 0xFF;
        }
        if ((c & 0x80) != 0) {
            val = -val;
        }
        this.control = true;
        return val;
    }

    public String parseString() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.len == 0) {
            this.control = true;
            return "";
        }
        if (this.type != 12 && this.type != 4) {
            throw new BERException("Unexpected type: " + this.type);
        }
        String encoding = this.type == 12 ? "UTF-8" : "ISO-8859-1";
        try {
            String ret = new String(this.buffer, this.offset, this.len, encoding);
            this.offset += this.len;
            this.control = true;
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            throw new BERException("JVM does not support " + encoding);
        }
    }

    public byte[] parseOctetString() throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (this.type != 4) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte[] ret = new byte[this.len];
        System.arraycopy(this.buffer, this.offset, ret, 0, this.len);
        this.offset += this.len;
        this.control = true;
        return ret;
    }

    public BERDecoder parseSequence() throws BERException {
        return this.parseSequence(16);
    }

    public BERDecoder parseSequence(int code) throws BERException {
        if (this.control) {
            this.parseType();
        }
        if (code != -1 && this.type != code) {
            throw new BERException("Unexpected type: " + this.type);
        }
        byte[] ret = new byte[this.len];
        System.arraycopy(this.buffer, this.offset, ret, 0, this.len);
        this.offset += this.len;
        this.control = true;
        return new BERDecoder(ret, this.utf8);
    }

    public BERDecoder parseSet() throws BERException {
        return this.parseSet(17);
    }

    public BERDecoder parseSet(int code) throws BERException {
        return this.parseSequence(code);
    }

    public static void main(String[] args) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = System.in.read();
            while (c != -1) {
                out.write(c);
                c = System.in.read();
            }
            byte[] code = out.toByteArray();
            BERDecoder decoder = new BERDecoder(code, true);
            BERDecoder.debug(decoder, 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private static void debug(BERDecoder decoder, int depth) throws BERException {
        int t = decoder.parseType();
        while (t != -1) {
            for (int i = 0; i < depth; ++i) {
                System.out.print('\t');
            }
            switch (t) {
                case 1: {
                    System.out.println("BOOLEAN: " + decoder.parseBoolean());
                    break;
                }
                case 2: {
                    System.out.println("INTEGER: " + decoder.parseInt());
                    break;
                }
                case 10: {
                    System.out.println("ENUMERATED: " + decoder.parseInt());
                    break;
                }
                case 4: {
                    System.out.println("OCTET-STRING: " + BERDecoder.toString(decoder.parseOctetString()));
                    break;
                }
                case 12: {
                    System.out.println("STRING: \"" + decoder.parseString() + "\"");
                    break;
                }
                default: {
                    System.out.println("SEQUENCE " + t + "(0x" + Integer.toHexString(t) + "): " + decoder.getLength());
                    BERDecoder sequence = decoder.parseSequence(t);
                    BERDecoder.debug(sequence, depth + 1);
                }
            }
            t = decoder.parseType();
        }
    }

    private static String toString(byte[] bytes) {
        try {
            return "\"" + new String(bytes, "UTF-8") + "\"";
        }
        catch (UnsupportedEncodingException e) {
            return bytes.toString();
        }
    }
}

