# Copyright (c) 2008 Movable Type ACME Plugin Project, All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

package Bleach::App;
use strict;

sub _hdlr_bleach {
	my ($ctx, $args, $cond) = @_;

	my $text = '';
	my $texts = $ctx->stash('tokens')->getElementsByTagName('text');
	foreach my $t (@$texts) {
		$text .= MT::Template::Node::nodeValue($t);
	}

	$text =~ tr/ 	/01/;
	$text =~ s/[^\r\n]+/pack('b*', $&)/ge;

	$ctx->build($text);
}

sub pre_save {
	my ($cb, $obj, $original) = @_;

	my @cols = ();
	if ($obj->datasource eq 'entry') {
		@cols = ('text', 'text_more');
	}
	elsif ($obj->datasource eq 'template') {
		@cols = ('text');
	}

	my $bleach = sub {
		my $text = shift;
		if ($text !~ m/^[\s\r\n]*$/) {
			$text =~ s/[^\r\n]+/unpack('b*', $&)/ge;
			$text =~ tr/01/ 	/;
		}
		$text;
	};

	foreach my $c (@cols) {
		my $text = $obj->$c;
		$text =~ s/(<mt:?bleach([^>]*)>)(.*?)(<\/mt:?bleach>)/"$1" . $bleach->($3) . "$4"/iseg;
		$obj->$c($text);
	}
}

1;
