<?php
/**
 * コンテンツ拡張(CExt) 管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_CextController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'CExt';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('コンテンツ拡張', BASE_URL . 'Manage/CExt/');
    }
    
    public function indexAction()
    {
        //echo 'Manage_ContentTypeController からこんにちは';
        $this->listAction();
    }

    public function noRouteAction()
    {
        echo "noRouteAction";
    }
    
    /**
     * CExt 一覧を表示する
     */
    public function listAction()
    {
        global $db, $base, $breadcrumb;
        
        ob_start();
        
        $CExt_path = APP_PATH . 'models/CExt/';

        echo '<h3>インストール済のコンテンツ拡張</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";
        $installed_CExt_name = array();
        $sql = "SELECT id, name FROM  Platy_CExt";
        $rows = $db->fetchAll($sql);
        for ($i = 0; $i < count($rows); $i++) {
        
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            echo '<td>' . $rows[$i]['id'] . '</td>';
            echo '<td>' . $rows[$i]['name'] . '</td>';
            
            $CExt_name = $rows[$i]['name'];
            require_once($CExt_path . $CExt_name . '.php');
            $CExt_class_name = 'Platy_CExt_' . $CExt_name;
            $obj = new $CExt_class_name;
            
            echo '<td>' . $obj->getSummary() . '</td>';
            echo '<td>' . $obj->getVersion() . '</td>';
            echo '<td>' . $obj->getAuthor() . '</td>';
            
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/CExt/uninstall/name/' . $rows[$i]['name'] . '">';
            echo '<img src="' . BASE_URL . 'media/system/package_delete.png" alt="uninstall" />';
            echo 'アンインストール</a>';
            echo '</td>';
            echo "</tr>\n";
            $installed_CExt_name[] = $rows[$i]['name'];
        }
        echo '</table>' . "\n";
        
        echo '<h3>未インストールのコンテンツ拡張</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";

        $d = dir($CExt_path);
        $i = 0;
        while (($entry = $d->read()) != FALSE) {
            if (!is_dir($CExt_path . $entry)) {
                $CExt_filename = $entry;
                //echo $CExt_filename . "<br />\n";
                $pos = stripos($CExt_filename, '.php');
                $CExt_name = substr($CExt_filename, 0, $pos);
                if (!in_array($CExt_name, $installed_CExt_name)) {
                    
                    require_once($CExt_path . $CExt_name . '.php');
                    
                    if ($i % 2 == 0) { echo '<tr class="even">'; }
                    else { echo '<tr class="odd">'; }
                    
                    echo '<td>' . $CExt_name . '</td>';
                    
                    $CExt_class_name = 'Platy_CExt_' . $CExt_name;
                    $obj = new $CExt_class_name;
                    
                    echo '<td>' . $obj->getSummary() . '</td>';
                    echo '<td>' . $obj->getVersion() . '</td>';
                    echo '<td>' . $obj->getAuthor() . '</td>';

                    echo '<td>';
                    echo '<a href="' . BASE_URL . 'Manage/CExt/install/name/' . $CExt_name . '">';
                    echo '<img src="' . BASE_URL . 'media/system/package_add.png" alt="install" />';
                    echo 'インストール</a>';
                    echo '</td>';
                    echo '</tr>' . "\n";
                    $i++;
                }
            }
        }
        echo '</table>' . "\n";
        $d->close();
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 設定
     */
    public function configAction()
    {
    }
    
    /**
     * インストール
     */
    public function installAction()
    {
        global $db;
        
        ob_start();
        
        echo 'Manage_ContentType:installAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/CExt/' . $name . '.php');
        $classname = 'Platy_CExt_' . $name;
        $obj = new $classname();
        if ($obj->install() == TRUE) {
            $sql = "INSERT INTO Platy_CExt(name) VALUES('{$name}')";
            echo $sql . "<br />\n";
            $db->query($sql);
            echo $name . 'のインストールに成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'のインストールに失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * アンインストール
     */
    public function uninstallAction()
    {
        global $db;
        
        ob_start();
        
        echo 'Manage_ContentType:uninstallAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/CExt/' . $name . '.php');
        $classname = 'Platy_CExt_' . $name;
        $obj = new $classname();
        if ($obj->uninstall() == TRUE) {
            $sql = "DELETE FROM Platy_CExt WHERE name='" . $name . "'";
            $db->query($sql);
            echo $name . 'のアンインストールに成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'のアンインストールに失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 表示
     */
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        echo $view->render('page.php');
    }
}
?>