<?php
/**
 * Reservation(ホテル予約)モジュールの管理
 */
require_once 'Platy/Form.php';
require_once 'Platy/Util.php';

require_once 'Zend/Controller/Action.php';
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';

class DbReservationPlan extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Reservation_Plan';
    }
}

class DbReservationRoomtype extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Reservation_Roomtype';
    }
}

class Manage_ReservationController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $Me;
        if ($Me->isAdmin() == false) {
            $this->_redirect('/Manage/Login/');
        }
    }
    
    public function indexAction()
    {
        $this->listReservationAction();
    }
    
    /**
     * 予約一覧表示
     */
    public function listReservationAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>予約一覧</h2>' . "\n";
        
        $sql = "SELECT id, fullname, checkin, checkout, planId, r_num, p_num, modified FROM Platy_Reservation_Reservation";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">';
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>' . "\n";
            echo '<td>' . $row['fullname'] . '</td>' . "\n";
            echo '<td>' . $row['checkin'] . '</td>' . "\n";
            echo '<td>' . $row['checkout'] . '</td>' . "\n";
            echo '<td>' . $row['r_num'] . '</td>' . "\n";
            echo '<td>' . $row['p_num'] . '</td>' . "\n";
            echo '<td>' . $row['modified'] . '</td>' . "\n";
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Reservation/editReservation/id/' . $row['id'] . '">編集</a>';
            echo '</td>' . "\n";
            
            echo '</tr>';
        }
        echo '</table>';
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * 予約の編集
     */
    public function editReservationAction()
    {
        global $db, $config;
        
        // id/ReservationId
        $request = $this->getRequest();
        $id = intval($request->getParam('id'));
        
        ob_start();
        
        
        
        
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * カレンダー表示
     */
    public function calendarAction()
    {
        global $db, $config;
        
        ob_start();
        
        
        
        
        
        
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    
    }
    
    /**
     * スケジュール
     */
    public function scheduleAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $ymd = intval($request->getParam('ymd'));
        
        ob_start();
        
        
        
        
        
        
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    
    }
    
    /**
     * プラン一覧
     */
    public function listPlanAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>プラン一覧</h2>' . "\n";
        
        $sql = "SELECT id, name, summary, image, price FROM Platy_Reservation_Plan";
        //echo $sql;
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">';
        echo '<th>id</th><th>名称</th><th>料金</th><th>action</th>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . Platy_Util::cnv_currency($row['price']) . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Reservation/editPlan/id/' . $row['id'] . '">編集</a>';
            echo '&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Reservation/deletePlan/id/' . $row['id'] . '">削除</a>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Reservation/addPlan/">プランの追加</a>' . "\n";
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * プランの追加
     */
    public function addPlanAction()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            
            // validation
            // TODO
            
            $name = h($_POST['p_name']);
            $summary = h($_POST['summary']);
            $roomtypeId = intval($_POST['roomtypeId']);
            $rooms = intval($_POST['rooms']);
            $price = intval($_POST['price']);
            $startDate = h($_POST['startDate']);
            $endDate = h($_POST['endDate']);
            $created = date('Y-m-d H:i:s');
            $modified = $created;
            $image_filename = basename($_FILES['image']['name']);
            
            $uploaddir = BASE_PATH . 'media/Reservation/Plan/';
            $uploadfile = $uploaddir . basename($_FILES['image']['name']);
            if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadfile)) {
                //echo "File is valid, and was successfully uploaded.\n";
            } else {
                echo "Possible file upload attack!\n";
            }
            
            $data = array(
                'name' => $name,
                'image' => $image_filename,
                'summary' => $summary,
                'roomtypeId' => $roomtypeId,
                'rooms' => $rooms,
                'price' => $price,
                'startDate' => $startDate,
                'endDate' => $endDate,
                'created' => $created,
                'modified' => $modified
            );
            
            $table = new DbReservationPlan();
            $table->insert($data);
            
        }
        else {
            
        }
        
        ob_start();
        
        echo '<h2>プランの追加</h2>' . "\n";
?>

<form method="post" name="f" enctype="multipart/form-data" action="">
<table class="form_table">
<tr><th>プラン名称:</th>
<td><input type="text" name="p_name" value="<?php echo $name ?>" size="60" /></td></tr>
<tr><th>画像:</th>
<td><input type="file" name="image" size="60" /></td></tr>
<tr><th>プラン概要:</th>
<td><textarea name="description" cols="56" rows="4"><?php echo $description ?></textarea></td></tr>
<tr><th>部屋タイプ</th>
<td><?php $this->cbo_Roomtype($roomtypeId) ?></td></tr>
<tr><th>割り当てる部屋数(1日あたり)</th>
<td>
<input type="text" name="rooms" value="<?php echo $rooms ?>" size="4" /></td></tr>
<tr><th>料金</th>
<td><input type="text" name="price" value="<?php echo $price ?>" size="12" /></td></tr>
<tr><th>startDate:</th>
<td><input type="text" name="startDate" value="<?php echo $startDate ?>" size="16" />
<input type="button" value="..." onclick="dateinput(this.form.startDate)" /></td></tr>
<tr><th>endDate:</th>
<td><input type="text" name="endDate" value="<?php echo $endDate ?>" size="16" />
<input type="button" value="..." onclick="dateinput(this.form.endDate)" /></td></tr>
<tr><th></th>
<td><input type="submit" value="プランを登録する" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * プランの編集
     */
    public function editPlanAction()
    {
        global $db, $config;
        
        // id/PlanId
        $request = $this->getRequest();
        $planId = intval($request->getParam('id'));
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            
            $name = h($_POST['p_name']);
            $summary = h($_POST['summary']);
            $roomtypeId = intval($_POST['roomtypeId']);
            $rooms = intval($_POST['rooms']);
            $price = intval($_POST['price']);
            $startDate = h($_POST['startDate']);
            $endDate = h($_POST['endDate']);
            $modified = date('Y-m-d H:i:s');
            $image_filename = basename($_FILES['image']['name']);
            
            if (strlen($image_filename) > 0) {
                $uploaddir = BASE_PATH . 'media/Reservation/Plan/';
                $uploadfile = $uploaddir . basename($_FILES['image']['name']);
                if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadfile)) {
                    //echo "File is valid, and was successfully uploaded.\n";
                } else {
                    echo "Possible file upload attack!\n";
                }
            }
            
            $data = array(
                'name' => $name,
                'summary' => $summary,
                'roomtypeId' => $roomtypeId,
                'rooms' => $rooms,
                'price' => $price,
                'startDate' => $startDate,
                'endDate' => $endDate,
                'modified' => $modified
            );
            if (strlen($image_filename) > 0) {
                $data['image'] = $image_filename;
            }
            
            $table = new DbReservationPlan();
            $table->insert($data);
            
        }
        else {
            $sql = "SELECT name, image, summary, rooms, price, roomtypeId FROM Platy_Reservation_Plan WHERE id={$planId}";
            $row = $db->fetchRow($sql);
            $name = $row['name'];
            $image_filename = $row['image'];
            $summary = $row['summary'];
            $price = $row['price'];
            $rooms = $row['rooms'];
            $roomtypeId = $row['roomtypeId'];
        }
        
        ob_start();
        
        echo '<h2>プランの編集</h2>' . "\n";
?>

<form method="post" name="f" enctype="multipart/form-data" action="">
<table class="form_table">
<tr><th>プラン名称:</th>
<td><input type="text" name="p_name" value="<?php echo $name ?>" size="60" /></td></tr>
<tr><th>画像:</th>
<td>
<?php
echo $image_filename . "<br />\n";
echo '<img src="' . BASE_URL . 'media/Reservation/Plan/' . $image_filename . '" width="100px" height="75px">' . "<br />\n";
?>
<input type="file" name="image" size="60" /></td></tr>
<tr><th>プラン概要:</th>
<td><textarea name="summary" cols="56" rows="4"><?php echo $summary ?></textarea></td></tr>
<tr><th>部屋タイプ</th>
<td>
<?php
echo $roomtypeId . "<br />\n";
$this->cbo_Roomtype($roomtypeId);
?>
</td></tr>
<tr><th></th>
<tr><th>1日に割り当てる部屋数</th>
<td>
<input type="text" name="rooms" value="<?php echo $rooms ?>" size="4" /></td></tr>
<tr><th>料金</th>
<td><input type="text" name="price" value="<?php echo $price ?>" size="6" /></td></tr>
<tr><th>startDate:</th>
<td><input type="text" name="startDate" value="<?php echo $startDate ?>" size="16" />
<input type="button" value="..." onclick="dateinput(this.form.startDate)" /></td></tr>
<tr><th>endDate:</th>
<td><input type="text" name="endDate" value="<?php echo $endDate ?>" size="16" />
<input type="button" value="..." onclick="dateinput(this.form.endDate)" /></td></tr>
<td><input type="submit" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * プランの削除
     */
    public function deletePlanAction()
    {
        global $db, $config;
        
        // id/PlanId
        $request = $this->getRequest();
        $planId = intval($request->getParam('id'));
        $sql = "DELETE FROM Platy_Reservation_Plan WHERE id={$planId}";
        $db->query($sql);
        
        $this->_redirect('/Manage/Reservation/listPlan/');
    }
    
    /**
     * 部屋タイプ一覧
     */
    public function listRoomtypeAction()
    {
        global $db, $config;
        
        ob_start();
        
        echo '<h2>部屋タイプ一覧</h2>' . "\n";
        
        $sql = "SELECT id, name, summary, image, p_min, p_max, rooms FROM Platy_Reservation_Roomtype";
        echo $sql;
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">';
        echo '<th>id</th><th>名称</th><th>収容人数</th><th>部屋数</th><th>action</th>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . $row['p_min'] . '-' . $row['p_max'] . '</td>';
            echo '<td>' . $row['rooms'] . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Reservation/editRoomtype/id/' . $row['id'] . '">編集</a>';
            echo '&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Reservation/deleteRoomtype/id/' . $row['id'] . '">削除</a>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        echo '<a href="' . BASE_URL . 'Manage/Reservation/addRoomtype/">部屋タイプの追加</a>' . "\n";

        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * 部屋タイプの追加
     */
    public function addRoomtypeAction()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            // validation
            // TODO
            
            $name = h($_POST['r_name']);
            $summary = h($_POST['summary']);
            $p_min = intval($_POST['p_min']);
            $p_max = intval($_POST['p_max']);
            $rooms = intval($_POST['rooms']);
            
            $uploaddir = BASE_PATH . 'media/Reservation/Roomtype/';
            $uploadfile = $uploaddir . basename($_FILES['image']['name']);
            if (!move_uploaded_file($_FILES['image']['tmp_name'], $uploadfile)) {
                echo "Possible file upload attack!\n";
            }
            $image = basename($_FILES['image']['name']);

            $created = date('Y-m-d H:i:s');
            $modified = $created;
            
            $table = new DbReservationRoomtype();
            $data = array(
                'name'    => $name,
                'summary' => $summary,
                'image' => $image,
                'p_min' => $p_min,
                'p_max' => $p_max,
                'rooms' => $rooms,
                'created' => $created,
                'modified' => $modified
            );
            //var_dump($data);
            $table->insert($data);
            
        }
        else {
            $name = '';
            $summary = '';
            $p_min = 1;
            $p_max = 1;
            $rooms = 1;
        }
        
        ob_start();
        
?>
<h2>部屋タイプの追加</h2>
<form method="post" enctype="multipart/form-data" action="">
<table class="form_table">
<tr><th>部屋タイプ名称:</th>
<td><input type="text" name="r_name" value="<?php echo $name ?>" size="64" /></td></tr>
<tr><th>画像:</th>
<td><input type="file" name="image" size="60" /></td></tr>
<tr><th>概要:</th>
<td><textarea name="summary" cols="50" rows="4"><?php echo $summary ?></textarea></td></tr>
<tr><th>収容可能人数:</th>
<td>
(最小)<input type="text" name="p_min" value="<?php echo $p_min ?>" size="4" />-
(最大)<input type="text" name="p_max" value="<?php echo $p_max ?>" size="4" /></td></tr>
<tr><th>部屋数:</th>
<td><input type="text" name="rooms" value="<?php echo $rooms ?>" size="4" /><br /></td></tr>
<tr><th></th>
<td><input type="submit" value="部屋タイプを追加する" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * 部屋タイプの編集
     */
    public function editRoomtypeAction()
    {
        global $db, $config;
        
        // id/roomtypeId
        $request = $this->getRequest();
        $roomtypeId = intval($request->getParam('id'));
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        }
        else {
            $sql = "SELECT name, image, summary, p_min, p_max, rooms FROM Platy_Reservation_Roomtype WHERE id={$roomtypeId}";
            $row = $db->fetchRow($sql);
            $name = $row['name'];
            $image_filename = $row['image'];
            $summary = $row['summary'];
            $p_min = $row['p_min'];
            $p_max = $row['p_max'];
            $rooms = $row['rooms'];
        }
        
        ob_start();
        
?>
<h2>部屋タイプの編集</h2>
<form method="post" enctype="multipart/form-data" action="">
<table class="form_table">
<tr><th>部屋タイプ名称:</th>
<td><input type="text" name="c_name" value="<?php echo $name ?>" size="64" /></td></tr>
<tr><th>画像:</th>
<td>
<?php
echo $image_filename . "<br />\n";
echo '<img src="' . BASE_URL . 'media/Reservation/Roomtype/' . $image_filename . '" width="100px" height="75px">' . "<br />\n";
?>
<input type="file" name="image" size="60" /></td></tr>
<tr><th>概要:</th>
<td><textarea name="summary" cols="50" rows="4"><?php echo $summary ?></textarea></td></tr>
<tr><th>収容可能人数:</th>
<td>
(最小)<input type="text" name="p_min" value="<?php echo $p_min ?>" size="4" />-
(最大)<input type="text" name="p_max" value="<?php echo $p_max ?>" size="4" /></td></tr>
<tr><th>部屋数:</th>
<td><input type="text" name="rooms" value="<?php echo $rooms ?>" size="4" /><br /></td></tr>
<tr><th></th>
<td><input type="submit" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $contents;
        echo $view->render('reservation.php');
    }
    
    /**
     * 部屋タイプの削除
     */
    public function deleteRoomtypeAction()
    {
        global $db, $config;
        
        // id/PlanId
        $request = $this->getRequest();
        $roomtypeId = intval($request->getParam('id'));
        
        $sql = "DELETE FROM Platy_Reservation_Roomtype WHERE id={$roomtypeId}";
        $db->query($sql);
        
        $this->_redirect('/Manage/Reservation/listRoomtype/');
    }
    
    
    /**
     * 部屋タイプ ドロップダウンリスト
     */
    private function cbo_Roomtype($default = "")
    {
        global $db;
        
        echo '<select name="roomtypeId">' . "\n";
        $sql = "SELECT id, name FROM Platy_Reservation_Roomtype";
        $rows = $db->fetchAll($sql);
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            echo '<option value="' . $row['id'] . '"';
            if ($default == $row['id']) {
                echo ' selected="true"';
            }
            echo '>';
            echo $row['name'];
            echo '</option>' , "\n";
        }
        echo '</select>' . "\n";
    }
}
?>