<?php
/**
 * ウィジェット管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_WidgetController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'Widget';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('ウィジェット', BASE_URL . 'Manage/Widget/');
    }
    
    public function indexAction()
    {
        //echo 'Manage_ContentTypeController からこんにちは';
        $this->listAction();
    }

    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * ウィジェット一覧を表示する。
     */
    public function listAction()
    {
        global $db, $base;
        
        ob_start();
        
        $Widget_path = APP_PATH . 'models/Widget/';

        echo '<h3>インストール済のウィジェット</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";
        $installed_Widget_name = array();
        $sql = "SELECT id, name FROM  Platy_Widget";
        $rows = $db->fetchAll($sql);
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            $widget_name = $row['name'];
            require_once($Widget_path . $widget_name . '.php');
            $widget_class_name = 'Platy_Widget_' . $widget_name;
            $obj = new $widget_class_name;

            echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . $obj->getSummary() . '</td>';
            echo '<td>' . $obj->getVersion() . '</td>';
            echo '<td>' . $obj->getAuthor() . '</td>';
            
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/Widget/uninstall/name/' . $row['name'] . '">uninstall</a>';
            echo '&nbsp;|&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Widget/config/name/' . $row['name'] . '">config</a>';
            echo '</td>';
            echo "</tr>\n";
            $installed_Widget_name[] = $row['name'];
        }
        echo '</table>' . "\n";
        
        echo '<h3>未インストールのウィジェット</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th>' . "\n";

        $d = dir($Widget_path);
        $i = 0;
        while (($entry = $d->read()) != FALSE) {
            if (!is_dir($Widget_path . $entry)) {
                $widget_filename = $entry;
                //echo $widget_filename . "<br />\n";
                $pos = stripos($widget_filename, '.php');
                $widget_name = substr($widget_filename, 0, $pos);
                if (!in_array($widget_name, $installed_Widget_name)) {
                    
                    require_once($Widget_path . $widget_name . '.php');
                    
                    if ($i % 2 == 0) { echo '<tr class="even">'; }
                    else { echo '<tr class="odd">'; }
                    
                    $widget_class_name = 'Platy_Widget_' . $widget_name;
                    $obj = new $widget_class_name;

                    echo '<td>' . $widget_name . '</td>';
                    echo '<td>' . $obj->getSummary() . '</td>';
                    echo '<td>' . $obj->getVersion() . '</td>';
                    echo '<td>' . $obj->getAuthor() . '</td>';
                    
                    echo '<td>';
                    echo '<a href="' . BASE_URL . 'Manage/Widget/install/name/' . $widget_name . '">install</a>' . "<br />\n";
                    echo '</td>';
                    echo '</tr>' . "\n";
                    $i++;
                }
            }
        }
        echo '</table>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 設定
     */
    public function configAction()
    {
        global $db;
        
        $request = $this->getRequest();
        $name = $request->getParam('name');
        //echo $name . "<br />\n";
        
        ob_start();
        
        require(APP_PATH . 'models/Widget/' . $name . '.php');
        $classname = 'Platy_Widget_' . $name;
        $obj = new $classname();
        $obj->config();
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * コンテンツタイプのインストール
     */
    public function installAction()
    {
        global $db;
        
        ob_start();
        
        //echo 'Manage_ContentType:installAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        //echo $name . "<br />\n";
        
        require(APP_PATH . 'models/Widget/' . $name . '.php');
        $classname = 'Platy_Widget_' . $name;
        $obj = new $classname();
        if ($obj->install() == TRUE) {
            $sql = "INSERT INTO Platy_Widget(name) VALUES('" . $name . "')";
            echo $sql . "<br />\n";
            $db->query($sql);
            echo $name . 'のインストールに成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'のインストールに失敗しました。' . "<br />\n";
        }
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * コンテンツタイプのアンインストール
     */
    public function uninstallAction()
    {
        global $db;
        
        ob_start();
        
        echo 'Manage_ContentType:uninstallAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/Widget/' . $name . '.php');
        $classname = 'Platy_Widget_' . $name;
        $obj = new $classname();
        if ($obj->uninstall() == TRUE) {
            $sql = "DELETE FROM Platy_Widget WHERE name='" . $name . "'";
            $db->query($sql);
            echo $name . 'のアンインストールに成功しました。' . "<br />\n";
        }
        else {
            echo $name . 'のアンインストールに失敗しました。' . "<br />\n";
        }
        
        // サイドバーから削除する
        $sql = "DELETE FROM Platy_Sidebar WHERE widget='" . $name . "'";
        $db->query($sql);
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * 表示
     */
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        //$view->sidebar = $this->buildSidebar();
        echo $view->render('page.php');
    }
}
?>