<?php
/**
 * Reservation(ホテル予約) モジュール
 */
require_once 'Zend/Controller/Action.php';
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';

class DbReservationResevation extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Reservation_Reservation';
    }
}

class DbReservationPlanVacancy extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Reservation_Plan_Vacancy';
    }
}

class DbReservationRoomtypeVacancy extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Reservation_Roomtype_Vacancy';
    }
}

class ReservationController extends Zend_Controller_Action
{
    public function preDispatch()
    {
        global $manage, $breadcrumb;
        
        $manage->module = 'Reservation';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('宿泊予約', BASE_URL . 'Reservation/');
    }
    
    public function indexAction()
    {
        $this->_redirect('/Reservation/listPlan/');
    }
    
    /**
     * プラン一覧の表示 (default Action)
     */
    public function listPlanAction()
    {
        global $db, $config;
        
        ob_start();
        
        $sql = "SELECT id, name, summary, image, price FROM Platy_Reservation_Plan";
        //echo $sql;
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">';
        echo '<th>名称</th><th>料金</th><th>action</th>' . "\n";
        foreach ($rows as $row) {
            echo '<tr>';
            //echo '<td>' . $row['id'] . '</td>';
            echo '<td>' . $row['name'] . '</td>';
            echo '<td>' . Platy_Util::cnv_currency($row['price']) . '</td>';
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Reservation/Vacancy/planId/' . $row['id'] . '">空き照会</a>';
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('reservation.php');
    }
    
    /**
     * プランの表示
     */
    public function viewPlanAction()
    {
        global $db, $config;
        
        // id/planId
        $request = $this->getRequest();
        $planId = intval($request->getParam('planId'));
        
        ob_start();
        
        
        
        
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('reservation.php');
    }
    
    /**
     * 空きカレンダーの表示
     */
    public function VacancyAction()
    {
        global $db, $config;
        
        // id/planId
        $request = $this->getRequest();
        $planId = intval($request->getParam('planId'));
        $request = $this->getRequest();
        $ym = $request->getParam('ym');
        if (strlen($ym) != 6) {
            // 年月の指定がないときは、現在の年月とする
            $ym = date('Ym');
        }
        
        // planIdからroomtypeIdを得る
        $sql = "SELECT roomtypeId, name FROM Platy_Reservation_Plan WHERE id={$planId}";
        //echo $sql;
        $row = $db->fetchRow($sql);
        $roomtypeId = $row['roomtypeId'];
        $planName = $row['name'];
        //echo "roomtypeId={$roomtypeId}<br />\n";
        
        ob_start();
        
        $year = substr($ym, 0, 4);
        $month = substr($ym, 4, 2);
        // 月の1日の曜日
        $month_first_week = date('w', mktime(0, 0, 0, $month, 1, $year));
        // 月の日数
        $month_days = date('t', mktime(0, 0, 0, $month, 1, $year));
        
        echo intval($year) . '年' . intval($month) . '月' . "<br />\n";
        echo $planName . "<br />\n";
        
        echo '<table class="reservation_calendar">' . "\n";
        echo '<th>日</th><th>月</th><th>火</th><th>水</th><th>木</th><th>金</th><th>土</th>' . "\n";
        $cal_col = 0;
        echo '<tr>';
        for ($i = 0; $i < $month_first_week; $i++) {
            echo '<td class="out"></td>' . "\n";
            $cal_col++;
            if ($cal_col == 7) {
                echo '</tr>';
                $cal_col = 0;
                echo '<tr>';
            }
        }
        for ($i = 1; $i <= $month_days; $i++) {
            if ($cal_col == 0) { echo '<tr>'; }
            $checkin = sprintf('%04d%02d%02d', $year, $month, $i);
            $plan_rem = $this->getVacancyPlan($checkin, $planId);
            $roomtype_rem = $this->getVacancyRoomtype($checkin, $roomtypeId);
            $rem = min($plan_rem, $roomtype_rem);
            
            $td = ''; $tds = '';
            echo '<td>';
            echo $i . '<br />';
            echo '<a href="' . BASE_URL . 'Reservation/reserve/planId/' . $planId . '/checkin/' . $checkin . '/">';
            if ($rem > 0) {
                echo '空' . $rem . '室';
            }
            else {
                echo '満室';
            }
            echo '</a>';
            //echo $rem . '|' . $plan_rem . '|' . $roomtype_rem . "<br />\n";
            echo $td;
            echo '</td>' . "\n";
            
            $cal_col++;
            if ($cal_col == 7) {
                echo '</tr>';
                $cal_col = 0;
            }
        }
        if ($cal_col > 0) {
            for ($i = $cal_col; $i < 7; $i++) {
                echo '<td class="out"></td>';
            }
        }
        echo '</tr>';
        echo '</table>' . "\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('reservation.php');

    }
    
    /**
     * 予約1/3 日付、部屋数入力
     */
    public function reserveAction()
    {
        global $db, $config;
        
        // planId/val/checkin/val
        $request = $this->getRequest();
        $planId = intval($request->getParam('planId'));
        $checkin = h($request->getParam('checkin'));
        
        $sql = "SELECT name FROM Platy_Reservation_Plan WHERE id={$planId}";
        $row = $db->fetchRow($sql);
        $plan_name = $row['name'];
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $checkout_y = intval($_POST['checkout_y']);
            $checkout_m = intval($_POST['checkout_m']);
            $checkout_d = intval($_POST['checkout_d']);
            $checkout = sprintf("%04d%02d%02d", $checkout_y, $checkout_m, $checkout_d);
            $r_num = intval($_POST['r_num']);
            $p_num = intval($_POST['p_num']);
            $params = sprintf("planId/%d/checkin/%s/checkout/%s/r_num/%d/p_num/%d/",
                            $planId, $checkin, $checkout, $r_num, $p_num);
            $this->_redirect('/Reservation/reserve2/' . $params);
        }
        else {
            $checkout = $checkin;
            $r_num = 1;
            $p_num = 1;
        }
        
        ob_start();
?>
<form method="post" action="">
<table class="form_table">
<tr><th>プラン:</th>
<td><?php echo $plan_name ?></td></tr>
<tr><th>チェックイン:</th>
<td>
<?php
$s = substr($checkin,0,4) . '-' . substr($checkin,4,2) . '-' . substr($checkin,6,2);
echo $s;echo '&nbsp;';
echo Platy_Util::getWeek($s, '(', ')');
?>
</td></tr>
<tr><th>チェックアウト:</th>
<td>
<?php
$y = substr($checkout, 0, 4);
$m = substr($checkout, 4, 2);
$d = substr($checkout, 6, 2);
$this->cbo_Checkout($y, $m, $d);
?>
</td></tr>
<tr><th>部屋数:</th>
<td>
<input type="text" name="r_num" value="<?php echo $r_num ?>" size="4" /></td></tr>
<tr><th>ご利用人数:</th>
<td><input type="text" name="p_num" value="<?php echo $p_num ?>" size="4" /></td></tr>
<tr><th></th><td>
<input type="hidden" name="planId" value="<?php echo $planId ?>" />
<input type="hidden" name="checkin" value="<?php echo $checkin ?>" />
<input type="submit" />
</td></tr>
</table>
</form>
<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('reservation.php');
    }
    
    /**
     * 予約2/3 個人情報入力
     */
    public function reserve2Action()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['submit_reserve2'])) {
            
            // validate
            // TODO
            
            $planId = intval($_POST['planId']);
            $checkin = h($_POST['checkin']);
            $checkout = h($_POST['checkout']);
            $r_num = h($_POST['r_num']);
            $p_num = h($_POST['p_num']);
            $fullname = h($_POST['fullname']);
            $email = h($_POST['email']);
            $postcode = h($_POST['postcode']);
            $address = h($_POST['address']);
            $phone = h($_POST['phone']);
            $checkin_time = h($_POST['checkin_time']);
            $comment = h($_POST['comment']);
            
            ob_start();
            
            echo "以下の内容で予約を確定します。よろしければ「確定」ボタンを押してください。<br />\n";
            echo '<table class="form_table">' . "\n";
            echo '<tr><th>チェックイン</th><td>' . $checkin . '</td></tr>' . "\n";
            echo '<tr><th>チェックアウト</th><td>' . $checkout . '</td></tr>' . "\n";
            echo '<tr><th>ご利用人数(1部屋あたり)</th><td>' . $p_num . '人</td></tr>' . "\n";
            echo '<tr><th>部屋数</th><td>' . $r_num . '部屋</td></tr>' . "\n";
            echo '<tr><th>料金</th><td>円 x 人 x 日 = 円</td></tr>' . "\n";
            echo '<tr><th>合計</th><td>円</td></tr>' . "\n";
            echo '<tr><th>お名前</th><td>' . $fullname . '</td></tr>' . "\n";
            echo '<tr><th>Eメールアドレス</th><td>' . $email . '</td></tr>' . "\n";
            echo '<tr><th>郵便番号</th><td>' . $postcode . '</td></tr>' . "\n";
            echo '<tr><th>住所</th><td>' . $address . '</td></tr>' . "\n";
            echo '<tr><th>電話番号</th><td>' . $phone . '</td></tr>' . "\n";
            echo '<tr><th>チェックイン時刻</th><td>' . $checkin_time . '</td></tr>' . "\n";
            echo '<tr><th>コメント</th><td>' . $comment . '</td></tr>' . "\n";
            echo '<tr><th></th><td>';
            
            echo '<form method="post" action="' . BASE_URL . 'Reservation/reserve3/' . '">' . "\n";
            echo '<input type="hidden" name="planId" value="' . $planId . '" />' . "\n";
            echo '<input type="hidden" name="checkin" value="' . $checkin . '" />' . "\n";
            echo '<input type="hidden" name="checkout" value="' . $checkout . '" />' . "\n";
            echo '<input type="hidden" name="p_num" value="' . $p_num . '" />' . "\n";
            echo '<input type="hidden" name="r_num" value="' . $r_num . '" />' . "\n";
            echo '<input type="hidden" name="fullname" value="' . $fullname . '" />' . "\n";
            echo '<input type="hidden" name="email" value="' . $email . '" />' . "\n";
            echo '<input type="hidden" name="postcode" value="' . $postcode . '" />' . "\n";
            echo '<input type="hidden" name="address" value="' . $address . '" />' . "\n";
            echo '<input type="hidden" name="phone" value="' . $phone . '" />' . "\n";
            echo '<input type="hidden" name="checkin_time" value="' . $checkin_time . '" />' . "\n";
            echo '<input type="hidden" name="comment" value="' . $comment . '" />' . "\n";
            
            echo '<input type="submit" value="予約を確定する" />' . "\n";
            echo '</form>' . "\n";
            
            echo '</td></tr>' . "\n";
            echo '</table>' . "\n";
            
            $contents = ob_get_contents();
            ob_end_clean();
            
            Zend_Loader::loadClass('Zend_View');
            $view = new Zend_View();
            $view->setScriptPath(APP_PATH . 'views');
            $view->contents = $contents;
            $view->config = $config;
            echo $view->render('reservation.php');
            
            return;
        }
        else {
            // planId/val/checkin/val/checkout/val/p_num/val/r_num/val/
            $request = $this->getRequest();
            $planId = intval($request->getParam('planId'));
            $checkin = $request->getParam('checkin');
            $checkout = $request->getParam('checkout');
            $r_num = $request->getParam('r_num');
            $p_num = $request->getParam('p_num');
        }
        
        $sql = "SELECT name, price FROM Platy_Reservation_Plan WHERE id={$planId}";
        $row = $db->fetchRow($sql);
        $plan_name = $row['name'];
        $plan_price = $row['price'];
        ob_start();
?>

<table class="form_table">
<tr><th>プラン:</th><td><?php echo $plan_name ?></td></tr>
<tr><th>チェックイン:</th><td><strong>
<?php
$s = substr($checkin,0,4) . '-' . substr($checkin,4,2) . '-' . substr($checkin,6,2);
echo $s;echo '&nbsp;';
echo Platy_Util::getWeek($s, '(', ')');
?>
</strong></td></tr>
<tr><th>チェックアウト:</th><td><strong>
<?php
$s = substr($checkout,0,4) . '-' . substr($checkout,4,2) . '-' . substr($checkout,6,2);
echo $s;echo '&nbsp;';
echo Platy_Util::getWeek($s, '(', ')');
?>
</strong></td></tr>
<tr><th>部屋数:</th><td><?php echo $r_num ?>部屋</td></tr>
<tr><th>ご利用人数(1部屋あたり):</th><td><?php echo $p_num ?>人</td></tr>
<tr><th>料金:</th><td>
<?php
echo Platy_Util::cnv_currency($plan_price) . 'x' . $p_num . '人' . 'x' . '日 =' . '円';
?>
</td></tr>
<tr><th>合計:</th><td>円</td></tr>
</table>

<form method="post" action="">
<table class="form_table">
<tr><th>お名前:</th><td>
<input type="text" name="fullname" value="<?php echo $fullname ?>" size="60" /></td></tr>
<tr><th>Eメールアドレス:</th><td>
<input type="text" name="email" value="<?php echo $email ?>" size="60" /></td></tr>
<tr><th>郵便番号:</th><td>
<input type="text" name="postcode" value="<?php echo $postcode ?>" size="10" /></td></tr>
<tr><th>住所:</th><td>
<input type="text" name="address" value="<?php echo $address ?>" size="60" /></td></tr>
<tr><th>電話番号:</th><td>
<input type="text" name="phone" value="<?php echo $phone ?>" size="16" /></td></tr>
<tr><th>チェックイン時刻:</th><td>
<input type="text" name="checkin_time" value="<?php echo $checkin_time ?>" size="16" /></td></tr>
<tr><th>コメント:</th><td>
<textarea name="comment" cols="50" rows="2"><?php echo $comment ?></textarea></td></tr>
<tr><th></th><td>
<input type="submit" />
<input type="hidden" name="planId" value="<?php echo $planId ?>" />
<input type="hidden" name="checkin" value="<?php echo $checkin ?>" />
<input type="hidden" name="checkout" value="<?php echo $checkout ?>" />
<input type="hidden" name="r_num" value="<?php echo $r_num ?>" />
<input type="hidden" name="p_num" value="<?php echo $p_num ?>" />
<input type="hidden" name="submit_reserve2" value="1" />
</td></tr></table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('reservation.php');
    }
    
    /**
     * 予約3/3 予約完了
     */
    public function reserve3Action()
    {
        global $db, $config;
        
        if (!($_SERVER['REQUEST_METHOD'] == 'POST' || isset($_POST['submit_reserve3']))) {
            die();
        }
        
        ob_start();
        
        var_dump($_POST);
        $planId = intval($_POST['planId']);
        $checkin = h($_POST['checkin']);
        $checkout = h($_POST['checkout']);
        $r_num = h($_POST['r_num']);
        $p_num = h($_POST['p_num']);
        $fullname = h($_POST['fullname']);
        $email = h($_POST['email']);
        $postcode = h($_POST['postcode']);
        $address = h($_POST['address']);
        $phone = h($_POST['phone']);
        $checkin_time = h($_POST['checkin_time']);
        $comment = h($_POST['comment']);
        
        $sql = "SELECT roomtypeId FROM Platy_Reservation_Plan WHERE id={$planId}";
        $row = $db->fetchRow($sql);
        $roomtypeId = $row['roomtypeId'];
        
        $lock = Platy_Util::lock('reservation.loc');
        if ($lock == false) {
            die("system error!\n");
        }
        
        // 空きがあることの確認
        $res = $this->checkVacancy($checkin, $checkout, $planId, $r_num);
        if ($res == true) {
            $tmp_y = substr($checkin, 0, 4);
            $tmp_m = substr($checkin, 4, 2);
            $tmp_d = substr($checkin, 6, 2);
            //echo $tmp_y . '|' . $tmp_m . '|' . $tmp_d . "<br />\n";
            for ($i = 0; $i < 100; $i++) {
                $tmp_date = date('Ymd', mktime(0, 0, 0, $tmp_m, $tmp_d+$i, $tmp_y));
                //echo $tmp_date . "<br />\n";
                if ($tmp_date >= $checkout) {
                    break;
                }
                //echo "UpdateV1<br />\n";
                $v1 = $this->updateVacancyRoomtype($tmp_date, $roomtypeId, $r_num);
                if ($v1 < 0) {
                    $res = false;
                    break;
                }
                //echo "UpdateV2<br />\n";
                $v2 = $this->updateVacancyPlan($tmp_date, $planId, $r_num);
                if ($v2 < 0) {
                    $res = false;
                    break;
                }
                //echo sprintf("%s:%d,%d<br />\n", $tmp_date, $emp1, $emp2);
                $table = new DbReservationResevation();
                $data['planId'] = $planId;
                $data['checkin'] = $checkin;
                $data['checkout'] = $checkout;
                $data['r_num'] = $r_num;
                $data['p_num'] = $p_num;
                $data['fullname'] = $fullname;
                $data['email'] = $email;
                $data['postcode'] = $postcode;
                $data['address'] = $address;
                $data['phone'] = $phone;
                $data['checkin_time'] = $checkin_time;
                $data['comment'] = $comment;
                $data['created'] = date('Y-m-d H:i:s');
                $data['modified'] = $data['created'];
                $table->insert($data);
            }
        }
        
        Platy_Util::unlock($lock);
        
        if ($res == false) {
            echo '予約失敗!';
        }
        else {
            echo '予約成功';
        }
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('reservation.php');
    }
    
    /**
     * プランの空きを返す
     * @param string $ymd 年月日
     * @param int $planId プランId
     */
    private function getVacancyPlan($ymd, $planId)
    {
        global $db, $config;
        
        $d = substr($ymd,0,4) . '-' . substr($ymd,4,2) . '-' . substr($ymd,6,2);
        
        $sql = "SELECT vacancy FROM Platy_Reservation_Plan_Vacancy WHERE dt='{$d}' AND planId={$planId}";
        //echo $sql . "<br />\n";
        $row = $db->fetchRow($sql);
        if ($row != NULL) {
            return $row['vacancy'];
        }
        // 空きデータがないので作成する
        $sql = "SELECT rooms FROM Platy_Reservation_Plan WHERE id={$planId}";
        $row = $db->fetchRow($sql);
        $rooms = $row['rooms'];
        $table = new DBReservationPlanVacancy();
        $data['dt'] = $d;
        $data['planId'] = $planId;
        $data['vacancy'] = $rooms;
        $table->insert($data);
        
        return $rooms;
    }
    
    /**
     * 部屋タイプの空き部屋数を返す
     * @param string $ymd 年月日
     * @param int $roomtypeId 部屋タイプId
     * @return int 空き部屋数
     */
    private function getVacancyRoomtype($ymd, $roomtypeId)
    {
        global $db, $config;
        
        $d = substr($ymd,0,4) . '-' . substr($ymd,4,2) . '-' . substr($ymd,6,2);
        $sql = "SELECT vacancy FROM Platy_Reservation_Roomtype_Vacancy WHERE dt='{$d}' AND roomtypeId={$roomtypeId}";
        //echo $sql . "<br />\n";
        $row = $db->fetchRow($sql);
        if ($row != NULL) {
            return $row['vacancy'];
        }
        // 空きデータがないので作成する
        $sql = "SELECT rooms FROM Platy_Reservation_Roomtype WHERE id={$roomtypeId}";
        $row = $db->fetchRow($sql);
        $rooms = $row['rooms'];
        $table = new DBReservationRoomtypeVacancy();
        $data['dt'] = $d;
        $data['roomtypeId'] = $roomtypeId;
        $data['vacancy'] = $rooms;
        $table->insert($data);
        
        return $rooms;
    }
    
    /**
     * 部屋タイプの空きを更新する
     * @param string $ymd 年月日(YYYYMMDD)
     * @param int $roomtypeId 部屋タイプId
     * @param int $n 予約部屋数
     * @return int 残り部屋数(負数はエラー)
     */
    private function updateVacancyRoomtype($ymd, $roomtypeId, $n)
    {
        global $db, $config;
        
        $tmpDate = substr($ymd,0,4) . '-' . substr($ymd,4,2) . '-' . substr($ymd,6,2);
        
        $sql = "SELECT vacancy FROM Platy_Reservation_Roomtype_Vacancy WHERE dt='" . $tmpDate . "' AND roomtypeId=" . $roomtypeId;
        //echo $sql . "<br />\n";
        $row = $db->fetchRow($sql);
        if ($row == null) {
            return -10;
        }
        $m = $row['vacancy'];
        if ($m - $n < 0) {
            return -1;
        }
        $sql = "UPDATE Platy_Reservation_Roomtype_Vacancy SET vacancy=" . ($m-$n) . " WHERE dt='" . $tmpDate . "' AND roomtypeId=" . $roomtypeId;
        //echo $sql . "<br />\n";
        $db->query($sql);
        
        return ($m - $n);
    }
    
    /**
     * プランの空きを更新する
     * @param string $ymd 年月日
     * @param int $planId プランId
     * @param int $n 予約部屋数
     * @return 残り部屋数(負数はエラー)
     */
    private function updateVacancyPlan($ymd, $planId, $n)
    {
        global $db, $config;
        
        $tmpDate = substr($ymd,0,4) . '-' . substr($ymd,4,2) . '-' . substr($ymd,6,2);
        
        $sql = "SELECT vacancy FROM Platy_Reservation_Plan_Vacancy WHERE dt='" . $tmpDate . "' AND planId=" . $planId;
        //echo $sql . "<br />\n";
        $row = $db->fetchRow($sql);
        if ($row == null) {
            return -10;
        }
        $m = $row['vacancy'];
        if ($m - $n < 0) {
            return -1;
        }
        $sql = "UPDATE Platy_Reservation_Plan_Vacancy SET vacancy=" . ($m-$n) . " WHERE dt='" . $tmpDate . "' AND planId=" . $planId;
        //echo $sql . "<br />\n";
        $db->query($sql);
        
        return ($m - $n);
    }
    
    /**
     * 空があることのチェック
     * @param  string $checkin  チェックイン日付(YYYYMMDD)
     * @param  string $checkout チェックアウト日付(YYYYMMDD)
     * @param  int    $planId   プランID
     * @param  int    $rooms    部屋数
     * @return bool   空があればTRUE,無ければFALSEを返す
     */
    private function checkVacancy($checkin, $checkout, $planId, $r_num)
    {
        global $db, $config;
        $res = true;
        
        $sql = "SELECT roomtypeId FROM Platy_Reservation_Plan WHERE id={$planId}";
        $row = $db->fetchRow($sql);
        $roomtypeId = $row['roomtypeId'];
        //echo $roomtypeId . "<br />\n";
        
        $tmp_y = substr($checkin, 0, 4);
        $tmp_m = substr($checkin, 4, 2);
        $tmp_d = substr($checkin, 6, 2);
        for ($i = 0;;$i++) {
            $tmp_date = date('Ymd', mktime(0, 0, 0, $tmp_m, $tmp_d+$i, $tmp_y));
            if ($tmp_date >= $checkout) {
                break;
            }
            $v1 = $this->getVacancyRoomtype($tmp_date, $roomtypeId);
            if ($v1 < $r_num) { 
                $res = FALSE;
                break;
            }
            $v2 = $this->getVacancyPlan($tmp_date, $planId);
            if ($v2 < $r_num) {
                $res = FALSE;
                break;
            }
        }
        return $res;
    }
    
    /**
     * ymd入力
     */
    function cbo_Checkout($y = 0, $m = 0, $d = 0) {
        $this_y = intval(substr(date('Ymd'),0,4));
        echo '<select name="checkout_y">' . "\n";
        for ($i = 0; $i <= 1; $i++) {
            echo '<option value="' . ($this_y + $i) . '"';
            if (($this_y+$i) == $y) { echo ' selected'; }
            echo '>' . ($this_y+$i) . '</option>' . "\n";
        }
        echo '</select>' . '年' . "\n";
        
        echo '<select name="checkout_m">' . "\n";
        for ($i = 1; $i <= 12; $i++) {
            echo '<option value="' . $i . '"';
            if ($i == $m) { echo ' selected'; }
            echo '>' . $i . '</option>' . "\n";
        }
        echo '</select>' . '月' . "\n";
        
        echo '<select name="checkout_d">' . "\n";
        for ($i = 1; $i <= 31; $i++) {
            echo '<option value="' . $i . '"';
            if ($i == $d) { echo ' selected'; }
            echo '>' . $i . '</option>' . "\n";
        }
        echo '</select>' . '日' . "\n";
    }
}
?>