<?php
/**
 * Syndication(サイト配信) モジュール
 * 
 */
require_once 'Zend/Controller/Action.php';

define(MAX_ENTRY, 5);   // 表示件数

class SyndicationController extends Zend_Controller_Action
{
    public function indexAction()
    {
        global $config;
        
        ob_start();
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->contents = $contents;
        $view->config = $config;
        echo $view->render('page.php');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * RecentEntry
     */
    public function recententryAction() {
        global $db, $config, $manager;
        
        $sql = "SELECT id FROM Platy_Content_Base WHERE type != 'Folder' ORDER BY modified DESC";
        $rows = $db->fetchAll($sql);
        $n = MAX_ENTRY;
        if (count($rows) < MAX_ENTRY) { $n = count($rows); }
        
        header("Pragma: no-cache");
        header("Content-Type: application/xml");
        echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
        echo '<rss version="2.0">' . "\n";
        echo '<channel>' . "\n";
        echo '<title>' . $config['S_SITE_NAME'] . '</title>' . "\n";
        echo '<link>' . BASE_FULL_URL . '</link>' . "\n";
        echo '<description>' . $config['S_SITE_SLOGAN'] . '</description>' . "\n";
        echo '<language>ja</language>' . "\n";
        
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            $NodeId = $row['id'];
            $content = getContentFromNodeId($NodeId);
            echo '<item>' . "\n";
            echo '<title>' . $content['title'] . '</title>' . "\n";
            echo '<link>' . BASE_URL . $content['url'] . '</link>' . "\n";
            echo '<description>';
            echo '<![CDATA[ ' . "\n";
            //echo $content['summary'];
            echo $manager->parseCVar($content['summary']);
            echo ']]>' . "\n";
            echo '</description>' . "\n";
            echo '<pubDate>';
            $rfc822_time = date('r', strtotime($content['modified']));
            echo $rfc822_time;
            echo '</pubDate>' . "\n";
            echo '</item>' . "\n";
            //var_dump($content);
        }
        
        echo '</channel>' . "\n";
        echo '</rss>' . "\n";
    }
    
    /**
     * RecentNews
     */
    public function recentnewsAction() {
        global $db, $config, $manager;
        
        $sql = "SELECT id FROM Platy_Content_Base WHERE type = 'News' ORDER BY modified DESC";
        $rows = $db->fetchAll($sql);
        $n = MAX_ENTRY;
        if (count($rows) < MAX_ENTRY) { $n = count($rows); }
        
        header("Pragma: no-cache");
        header("Content-Type: application/xml");
        echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
        echo '<rss version="2.0">' . "\n";
        echo '<channel>' . "\n";
        echo '<title>' . $config['S_SITE_NAME'] . '</title>' . "\n";
        echo '<link>' . BASE_FULL_URL . '</link>' . "\n";
        echo '<description>' . $config['S_SITE_SLOGAN'] . '</description>' . "\n";
        echo '<language>ja</language>' . "\n";
        
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            $NodeId = $row['id'];
            $content = getContentFromNodeId($NodeId);
            echo '<item>' . "\n";
            echo '<title>' . $content['title'] . '</title>' . "\n";
            echo '<link>' . BASE_URL . $content['url'] . '</link>' . "\n";
            echo '<description>';
            echo '<![CDATA[ ' . "\n";
            //echo $content['summary'];
            echo $manager->parseCVar($content['summary']);
            echo ']]>' . "\n";
            echo '</description>' . "\n";
            echo '<pubDate>';
            $rfc822_time = date('r', strtotime($content['modified']));
            echo $rfc822_time;
            echo '</pubDate>' . "\n";
            echo '</item>' . "\n";
            //var_dump($content);
        }
        
        echo '</channel>' . "\n";
        echo '</rss>' . "\n";
    }
}
?>