<?php
/**
 * コメント CExt
 */
require_once 'Platy/CExt.php';

class Platy_CExt_Comment extends Platy_CExt
{
    function install() 
    {
        global $db;
        
        $sql[] = "CREATE TABLE Platy_CExt_Comment("
             . "id          integer PRIMARY KEY,"
             . "cid         integer NOT NULL,"
             . "memberId    int DEFAULT 0,"
             . "name        varchar(64),"
             . "email       varchar(255),"
             . "title       varchar(255),"
             . "comment     text,"
             . "created     datetime,"
             . "ip_addr     varchar(32));";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('P_COMMENT_PROHIBITION_PERIOD', '180')";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('P_COMMENT_PROHIBITION_WORD', '')";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('P_COMMENT_TITLE', 'no')";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('P_COMMENT_ALLOW_GUEST', 'yes')";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('P_COMMENT_USE_CAPTCHA', 'no')";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    function uninstall() 
    {
        global $db;
        
        $sql[] = "DROP TABLE Platy_CExt_Comment";
        $sql[] = "DELETE FROM Platy_Config WHERE name='P_COMMENT_PROHIBITION_PERIOD'";
        $sql[] = "DELETE FROM Platy_Config WHERE name='P_COMMENT_PROHIBITION_WORD'";
        $sql[] = "DELETE FROM Platy_Config WHERE name='P_COMMENT_TITLE'";
        $sql[] = "DELETE FROM Platy_Config WHERE name='P_COMMENT_ALLOW_GUEST'";
        $sql[] = "DELETE FROM Platy_Config WHERE name='P_COMMENT_USE_CAPTCHA'";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    // イベントハンドラ
    
    function event_PostContentFooter() 
    {
        global $db, $currentContent, $Me;
        
        $sql = "SELECT COUNT(*) "
             . "FROM Platy_CExt_Comment "
             . "WHERE cid={$currentContent['id']} ";
        $row = $db->fetchRow($sql);
        echo '<a href="' . $currentContent['url'] . '#comment">';
        echo 'comments(' . $row['COUNT(*)'] . ')';
        echo '</a>' . "\n";
    }
    
    function event_PostContent() {
        global $db, $currentContent, $Me;
        
        /* コメント削除 */
        if (isset($_REQUEST['KP_comment_delete'])) {
        }
        
        /* コメントが送信された */
        if (isset($_POST['P_Comment_post'])) {
            $type = $currentContent['type'];
            $cid = $currentContent['id'];
            $memberId = 0;
            $name = '';
            $email = '';
            if ($Me->isLoggedIn()) {
                $memberId = $Me->id;
                $comment = h($_POST['comment']);
            }
            else {
                $name = h($_POST['name']);
                $email = h($_POST['email']);
            }
            $comment = h($_POST['comment']);
            $created = date('Y-m-d H:i:s');
            $ip_addr = '';
            
            if ($comment != '') {
                $sql = 'INSERT INTO Platy_CExt_Comment(cid,memberId,name,email,comment,created) VALUES('
                     . "{$cid},{$memberId},"
                     . $db->quote($name) . ","
                     . $db->quote($email) . ","
                     . $db->quote($comment) . ","
                     . "'{$created}')";
                $db->query($sql);
            }
        }
        
        $sql = "SELECT id, memberId, name, email, title, comment, created "
             . "FROM Platy_CExt_Comment "
             . "WHERE cid={$currentContent['id']} "
             . "ORDER BY created DESC";
//             . "ORDER BY created ASC";
        //echo $sql . "<br />\n";
        $rows = $db->fetchAll($sql);
        
        $n = count($rows);
        echo '<a name="comment"></a>' . "\n";   // ページ内リンク
        echo '<h4>Comments(' . $n . ')</h4>' . "\n";

        for ($i = 0; $i < count($rows); $i++) {
            echo '<div class="comment">' . "\n";
            echo $rows[$i]['comment'] . "<br />\n";
            if ($rows[$i]['memberId'] >= 1) {
                echo 'by ' . Platy_Util::getUsername($rows[$i]['memberId']);
            }
            else {
                echo 'by ' . $rows[$i]['name'];
            }
            echo '&nbsp; on ' . $rows[$i]['created'];
            echo "</div>\n";
        }
        
        echo '<h4>Add Comment</h4>' . "\n";
        echo '<form method="post" action="">' . "\n";
        echo '<dl>' , "\n";
        if ($Me->isLoggedIn()) {
            echo 'ユーザ名:' . Platy_Util::getUsername($Me->id);
        }
        else {
            echo '<dt>お名前</dt>';
            echo '<dd><input type="text" name="name" size="40" />' . "</dd>\n";
            echo '<dt>メールアドレス</dt>';
            echo '<dd><input type="text" name="email" size="40" />' . "</dd>\n";
        }
        echo '<dt>コメント</dt>' . "\n";
        echo '<dd><textarea name="comment" rows="4" cols="40"></textarea></dd>' . "\n";
        echo '<input type="submit" value="コメントを追加" />' . "\n";
        echo '<input type="hidden" name="P_Comment_post" />' . "\n";
        echo '</dl>' . "\n";
        echo '</form>' . "\n";
    }
    
    function event_DeleteContent() 
    {
        global $db, $currentContent, $Me;
        $sql = "DELETE "
             . "FROM Platy_CExt_Comment "
             . "WHERE cid={$currentContent['id']} ";
        $db->exec($sql);
    }
    
    function deleteCType($name) 
    {
    }
    
    /**
     * 設定
     */
    function config() {
        global $db, $config;
        if (isset($_POST['submit_cext_config'])) {
            $prohibition_period = intval($_POST['prohibition_period']);
            $prohibition_word = h($_POST['prohibition_word']);
            $title = h($_POST['title']);
            $allow_guest = h($_POST['allow_guest']);
            $sql = "UPDATE kbl_config SET value='{$prohibition_period}' WHERE name='KP_COMMENT_PROHIBITION_PERIOD'";
            $db->exec($sql);
            $sql = "UPDATE kbl_config SET value='{$prohibition_word}' WHERE name='KP_COMMENT_PROHIBITION_WORD'";
            $db->exec($sql);
            $sql = "UPDATE kbl_config SET value='{$title}' WHERE name='KP_COMMENT_TITLE'";
            $db->exec($sql);
            $sql = "UPDATE kbl_config SET value='{$allow_guest}' WHERE name='KP_COMMENT_ALLOW_GUEST'";
            $db->exec($sql);
        }
        else {
            $prohibition_period = $kbl_config['KP_COMMENT_PROHIBITION_PERIOD'];
            $prohibition_word = $kbl_config['KP_COMMENT_PROHIBITION_WORD'];
            $title = $kbl_config['KP_COMMENT_TITLE'];
            $allow_guest = $kbl_config['KP_COMMENT_ALLOW_GUEST'];
        }
?>
<h3>コメント設定</h3>
<form method="post" action="?action=config">
禁止期間:<input type="text" name="prohibition_period" value="<?php echo $prohibition_period ?>" size="8" /><br />
禁止ワード:<input type="text" name="prohibition_word" value="<?php echo $prohibition_word ?>" size="60" /><br />
件名の表示:<?php kbl_form::select_yesno('title', $title) ?><br />
ゲストの投稿許可:<?php kbl_form::select_yesno('allow_guest', $allow_guest) ?><br />
<input type="submit" />
<input type="hidden" name="cext_name" value="comment" />
<input type="hidden" name="submit_cext_config" />
</form>
<?php
    }
    
    public function getSummary()
    {
        return 'コンテンツにコメントを付加します';
    }
}
?>
