<?php
/**
 * Geo CExt
 */
require_once 'Platy/CExt.php';

class Platy_CExt_Geo extends Platy_CExt
{
    public function install()
    {
        global $db;
        
        $sql[] = "CREATE TABLE Platy_CExt_Geo("
             . "id          integer PRIMARY KEY,"
             . "lat         double,"
             . "lng         double,"
             . "zoom        int,"
             . "html        text"
             . ");";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        
        $sql[] = "DROP TABLE Platy_CExt_Geo";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    // イベントハンドラ
    
    public function event_AddContentFormExtras()
    {
        global $config;
        
        if (isset($_POST['submit_content'])) {
            $lat = floatval($_POST['cext_geo_lat']);
            $lng = floatval($_POST['cext_geo_lng']);
            $zoom = intval($_POST['cext_geo_zoom']);
            $html = h($_POST['cext_geo_html']);
        }
        else {
            $lat = 37.4419;
            $lng = -122.1419;
            $zoom = 13;
            $html = '';
        }
        
        echo '<tr><th>Geometric Data</th><td>';
?>
<script type="text/javascript" src="http://www.google.com/jsapi?key=<?php echo $config['S_GOOGLEMAPS_KEY'] ?>"></script>
<script type="text/javascript">
  google.load("maps", "2.x");
  function geo_initialize() {
    var map = new google.maps.Map2(document.getElementById("map_canvas"));
    map.addControl(new GSmallMapControl());
    map.addControl(new GMapTypeControl());
    map.setCenter(new google.maps.LatLng(<?php echo $lat ?>, <?php echo $lng ?>), <?php echo $zoom ?>);
    var point = new GLatLng(<?php echo $lat ?>, <?php echo $lng ?>);
    var marker = new GMarker(point);
    map.addOverlay(marker);
    GEvent.addListener(map, 'click', function(overlay, point) {
        var marker = new GMarker(new GPoint(point.x, point.y));
        map.clearOverlays();
        map.addOverlay(marker);
        document.f.cext_geo_lng.value=point.x;
        document.f.cext_geo_lat.value=point.y;
    });
    GEvent.addListener(map, "zoomend", function(oldLevel, newLevel) {
        document.f.cext_geo_zoom.value=newLevel;
    });
  }
  google.setOnLoadCallback(geo_initialize);
</script>
<div id="map_canvas" style="width: 100%; height: 300px"></div>
lat:<input type="text" name="cext_geo_lat" value="" size="20" />
lng:<input type="text" name="cext_geo_lng" value="" size="20" />
zoom:<input type="text" name="cext_geo_zoom" value="" size="4" /><br />
<?php
        echo '</td></tr>' . "\n";
    }
    
    public function event_PostAddContent()
    {
        $this->event_PostEditContent();
    }
    
    public function event_EditContentFormExtras()
    {
        global $config, $db, $currentContent, $Me;
        
        if (isset($_POST['submit_content'])) {
            if (isset($_POST['cext_geo_enb'])) {
                $enb = true;
            }
            else {
                $enb = false;
            }
            $lat = floatval($_POST['cext_geo_lat']);
            $lng = floatval($_POST['cext_geo_lng']);
            $zoom = intval($_POST['cext_geo_zoom']);
            $html = h($_POST['cext_geo_html']);
        }
        else {
            $id = $currentContent['id'];
            $sql = "SELECT lat, lng, zoom, html FROM Platy_CExt_Geo WHERE id={$id}";
            $row = $db->fetchRow($sql);
            if ($row) {
                $enb = true;
                $lat = $row['lat'];
                $lng = $row['lng'];
                $zoom = $row['zoom'];
                $html = $row['html'];
            }
            else {
                $enb = false;
                $lat = 37.4419;
                $lng = -122.1419;
                $zoom = 13;
                $html = '';
            }
        }
        
        echo '<tr><th>Geometric Data</th><td>';
?>
<script type="text/javascript" src="http://www.google.com/jsapi?key=<?php echo $config['S_GOOGLEMAPS_KEY'] ?>"></script>
<script type="text/javascript">
  google.load("maps", "2.x");
  function geo_initialize() {
    var map = new google.maps.Map2(document.getElementById("map_canvas"));
    map.addControl(new GSmallMapControl());
    map.addControl(new GMapTypeControl());
    map.setCenter(new google.maps.LatLng(<?php echo $lat ?>, <?php echo $lng ?>), <?php echo $zoom ?>);
    var point = new GLatLng(<?php echo $lat ?>, <?php echo $lng ?>);
    var marker = new GMarker(point);
    map.addOverlay(marker);
    GEvent.addListener(map, 'click', function(overlay, point) {
        var marker = new GMarker(new GPoint(point.x, point.y));
        map.clearOverlays();
        map.addOverlay(marker);
        document.f.cext_geo_lng.value=point.x;
        document.f.cext_geo_lat.value=point.y;
    });
    GEvent.addListener(map, "zoomend", function(oldLevel, newLevel) {
        document.f.cext_geo_zoom.value=newLevel;
    });
  }
  google.setOnLoadCallback(geo_initialize);
</script>
<div id="map_canvas" style="width: 100%; height: 300px"></div>
<input type="checkbox" name="cext_geo_enb" <?php if ($enb == true) { echo 'checked="true"'; } ?> />位置情報を登録する<br />
lat:<input type="text" name="cext_geo_lat" value="<?php echo $lat ?>" size="20" />
lng:<input type="text" name="cext_geo_lng" value="<?php echo $lng ?>" size="20" />
zoom:<input type="text" name="cext_geo_zoom" value="<?php echo $zoom ?>" size="4" /><br />
<?php
        echo '</td></tr>' . "\n";
    }
    
    function event_PostEditContent()
    {
        global $db, $currentContent, $Me;
        
        $id = $currentContent['id'];
        $sql = "DELETE FROM Platy_CExt_Geo WHERE id={$id}";
        $db->query($sql);
        
        if (isset($_POST['cext_geo_enb'])) {
            $lat = floatval($_POST['cext_geo_lat']);
            $lng = floatval($_POST['cext_geo_lng']);
            $zoom = intval($_POST['cext_geo_zoom']);
            $sql = "INSERT INTO Platy_CExt_Geo(id, lat, lng, zoom, html) VALUES("
                 . $id . ','
                 . $lat . ','
                 . $lng . ','
                 . $zoom . ','
                 . "'')";
            $db->query($sql);
        }
    }
    
    function event_PostContentFooter() 
    {
        global $db, $currentContent, $Me;
    }
    
    function event_PostContent()
    {
        global $db, $currentContent, $Me, $config;
        
        $sql = "SELECT id, lat, lng, zoom, html "
             . "FROM Platy_CExt_Geo "
             . "WHERE id={$currentContent['id']} ";
        $row = $db->fetchRow($sql);
        if ($row) {
            $lat = $row['lat'];
            $lng = $row['lng'];
            $zoom = $row['zoom'];
            $html = $row['html'];
?>
<script type="text/javascript" src="http://www.google.com/jsapi?key=<?php echo $config['S_GOOGLEMAPS_KEY'] ?>"></script>
<script type="text/javascript">
  google.load("maps", "2.x");
  function geo_initialize() {
    var map = new google.maps.Map2(document.getElementById("map_canvas"));
    map.addControl(new GSmallMapControl());
    map.addControl(new GMapTypeControl());
    map.setCenter(new google.maps.LatLng(<?php echo $lat ?>, <?php echo $lng ?>), <?php echo $zoom ?>);
    var point = new GLatLng(<?php echo $lat ?>, <?php echo $lng ?>);
    var marker = new GMarker(point);
    map.addOverlay(marker);
  }
  google.setOnLoadCallback(geo_initialize);
</script>
<div id="map_canvas" style="width: 100%; height: 300px"></div>
<?php
        } /* /if */
    }
    
    public function getSummary()
    {
        return 'コンテンツにGeometric Data(地図)を付加します';
    }
}
?>
