<?php
/**
 * News 変数
 */
require_once 'Platy/CVar.php';

class Platy_CVar_News extends Platy_CVar
{
    private $max_entry = 5;
    
    function install() { return true; }
    function uninstall() { return true; }
    
    public function getSummary()
    {
        return 'newsコンテンツのダイジェストを表示する';
    }
    
    public function doCVar($param)
    {
        global $db;
        
        $sql = "SELECT id FROM Platy_Content_Base WHERE type = 'News' ORDER BY modified DESC";
        $rows = $db->fetchAll($sql);
        $n = $this->max_entry;
        if (count($rows) < $this->max_entry) { $n = count($rows); }
        for ($i = 0; $i < $n; $i++) {
            $row = $rows[$i];
            $NodeId = $row['id'];
            $content = getContentFromNodeId($NodeId);
            echo '<a href="' . BASE_URL . $content['url'] . '">';
            echo $content['title'];
            echo '&nbsp;(' . $content['modified'] . ')';
            echo '</a>' . "<br />\n";
            //var_dump($content);
        }
        
        return true;
    }
    
    public function getVersion()
    {
        return '0.0.0';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
}
?>
