<?php
/**
 * フォーラム モジュール
 */
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/Module.php';
require_once 'Platy/SystemDB.php';
require_once 'Platy/Form.php';

class Platy_Module_Forum extends Platy_Module
{
    public function install()
    {
        global $db;
        $sql[] = "CREATE TABLE Platy_Forum_Category ("
               . "id                integer PRIMARY KEY,"
               . "title             varchar(255),"
               . "ordering          int DEFAULT 0,"
               . "created           datetime,"
               . "modified          datetime,"
               . "memberId          int DEFAULT 0);";
        $sql[] = "CREATE TABLE Platy_Forum_Forum ("
               . "id                integer PRIMARY KEY,"
               . "catId             int DEFAULT 0,"
               . "title             varchar(255),"
               . "description       text,"
               . "memberId          int DEFAULT 0,"
               . "status            varchar(64),"
               . "startDate         datetime,"
               . "endDate           datetime,"
               . "ordering          int DEFAULT 0,"
               . "view              int DEFAULT 0,"
               . "created           datetime,"
               . "modified          datetime);";
        $sql[] = "CREATE TABLE Platy_Forum_Topic ("
               . "id                integer PRIMARY KEY,"
               . "forumId           int NOT NULL,"
               . "title             varchar(255),"
               . "memberId          int DEFAULT 0,"
               . "status            char(12),"
               . "startDate         datetime,"
               . "endDate           datetime,"
               . "ordering          int DEFAULT 0,"
               . "view              int DEFAULT 0,"
               . "created           datetime,"
               . "modified          datetime);";
        $sql[] = "CREATE TABLE Platy_Forum_Post ("
               . "id                integer PRIMARY KEY,"
               . "forumId           int DEFAULT NULL,"
               . "topicId           int DEFAULT NULL,"
               . "subject           varchar(255),"
               . "message           text,"
               . "memberId          int DEFAULT NULL,"
               . "status            char(12),"
               . "created           datetime,"
               . "modified          datetime,"
               . "ip                varchar(15));";
        for ($i = 0; $i < count($sql); $i++) {
            echo $sql[$i] . "<br />\n";
            $db->query($sql[$i]);
        }
        
        // メニューアイテム追加
        $item = array('bar'=>'global', 'type'=>'module', 'title'=>'フォーラム', 'module_name'=>'Forum', 'module_param' => '');
        addToMenu($item);
        
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        
        $sql[] = "DROP TABLE Platy_Forum_Category";
        $sql[] = "DROP TABLE Platy_Forum_Forum";
        $sql[] = "DROP TABLE Platy_Forum_Topic";
        $sql[] = "DROP TABLE Platy_Forum_Post";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function getName()
    {
        return 'Forum';
    }
    
    public function getTitle()
    {
        return 'フォーラム';
    }
    
    public function getSummary()
    {
        return 'フォーラム';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
}
?>