<?php
/**
 * ホテル予約 モジュール
 */
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/Module.php';
require_once 'Platy/SystemDB.php';
require_once 'Platy/Form.php';

class Platy_Module_Reservation extends Platy_Module
{
    public function install()
    {
        global $db;
        
        $sql[] = "CREATE TABLE Platy_Reservation_Roomtype ("
               . "id            integer PRIMARY KEY,"
               . "name          varchar(255),"
               . "summary       text,"
               . "description   text,"
               . "equipment     varchar(255),"
               . "rooms         int,"
               . "image         varchar(255),"
               . "p_min         int,"
               . "p_max         int,"
               . "created       datetime,"
               . "modified      datetime)";
        $sql[] = "CREATE TABLE Platy_Reservation_Plan ("
               . "id            integer PRIMARY KEY,"
               . "name          varchar(255),"
               . "summary       text,"
               . "description   text,"
               . "roomtypeId    int,"
               . "rooms         int DEFAULT 1,"
               . "price         int,"
               . "image         varchar(255),"
               . "startDate     date,"
               . "endDate       date,"
               . "created       datetime,"
               . "modified      datetime)";
        $sql[] = "CREATE TABLE Platy_Reservation_Reservation ("
               . "id            integer PRIMARY KEY,"
               . "memberId      int,"
               . "status        int DEFAULT 0,"
               . "checkin       date,"
               . "checkout      date,"
               . "p_num         int DEFAULT 0,"
               . "r_num         int DEFAULT 0,"
               . "planId        int,"
               . "plan_name     varchar(255),"
               . "plan_price    int,"
               . "total_price   int,"
               . "fullname      varchar(128),"
               . "email         varchar(255),"
               . "postcode      char(12),"
               . "address       varchar(255),"
               . "phone         char(16),"
               . "checkin_time  char(4),"
               . "comment       text,"
               . "created       datetime,"
               . "modified      datetime)";
        $sql[] = "CREATE TABLE Platy_Reservation_ResOption ("
               . "resId         int NOT NULL,"
               . "optionId      int,"
               . "optionName    varchar(255),"
               . "value         int)";
        $sql[] = "CREATE TABLE Platy_Reservation_Option ("
               . "id            integer PRIMARY KEY,"
               . "name          varchar(255),"
               . "description   text,"
               . "image         varchar(255),"
               . "ordering      int,"
               . "price         int,"
               . "unit          varchar(64),"
               . "startDate     date,"
               . "endDate       date,"
               . "created       datetime,"
               . "modified      datetime)";
        $sql[] = "CREATE TABLE Platy_Reservation_Roomtype_Vacancy ("
               . "id            integer PRIMARY KEY,"
               . "dt            date,"
               . "roomtypeId    int NOT NULL,"
               . "vacancy       int)";
        $sql[] = "CREATE TABLE Platy_Reservation_Plan_Vacancy ("
               . "id            integer PRIMARY KEY,"
               . "dt            date,"
               . "planId        int NOT NULL,"
               . "vacancy       int)";
        $sql[] = "CREATE TABLE Platy_Reservation_Config ("
               . "name          varchar(255),"
               . "value         text)";
        
        for ($i = 0; $i < count($sql); $i++) {
            echo $sql[$i] . "<br />\n";
            $db->query($sql[$i]);
        }
        
        // メニューアイテム追加
        $item = array('bar'=>'global', 'type'=>'module', 'title'=>'宿泊予約', 'module_name'=>'Reservation', 'module_param' => '');
        addToMenu($item);
        
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        
        $sql[] = "DROP TABLE Platy_Reservation_Roomtype";
        $sql[] = "DROP TABLE Platy_Reservation_Plan";
        $sql[] = "DROP TABLE Platy_Reservation_Reservation";
        $sql[] = "DROP TABLE Platy_Reservation_ResOption";
        $sql[] = "DROP TABLE Platy_Reservation_Option";
        $sql[] = "DROP TABLE Platy_Reservation_Roomtype_Vacancy";
        $sql[] = "DROP TABLE Platy_Reservation_Plan_Vacancy";
        $sql[] = "DROP TABLE Platy_Reservation_Config";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function getName()
    {
        return 'Reservation';
    }
    
    public function getTitle()
    {
        return 'ホテル予約';
    }
    
    public function getSummary()
    {
        return 'ホテル予約';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
}
?>