<?php
/**
 * VbsOJ[h
 */
class Shop_Cart
{
    public $items;
    public $current_index;
    
    // Constructor
    function __construct() {
        $this->items = array();
        $this->current_index = 1;
    }
    
    /**
     * J[gɃACeǉ
     * @param int $productId iId
     * @param int $qty 
     * @param $option
     */
    public function add($productId, $qty = 1, $option = NULL) 
    {
        global $db;
        
        if (is_array($this->items)) {
            foreach ($this->items as &$item) {
                if ($item['productId'] == $productId) {
                    if (array_intersect($item['option'], $option) == $option) {
                        $item['qty'] += $qty;
                        return;
                    }
                }
            }
        }
        
        $sql = "SELECT b.title, p.selling_price, p.special_price, p.image "
             . "FROM Platy_Content_Base b, Platy_Content_Product p "
             . "WHERE b.id=" . $productId . " AND b.id=p.id";
        var_dump($sql);
        
        $row = $db->fetchRow($sql);
        $title = $row['title'];
        $special_price = $row['special_price'];
        $selling_price = $row['selling_price'];
        $image = $row['image'];
        
        ($special_price != 0) ? ($price = $special_price) : ($price = $selling_price);
        
        // IvV (option_name:option_value ...)
        $option_string = '';
        if (is_array($option)) {
            while (list($key, $value) = each($option)) {
                $sql = "SELECT title FROM kbl_shop_option WHERE id=" . $key;
                $stmt = $db->prepare($sql);
                $stmt->execute();
                while (($row = $stmt->fetch()) == TRUE) {
                    $option_string .= $row['title'] . ':';
                    break;
                }
                $stmt = null;
                $sql = "SELECT title FROM kbl_shop_option_value WHERE id=" . $value;
                $stmt = $db->prepare($sql);
                $stmt->execute();
                while (($row = $stmt->fetch()) == TRUE) {
                    $option_string .= $row['title'] . "\n";
                    break;
                }
                $stmt = null;
            }
        }
        
        $this->items[] = array(
            'index' => $this->current_index++,
            'productId' => $productId,
            'option' => $option,
            'qty' => $qty,
            'title' => $title,
            'image' => $image,
            'option_string' => $option_string,
            'price' => $price);
    }
    
    /**
     * J[gACe폜
     * @param int $id J[gIndex
     */
    public function delete($index) {
        //echo 'delete:' . $index . "<br />\n";
        var_dump($this->items);
        var_dump($this->current_index);
        
        for ($i = 0; $i < $this->current_index; $i++) {
            if (isset($this->items[$i])) {
                if ($this->items[$i]['index'] == $index) {
                    unset($this->items[$i]);
                    return true;
                }
            }
        }
        
        return false;
    }
    
    /**
     * J[g̃NA
     */
    public function clear() {
        $this->items = array();
        $this->index = 1;
    }
    
    /**
     * ʂ̍XV
     * @param int $index  J[gIndex
     * @param int $qty 
     */
    public function update($index, $qty) {
        foreach ($this->items as &$item) {
            if ($item['index'] == $index) {
                $item['qty'] = $qty;
                return;
            }
        }
    }
    
    /**
     * J[g̒󂩂ǂԂ
     * @return bool Ȃtrue,łȂfalseԂ
     */
    public function isEmpty() {
        (count($this->items) == 0) ? true : false;
    }
    
    public function items() {
        return $this->items;
    }
}
?>