<?php
/**
 * NodeはZend Frameworkでうまく扱えないので、独自に実装する。
 * 2008-05-01～ /rootフォルダ対応
 */

define(DISPLAY_FOLDER, 0);  // フォルダの表示(0:しない,1:する)

$manager->module = 'Node';

$sidebarSetId = 1;
$menuSetId  = 1;
$view_mode = 'summary';
$ordering_mode = 'ordering';

ob_start();

$serverRoot = '';
//echo 'REQUEST_URI:' . $_SERVER['REQUEST_URI'] . "&nbsp;";

$currentPath = $_SERVER['REQUEST_URI'];
$currentNode = substr($_SERVER['REQUEST_URI'], strlen(BASE_URL)-1);
//echo 'currentPath:' . $currentPath . "<br />\n";
//echo 'currentNode:' . $currentNode . "<br />\n";
//echo 'strlen(BASE_URL)=' . strlen(BASE_URL) . "<br />\n";
//echo 'strlen(REQUEST_URI)=' . strlen($_SERVER['REQUEST_URI']) . "<br />\n";

Zend_Loader::loadClass('Zend_View');
$view = new Zend_View();
$view->setScriptPath(BASE_PATH . 'theme/' . $config['S_THEME']);

$str = substr($currentPath, -1);
if ($str == '/') {

    /**
     * パスの最後が / の場合は、フォルダ指定
     * フォルダ指定のときは、フォルダ内のすべてのコンテンツのサマリを表示する
     */
    $folder_param = array();
    $currentNodeId = getFolderIdFromPath($currentNode, false, true, $folder_param);
    //echo 'currentNodeId:' . $currentNodeId . "<br />\n";
    
    //var_dump($folder_param);
    $sidebarSetId = $folder_param['sidebarSetId'];
    $menuSetId = $folder_param['menuSetId'];
    $view_mode = $folder_param['view_mode'];
    
    // フォルダ情報の取得
    $sql = "SELECT title, summary FROM Platy_Content_Base WHERE id={$currentNodeId}";
    $row = $db->fetchRow($sql);
    if ($row['title'] != '') {
        echo '<h2>' . $row['title'] . '</h2>' . "\n";
    }
    if ($row['summary'] != '') {
        echo $row['summary'] . "<br />\n";
    }
    
    $sql = "SELECT id FROM Platy_Content_Node WHERE parentId={$currentNodeId} ORDER BY ordering";
    //echo $sql;
    $rows = $db->fetchAll($sql);
    //var_dump($rows);
    foreach ($rows as $row) {
        $id = $row['id'];
        $sql2 = "SELECT type, name FROM Platy_Content_Base WHERE id={$id}";
        //echo $sql2;
        $row2 = $db->fetchRow($sql2);
        $ContentType = $row2['type'];
        $url = BASE_FULL_URL . substr($currentNode, 1) . $row2['name'];
        $currentContent = array('type'=>$ContentType, 'id'=>$id, 'url'=>$url);
        
        if (DISPLAY_FOLDER == 0 && $ContentType == 'Folder') {
        }
        else {
            require_once(APP_PATH . 'models/CType/' . $ContentType . '.php');
            $classname = 'Platy_CType_' . $ContentType;
            $obj = new $classname($id);
            //var_dump($obj);
            
            // status,期間のチェック
            $startDate = $obj->startDate;
            $endDate = $obj->endDate;
            $status = $obj->status;
            if ($status == 'public' && checkPeriod($startDate, $endDate) == true) {
            
                $a = $obj->view($view_mode);
                if (is_array($a)) {
                    $view->content_pre = $a['pre'];
                    $view->content_title = $a['title'];
                    $view->content_icons = $a['icons'];
                    $view->content_header = $a['header'];
                    $view->content_main = $a['main'];
                    $view->content_footer = $a['footer'];
                    $view->content_post = $a['post'];
                    echo $view->render('content.php');
                }
            }
        }
    }

}
else {
    
    //echo "<br />\n";

    /**
     * パスの最後が / でない場合は、コンテンツ指定
     * コンテンツ指定のときは、コンテンツの内容を表示する
     */
    $folder_param = array();
    $a = getContentFromPath($currentNode, true, $folder_param);
    if (is_array($a)) {
        
        //var_dump($folder_param);
        $sidebarSetId = $folder_param['sidebarSetId'];
        $menuSetId = $folder_param['menuSetId'];
        $view_mode = $folder_param['view_mode'];
        
        //var_dump($a);
        $ContentType = $a['type'];
        $contentId = $a['id'];
        //$url = BASE_FULL_URL . substr($currentNode, 1) . $a['name'];
        $url = BASE_FULL_URL . substr($currentNode, 1);
        
        $currentContent = array('type'=>$ContentType, 'id'=>$contentId, 'url'=>$url);
        
        require(APP_PATH . 'models/CType/' . $ContentType . '.php');
        $classname = 'Platy_CType_' . $ContentType;
        $obj = new $classname($contentId);
        // status,期間のチェック
        // TODO
        $startDate = $obj->startDate;
        $endDate = $obj->endDate;
        $status = $obj->status;
        if ($status == 'public' && checkPeriod($startDate, $endDate) == true) {
            $a = $obj->view('description');
            if (is_array($a)) {
                $view->content_pre = $a['pre'];
                $view->content_title = $a['title'];
                $view->content_icons = $a['icons'];
                $view->content_header = $a['header'];
                $view->content_main = $a['main'];
                $view->content_footer = $a['footer'];
                $view->content_post = $a['post'];
                echo $view->render('content.php');
            }
        }
    }
    else {
        echo "Page not found!<br />\n";
    }
}

$contents = ob_get_contents();
ob_end_clean();
//echo $contents;

Zend_Loader::loadClass('Zend_View');
$view = new Zend_View();
//$view->setScriptPath(APP_PATH . 'views');
$view->setScriptPath(BASE_PATH . 'theme/' . $config['S_THEME']);
$view->contents = $contents;
$view->config = $config;
$view->breadcrumb = $breadcrumb->getContents();
$view->sidebar = buildSidebar($sidebarSetId);
$view->menu_header = buildMenu('header', $menuSetId);
$view->menu_global = buildMenu('global', $menuSetId);
$view->menu_footer = buildMenu('footer', $menuSetId);
$view->js_files = $js_helper->listFiles();
$view->css_files = $css_helper->listFiles();
echo $view->render('page.php');
?>