<?php
/**
 * Image Helper
 */

class ImageHelper
{
    public $mode = 'GD';
    
    /**
     * 画像をリサイズする
     * @param string $in 元ファイル
     * @param string $out リサイズ後の画像サイズ
     * @param int $w 画像幅
     * @param int $h 画像高さ
     * @param bool $ar アスペクト比を保存する(true:はい,false:いいえ)
     * @return bool 正常のときはtrue,エラーのときはfalseを返す
     */
    public function resize($in, $out, $w, $h, $ar = true)
    {
        $ret = false;
        switch ($this->mode) {
        case 'GD':
            $ret = $this->GD_resize($in, $out, $w, $h, $ar);
            break;
        }
        return $ret;
    }
    
    private function GD_resize($in, $out, $w, $h, $ar)
    {
        list($orgwidth, $orgheight, $type) = getimagesize($in);
        if (!($type == 1 || $type == 2 || $type == 3)) {
            // 1 = GIF, 2 = JPG, 3 = PNG
            return false;
        }
        if ($ar == true) {
            $this->fitImage($w, $h, $orgwidth, $orgheight, $newwidth, $newheight);
        } else {
            $newwidth = $w;
            $newheight = $h;
        }
        $thumb = imagecreatetruecolor($newwidth, $newheight);
        if ($type == 1) {
            $source = imagecreatefromgif($in);
        } else if ($type == 2) {
            $source = imagecreatefromjpeg($in);
        } else if ($type == 3) {
            $source = imagecreatefrompng($in);
        }
        // リサイズ
        imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth, $newheight, $orgwidth, $orgheight);

        // 出力
        if ($type == 1) {
            $source = imagegif($thumb, $out);
        } else if ($type == 2) {
            $source = imagejpeg($thumb, $out);
        } else if ($type == 3) {
            $source = imagepng($thumb, $out);
        }
        return true;
    }
    
    /**
     * 枠サイズにフィットする画像幅、高さを返す
     */
    public function fitImage($disp_w, $disp_h, $img_w, $img_h, &$ret_w, &$ret_h) {
        $tmp_x = $disp_w / $img_w;
        $tmp_y = $disp_h / $img_h;
        ($tmp_x <= $tmp_y) ? ($ar = $tmp_x) : ($ar = $tmp_y);
        $newwidth = ceil($img_w * $ar);
        $newheight = ceil($img_h * $ar);
        $ret_w = $newwidth;
        $ret_h = $newheight;
    }
}
?>