<?php
/**
 * モジュール管理
 */
require_once 'Zend/Controller/Action.php';

class Manage_ModuleController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'Module';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('モジュール', BASE_URL . 'Manage/Module/');
    }
    
    public function indexAction()
    {
        $this->listAction();
    }
    
    public function noRouteAction()
    {
        echo "noRouteAction";
    }
    
    /**
     * モジュール一覧を表示する。
     */
    public function listAction()
    {
        global $db;
        
        ob_start();
        
        echo '<h3>インストール済のモジュール</h3>' . "\n";
        
        $installed_module_name = array();
        
        $sql = "SELECT id, name, title, created, modified FROM Platy_Module";
        $rows = $db->fetchAll($sql);
        
        echo '<table class="list_table">' . "\n";
        echo '<tr><th>id</th><th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th></tr>' . "\n";
        for ($i = 0; $i < count($rows); $i++) {
            
            if ($i % 2 == 0) { echo '<tr class="even">'; }
            else { echo '<tr class="odd">'; }
            
            echo '<td>' . $rows[$i]['id'] . '</td>';
            echo '<td>' . $rows[$i]['name'] . '</td>';
            //echo '<td>' . $rows[$i]['created'] . '</td>';
            
            $module_name = $rows[$i]['name'];
            require_once(APP_PATH . 'models/Module/' . $module_name . '.php');
            $class_name = 'Platy_Module_' . $module_name;
            $obj = new $class_name;

            echo '<td>';
            echo $obj->getSummary();
            echo '</td>';
            
            echo '<td>';
            echo $obj->getVersion();
            echo '</td>';
            
            echo '<td>';
            echo $obj->getAuthor();
            echo '</td>';
            
            echo '<td>';
            echo '<a href="' . BASE_URL . 'Manage/' . $rows[$i]['name'] . '/">';
            echo '<img src="' . BASE_URL . 'media/system/wrench.png" alt="manage">';
            echo '管理</a>';
            echo '&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Module/sbmenu/name/' . $rows[$i]['name'] . '/">';
            echo '<img src="' . BASE_URL . 'media/system/wrench.png" alt="manage">';
            echo 'サイドバー・メニュー</a>';
            echo '&nbsp;';
            echo '<a href="' . BASE_URL . 'Manage/Module/uninstall/name/' . $rows[$i]['name'] . '">';
            echo '<img src="' . BASE_URL . 'media/system/package_delete.png" alt="delete">';
            echo 'アンインストール</a>';
            echo '</td>';
            echo '</tr>' . "\n";
            
            $installed_module_name[] = $rows[$i]['name'];
        }
        echo '</table>' . "\n";
        
        echo '<h3>未インストールのモジュール</h3>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<tr><th>name</th><th>summary</th><th>ver</th><th>author</th><th>action</th></tr>' . "\n";
        // APP_PATH . 'models/Module' のファイル一覧
        $Module_path = APP_PATH . 'models/Module/';
        $d = dir($Module_path);
        
        $i = 0;
        while (($entry = $d->read()) != FALSE) {
            if (!is_dir($Module_path . $entry)) {

                $module_filename = $entry;
                //echo $ctype_filename . "<br />\n";
                $pos = stripos($module_filename, '.php');
                $module_name = substr($module_filename, 0, $pos);
                //if (!in_array($ctype_name, $installed_ctype)) {
                //    echo '<option value="' . $ctype_name . '">' . $ctype_name . '</option>' . "\n";
                //}
                
                
                if (!in_array($module_name, $installed_module_name)) {
                    if ($i % 2 == 0) { echo '<tr class="even">'; }
                    else { echo '<tr class="odd">'; }
                    echo '<td>' . $module_name . '</td>';
                    
                    require_once(APP_PATH . 'models/Module/' . $module_name . '.php');
                    $class_name = 'Platy_Module_' . $module_name;
                    $obj = new $class_name;
                    
                    echo '<td>';
                    echo $obj->getSummary();
                    echo '</td>';
                    
                    echo '<td>';
                    echo $obj->getVersion();
                    echo '</td>';
                    
                    echo '<td>';
                    echo $obj->getAuthor();
                    echo '</td>';
                    
                    echo '<td>';
                    echo '<a href="' . BASE_URL . 'Manage/Module/install/name/' . $module_name . '">';
                    echo '<img src="' . BASE_URL . 'media/system/package_add.png" alt="install">';
                    echo 'インストール</a>';
                    echo '</td>';
                    echo "</tr>\n";
                    $i++;
                }
                
                
            }
        }
        echo '</table>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    /**
     * モジュールのインストール
     */
    public function installAction()
    {
        global $db;
        
        $request = $this->getRequest();
        $name = $request->getParam('name');
        //echo $name . "<br />\n";
        
        require(APP_PATH . 'models/Module/' . $name . '.php');
        $classname = 'Platy_Module_' . $name;
        $obj = new $classname();
        $result = $obj->install();
        if ($result == true) {
            $title = $obj->getTitle();
            $sql = "INSERT INTO Platy_Module(name, title) VALUES('{$name}', '{$title}')";
            $db->query($sql);
        }
        
        $this->_redirect('/Manage/Module/');
    }
    
    /**
     * モジュールのアンインストール
     */
    public function uninstallAction()
    {
        global $db;
        
        //ob_start();
        
        //echo 'Manage_ContentType:uninstallAction()' . "<br />\n";
        $request = $this->getRequest();
        $name = $request->getParam('name');
        echo $name . "<br />\n";
        
        require(APP_PATH . 'models/Module/' . $name . '.php');
        $classname = 'Platy_Module_' . $name;
        $obj = new $classname();
        $result = $obj->uninstall();
        if ($result == true) {
            $title = $obj->getTitle();
            $sql = "DELETE FROM Platy_Module WHERE name='{$name}'";
            $db->query($sql);
            
        }
        
        // モジュールメニューの削除
        $sql = "DELETE FROM Platy_Menu WHERE type='module' AND module_name='{$name}'";
        $db->query($sql);
        
        $this->_redirect('/Manage/Module/');

        //$contents = ob_get_contents();
        //ob_end_clean();
        
        //Zend_Loader::loadClass('Zend_View');
        //$view = new Zend_View();
        //$view->setScriptPath(APP_PATH . 'Manage/views');
        //$view->contents = $contents;
        //echo $view->render('page.php');

    }
    
    /**
     * サイドバー＆メニュー設定
     */
    public function sbmenuAction()
    {
        global $db;
        
        $request = $this->getRequest();
        $name = $request->getParam('name');

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $sidebarSetId = intval($_POST['sidebarSetId']);
            $menuSetId = intval($_POST['menuSetId']);
            $sql = "";
            
        }
        else {
            $sql = "SELECT sidebarSetId, menuSetId FROM Platy_Module WHERE name=" . $db->quote($name);
            $row = $db->fetchRow($sql);
            $sidebarSetId = $row['sidebarSetId'];
            $menuSetId = $row['menuSetId'];
        }
        
        ob_start();
        
        echo '<h2>' . $name . 'のサイドバー・メニュー設定</h2>' . "\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><td>sidebarSet</td>';
        echo '<td>' . "\n";
        
        echo '<select name="sidebarSetId">' . "\n";
        $sql = "SELECT id, name FROM Platy_SidebarSet";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo '<option value="' . $row['id'] . '">' . $row['name'] . '</option>' . "\n";
        }
        echo '</select>' . "\n";
        
        echo '</td></tr>' . "\n";
        echo '<tr><td>menuSet</td>';
        echo '<td>' . "\n";
        
        echo '<select name="menuSetId">' . "\n";
        $sql = "SELECT id, name FROM Platy_MenuSet";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo '<option value="' . $row['id'] . '">' . $row['name'] . '</option>' . "\n";
        }
        echo '</select>';
        
        echo '</td></tr>';
        echo '<tr><td></td><td>';
        echo '<input type="submit" />' . "\n";
        echo '</td></tr>';
        echo '</table>';
        echo '</form>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        echo $view->render('page.php');
    }
}
?>