<?php
/**
 * サイト情報
 */
require_once 'Zend/Controller/Action.php';

class Manage_SiteController extends Zend_Controller_Action
{
    private $contents;
    
    public function preDispatch()
    {
        global $Me, $currentManage, $breadcrumb;
        
        if ($Me->isAllowed('Manage_Site') == false) {
            $this->_redirect('/Manage/Login/');
        }
        $currentManage = 'Site';
        $breadcrumb->add('管理', BASE_URL . 'Manage/');
        $breadcrumb->add('サイト情報', BASE_URL . 'Manage/Site/');
    }
    
    public function indexAction()
    {
        $this->configAction();
    }
    
    public function configAction()
    {
        global $db, $config;
        
        ob_start();
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            
            // validate
            // TODO
            
            $config['S_SITE_NAME'] = h($_POST['site_name']);
            $config['S_SITE_SLOGAN'] = h($_POST['site_slogan']);
            $config['S_SITE_LOGO'] = intval($_POST['site_logo']);
            $config['S_META_KEYWORDS'] = h($_POST['meta_keywords']);
            $config['S_META_DESCRIPTION'] = h($_POST['meta_description']);
            $config['S_ADMIN_EMAIL'] = h($_POST['admin_email']);
            $config['S_THEME'] = h($_POST['theme']);
            $config['S_GOOGLEMAPS_KEY'] = h($_POST['googlemaps_key']);
            $config['S_CONTENT_AUTHOR'] = intval($_POST['content_author']);
            $config['S_CONTENT_DATE'] = intval($_POST['content_date']);
            $config['S_PRINT_PAGE'] = intval($_POST['print_page']);
            $config['S_FRINEND_EMAIL'] = intval($_POST['friends_email']);
            $config['S_GOOGLEANALYTICS_CODE'] = h($_POST['googleanalytics_code']);
            
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_SITE_NAME'] . "' WHERE name='S_SITE_NAME'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_SITE_SLOGAN'] . "' WHERE name='S_SITE_SLOGAN'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_SITE_LOGO'] . "' WHERE name='S_SITE_LOGO'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_META_KEYWORDS'] . "' WHERE name='S_META_KEYWORDS'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_META_DESCRIPTION'] . "' WHERE name='S_META_DESCRIPTION'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_THEME'] . "' WHERE name='S_THEME'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_GOOGLEMAPS_KEY'] . "' WHERE name='S_GOOGLEMAPS_KEY'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_GOOGLEANALYTICS_CODE'] . "' WHERE name='S_GOOGLEANALYTICS_CODE'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_CONTENT_AUTHOR'] . "' WHERE name='S_CONTENT_AUTHOR'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_CONTENT_DATE'] . "' WHERE name='S_CONTENT_DATE'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_PRINT_PAGE'] . "' WHERE name='S_PRINT_PAGE'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['S_FRIENDS_EMAIL'] . "' WHERE name='S_FRIENDS_EMAIL'";
            if (!DEMO) {
                $sql[] = "UPDATE Platy_Config set value='" . $config['S_ADMIN_EMAIL'] . "' WHERE name='S_ADMIN_EMAIL'";
            }
            for ($i = 0; $i < count($sql); $i++) {
                try {
                    $db->query($sql[$i]);
                }
                catch (Exception $e) {
                    echo $sql[$i];
                    $profiler = $db->getProfiler();
                    $query = $profiler->getLastQueryProfile();
                    echo $query->getQuery();
                    echo $e->getMessage();
                }
            }
        }
        $site_name = $config['S_SITE_NAME'];
        $site_slogan = $config['S_SITE_SLOGAN'];
        $site_logo = $config['S_SITE_LOGO'];
        $site_logo_image = $config['S_SITE_LOGO_IMAGE'];
        $meta_keywords = $config['S_META_KEYWORDS'];
        $meta_description = $config['S_META_DESCRIPTION'];
        $admin_email = $config['S_ADMIN_EMAIL'];
        $theme = $config['S_THEME'];
        $googlemaps_key = $config['S_GOOGLEMAPS_KEY'];
        $googleanalytics_code = $config['S_GOOGLEANALYTICS_CODE'];
        $content_author = $config['S_CONTENT_AUTHOR'];
        $content_date = $config['S_CONTENT_DATE'];
        $print_page = $config['S_PRINT_PAGE'];
        $frineds_email = $config['S_FRINEDS_EMAIL'];
        
        echo '<h2>サイト情報</h2>' . "\n";
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">';
        echo "<tr><th>サイト名</th><td>";
        echo '<input type="text" name="site_name" value="' . $site_name . '" size="60" />';
        echo "</td></tr>\n";
        echo "<tr><th>スローガン</th><td>";
        echo '<input type="text" name="site_slogan" value="' . $site_slogan . '" size="60" />';
        echo "</td></tr>\n";
        echo "<tr><th>ロゴ</th><td>";
        echo "ロゴスタイル:";
        echo '<select name="site_logo">' . "\n";
        echo '<option value="0" ';
        if ($site_logo == 0) { echo 'selected="true"'; }
        echo '>0:文字のみ</option>' . "\n";
        echo '<option value="1" ';
        if ($site_logo == 1) { echo 'selected="true"'; }
        echo '>1:画像のみ</option>' . "\n";
        echo '<option value="2" ';
        if ($site_logo == 2) { echo 'selected="true"'; }
        echo '>2:画像+文字</option>' . "\n";
        echo '</select>' . "\n";
        if ($site_logo_image != '') {
            echo '<img src="' . BASE_URL . 'media/image/' . $site_logo_image . '" width="100px" height="50px" />' . "\n";
        }
        echo "</td></tr>\n";

        
        echo "<tr><th>META_KEYWORDS</th><td>";
        echo '<input type="text" name="meta_keywords" value="' . $meta_keywords . '" size="60" />';
        echo "</td></tr>\n";
        echo "<tr><th>META_DESCRIPTION</th><td>";
        echo '<input type="text" name="meta_description" value="' . $meta_description . '" size="60" />';
        echo "</td></tr>\n";
        echo "<tr><th>管理者Eメールアドレス</th><td>\n";
        if (DEMO) {
            echo 'デモでは設定できません';
        }
        else {
            echo '<input type="text" name="admin_email" value="' . $admin_email . '" size="60" />';
        }
        echo "</td></tr>\n";
        
        echo "<tr><th>テーマ</th><td>";
        echo '<select name="theme">' . "\n";
        $themes = Platy_Util::getDir(BASE_PATH . 'theme/');
        //var_dump($themes);
        for ($i = 0; $i < count($themes); $i++) {
            if ($themes[$i] == 'manage') { continue; }
            echo '<option value="' . $themes[$i] . '"';
            if ($themes[$i] == $theme) { echo ' selected="true"'; }
            echo '>';
            echo $themes[$i];
            echo '</option>' . "\n";
        }
        echo '</select>' . "\n";
        echo "</td></tr>\n";
        
        echo "<tr><th>Google Maps Key</th><td>";
        echo '<input type="text" name="googlemaps_key" value="' . $googlemaps_key . '" size="60" />';
        echo "</td></tr>\n";
        echo "<tr><th>Google Analytics Code</th><td>";
        echo '<input type="text" name="googleanalytics_code" value="' . $googleanalytics_code . '" size="60" />';
        echo "</td></tr>\n";
        
        echo "<tr><th>コンテンツの著者表示</th><td>";
        echo '<input type="radio" name="content_author" VALUE="1"';
        if ($content_author == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="content_author" VALUE="0"';
        if ($content_author == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        
        echo "</td></tr>\n";
        echo "<tr><th>コンテンツの日付表示</th><td>";
        echo '<input type="radio" name="content_date" VALUE="1"';
        if ($content_author == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="content_date" VALUE="0"';
        if ($content_author == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo "</td></tr>\n";
        
        echo "<tr><th>印刷用ページ</th><td>";
        echo '<input type="radio" name="print_page" VALUE="1"';
        if ($print_page == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="print_page" VALUE="0"';
        if ($print_page == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo "</td></tr>\n";

        echo "</td></tr>\n";
        echo "<tr><th>友人にメールで知らせる</th><td>";
        echo '<input type="radio" name="frineds_email" VALUE="1"';
        if ($frineds_email == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="friends_email" VALUE="0"';
        if ($frineds_email == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo "</td></tr>\n";

        echo "<tr><th></th><td>";
        echo '<input type="submit" value="サイト情報を更新する" />' . "</td></tr>\n";
        echo "</table>" . "\n";
        echo '</form>' . "\n";
        
        $this->contents = ob_get_contents();
        ob_end_clean();
        
        $this->view();
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * 表示
     */
    private function view()
    {
        global $breadcrumb;
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'Manage/views');
        $view->contents = $this->contents;
        $view->breadcrumb = $breadcrumb->getContents();
        //$view->sidebar = $this->buildSidebar();
        echo $view->render('page.php');
    }
}
?>