<?php
/**
 * 保留コンテンツ表示 ウィジェット
 */

require_once 'Platy/Widget.php';

class Platy_Widget_PendingContent extends Platy_Widget
{
    public function install() { return true; }
    public function uninstall() { return true; }
    
    public function getSummary()
    {
        return 'Pending Content';
    }
    
    public function show()
    {
        global $db, $Me;
        
        // 権限チェック
        global $Me;
        if ($Me->isAllowed('Manage_Contents') == false && $Me->isAllowed('Approve_Contents') == false) {
            return;
        }
        
        $sql = "SELECT id, title FROM Platy_Content_Base WHERE status='pending' ORDER BY modified";
        $rows = $db->fetchAll($sql);
        if (count($rows) >= 1) {
            echo '<div class="widget">' . "\n";
            echo '<div class="title">保留コンテンツ</div>' . "\n";
            echo '<div class="main">' . "\n";
            echo '<ul>' . "\n";
            for ($i = 0; $i < count($rows); $i++) {
                $row = $rows[$i];
                echo '<li>';
                echo '<a href="' . BASE_URL . 'Manage/Node/edit/id/' . $row['id'] . '">';
                echo $row['title'];
                echo '</a>';
                echo '</li>' . "\n";
            }
            echo '</ul>' . "\n";
            echo '</div>' . "\n";
            echo '</div>' . "\n";
        }
    }
}
?>