<?php
/**
 * お問い合わせ モジュール
 * 
 */
require_once 'Platy/Form.php';
require_once 'Zend/Controller/Action.php';

class ContactController extends Zend_Controller_Action
{
    public $admin_email;
    private $sidebarSetId;
    private $menuSetId;
    
    public function preDispatch()
    {
        global $manager, $breadcrumb, $db;
        
        $manager->module = 'Contact';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('お問い合わせ', BASE_URL . 'Contact/');
        
        $sql = "SELECT sidebarSetId, menuSetId FROM Platy_Module WHERE name='Contact'";
        $row = $db->fetchRow($sql);
        $this->sidebarSetId = $row['sidebarSetId'];
        $this->menuSetId = $row['menuSetId'];
    }
    
    public function indexAction()
    {
        global $config, $breadcrumb;
        global $db, $menuSetId, $js_helper, $css_helper;

        $this->admin_email =  $config['S_ADMIN_EMAIL'];
        
        $errors = array();
        
        ob_start();
        
        //echo 'ContactController:indexAction';
        
        echo '<h2>お問い合わせ</h2>' . "\n";
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            //echo 'POSTed' . "<br />\n";
            $fullname = h($_POST['fullname']);
            $email = h($_POST['email']);
            $subject = h($_POST['subject']);
            $message = h($_POST['message']);
            if (isset($_POST['email_copy'])) { $email_copy = true; }
            else { $email_copy = false; }
            
            // validation
            if ($fullname == '') {
                $errors[] = 'お名前を入力してください。';
            }
            if ($email == '') {
                $errors[] = 'Eメールアドレスを入力してください。';
            }
            if ($message == '') {
                $errors[] = '内容を入力してください。';
            }
            
            if (!count($errors)) {
                /*
                 * Zend_Mail は日本語が使えるのか不明なので、mb_sendmail()で送信する
                 */
                mb_language('Japanese');            // E-Mailエンコーディング ISO-2022-JP/Base64
                mb_internal_encoding('UTF-8');      // 内部エンコーディング
                
                $mail_subject = $config['S_SITE_NAME'] . ':お問い合わせがありました';
                $mail_to = $this->admin_email;
                $mail_body = 
                    "以下の内容でお問い合わせがありました。\n" .
                    "[お名前]\n" . $fullname . "\n" .
                    "[Eメールアドレス]\n" . $email . "\n" .
                    "[件名]\n" . $subject . "\n" .
                    "[内容]\n" .
                    $message;
                $ret = @mb_send_mail($mail_to, $mail_subject, $mail_body);
                
                if ($email_copy == true) {
                    $copy_to = $email;
                    $copy_body = $message;
                    $copy_subject = $subject;
                    $ret2 = @mb_send_mail($copy_to, $copy_subject, $copy_body);
                }
                
                echo "担当者にお問い合わせ内容のメールを送信しました。<br />\n";
                echo "内容を確認し次第、ご連絡致します。<br />\n";
                echo "お問い合わせ頂きありがとうございました。<br />\n";
                
            }
        }
        
        if ($_SERVER['REQUEST_METHOD'] != 'POST' || count($errors)) {
            
            if (count($errors)) {
                $error_msg .= "<ul>\n";
                for ($i = 0; $i < count($errors); $i++) {
                    $error_msg .= '<li>' . $errors[$i] . '</li>' . "\n";
                }
                $error_msg .= "</ul>\n";
                MsgBox($error_msg, "", "WARNING");
            }
            
            echo '<form method="post" action="">' . "\n";
            echo '<table class="form_table">' . "\n";
            echo '<tr><th>お名前';
            Platy_Form::form_required();
            echo '</th>';
            echo '<td><input type="text" name="fullname" size="60" />' . "</td></tr>\n";
            echo '<tr><th>Eメールアドレス';
            Platy_Form::form_required();
            echo '</th>';
            echo '<td><input type="text" name="email" size="60" />' . "</td></tr>\n";
            echo '<tr><th>件名</th>';
            echo '<td><input type="text" name="subject" size="60" />' . "</td></tr>\n";
            echo '<tr><th>内容';
            Platy_Form::form_required();
            echo '</th>';
            echo '<td><textarea name="message" rows="6" cols="50"></textarea>' . "</td></tr>\n";
            echo '<tr><th></th><td><input type="checkbox" name="email_copy" checked="checked " />送信メールの控えを受け取る' . "</td></tr>\n";
            echo '<tr><th></th><td><input type="submit" value="送信する" />' . "</td></tr>\n";
            echo '</table>' . "\n";
            echo '</form>' . "\n";
        }
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH .'views');
        $view->contents = $contents;
        $view->config = $config;
        $view->breadcrumb = $breadcrumb->getContents();
        $view->sidebar = buildSidebar($this->sidebarSetId);
        $view->menu_header = buildMenu('header', $this->menuSetId);
        $view->menu_global = buildMenu('global', $this->menuSetId);
        $view->menu_footer = buildMenu('footer', $this->menuSetId);
        $view->js_files = $js_helper->listFiles();
        $view->css_files = $css_helper->listFiles();
        echo $view->render('page.php');
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
}
?>