<?php
/**
 * Forum モジュール
 * 
 */
require_once 'Zend/Controller/Action.php';
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';

class DbForumCategory extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Category';
    }
}

class DbForumForum extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Forum';
    }
}

class DbForumTopic extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Topic';
    }
}

class DbForumPost extends Zend_Db_Table {
    protected function _setupTableName()
    {
        $this->_name = 'Platy_Forum_Post';
    }
}

class ForumController extends Zend_Controller_Action
{
    public $admin_email;
    
    public function preDispatch()
    {
        global $manage, $breadcrumb;
        
        $manage->module = 'Forum';
        $breadcrumb->add('ホーム', BASE_URL);
        $breadcrumb->add('フォーラム', BASE_URL . 'Forum/');
    }
    
    public function indexAction()
    {
        $this->listForumAction();
    }
    
    public function noRouteAction()
    {
        //$this->_redirect('/');
        echo "noRouteAction";
    }
    
    /**
     * フォーラム一覧の表示
     */
    public function listForumAction()
    {
        global $db, $config;
        
        ob_start();
        
        $sql = "SELECT id, title FROM Platy_Forum_Category";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo $row['title'] . "<br />\n";
            
            echo '<table class="list_table">' . "\n";
            echo '<th>id</th><th>forum</th><th>topics</th><th>posts</th><th>last post</th>' . "\n";
            
            $sql2 = "SELECT id, title, description, created, modified FROM Platy_Forum_Forum";
            $rows2 = $db->fetchAll($sql2);
            for ($j = 0; $j < count($rows2); $j++) {
                $row2 = $rows2[$j];
                echo '<tr>';
                echo '<td>' . $row2['id'] . '</td>';
                echo '<td>';
                echo '<strong>';
                echo '<a href="' . BASE_URL . 'Forum/listTopic/forumId/' . $row2['id'] . '">';
                echo $row2['title'];
                echo '</a>';
                echo '</strong>' . "<br />\n";
                echo $row2['description'];
                echo '</td>';
                
                echo '<td>';
                $sql3 = "SELECT COUNT(*) FROM Platy_Forum_Topic WHERE forumId=" . $row2['id'];
                $row3 = $db->fetchRow($sql3);
                if ($row3['COUNT(*)'] >= 1) { echo $row3['COUNT(*)']; } else { echo 0; }
                echo '</td>';
                
                echo '<td>';
                $sql3 = "SELECT COUNT(*) FROM Platy_Forum_Post WHERE forumId=" . $row2['id'];
                $row3 = $db->fetchRow($sql3);
                if ($row3['COUNT(*)'] >= 1) { echo $row3['COUNT(*)']; } else { echo 0; }
                echo '</td>';
                
                echo '<td>';
                $sql3 = "SELECT memberId, created FROM Platy_Forum_Post WHERE forumId=" . $row2['id'] . " ORDER BY created DESC";
                $row3 = $db->fetchRow($sql3);
                echo $row3['created'] . "<br />\n";
                if ($row3['memberId'] > 0) {
                    echo Platy_Util::getUsername($row3['memberId']);
                }
                echo '</td>';
                echo '</tr>';
                
            }
            echo '</table>' . "\n";
            
        }
        

        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->config = $config;
        $view->contents = $contents;
        echo $view->render('module.php');
    }
    
    /**
     * トピック一覧の表示
     */
    public function listTopicAction()
    {
        global $db, $config;
        
        $request = $this->getRequest();
        $forumId = intval($request->getParam('forumId'));
        
        ob_start();
        
        $sql = "SELECT title FROM Platy_Forum_Forum WHERE id={$forumId}";
        $row = $db->fetchRow($sql);
        $forum_title = $row['title'];
        echo $forum_title . "<br />\n";
        
        $sql = "SELECT id, title, memberId, view, created, modified "
             . "FROM Platy_Forum_Topic "
             . "WHERE forumId=" . $forumId . " "
             . "ORDER BY created";
        $rows = $db->fetchAll($sql);
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>topics</th><th>replies</th><th>author</th><th>views</th><th>last post</th>' . "\n";
        foreach ($rows as $row) {
            echo '<tr>';
            echo '<td>' . $row['id'] . '</td>';
            
            echo '<td>';
            echo '<strong>';
            echo '<a href="' . BASE_URL . 'Forum/listPost/topicId/' . $row['id'] . '">';
            echo $row['title'];
            echo '</a>';
            echo '</strong>' . "<br />\n";
            echo '</td>';
            
            echo '<td>';
            $sql2 = "SELECT COUNT(*) FROM Platy_Forum_Post WHERE topicId=" . $row['id'];
            $row2 = $db->fetchRow($sql);
            if ($row2['COUNT(*)'] >= 1) { echo $row2['COUNT(*)']-1; } else { echo 0; }
            echo '</td>';
            
            echo '<td>';
            if ($row['memberId'] > 0) { echo Platy_Util::getUsername($row['memberId']); }
            echo '</td>';
            
            echo '<td>' . $row['view'] . '</td>';
            
            echo '<td>';
            $sql2 = "SELECT memberId, created FROM Platy_Forum_Post WHERE topicId=" . $row['id'] . " ORDER BY created DESC";
            $row2 = $db->fetchRow($sql2);
            echo $row2['created'] . "<br />\n";
            if ($row2['memberId'] > 0) { echo Platy_Util::getUsername($row2['memberId']); }
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        // 新規トピックへのリンク
        echo '<a href="' . BASE_URL . 'Forum/addTopic/forumId/' . $forumId . '">' . "\n";
        echo '新規トピック';
        echo '</a>' . "<br />\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->config = $config;
        $view->contents = $contents;
        echo $view->render('module.php');
    }
    
    /**
     * 新規トピックの投稿
     */
    public function addTopicAction()
    {
        global $db, $config, $Me;
        
        $request = $this->getRequest();
        $forumId = intval($request->getParam('forumId'));
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $subject = h($_POST['subject']);
            $message = h($_POST['message']);
            $uid = $Me->id;
            $created = date('Y-m-d H:i:s');
            
            $created = date('Y-m-d H:i:s');
            // Topicに追加
            $table = new DBForumTopic();
            $topic['forumId'] = $forumId;
            $topic['title'] = $subject;
            $topic['memberId'] = $Me->id;
            $topic['created'] = $created;
            $topic['modified'] = $created;
            $table->insert($topic);
            
            $topicId = $db->lastInsertId();
            
            // Postに追加
            $table = new DBForumPost();
            $post['subject'] = $subject;
            $post['message'] = $message;
            $post['forumId'] = $forumId;
            $post['topicId'] = $topicId;
            $post['created'] = $created;
            $post['modified'] = $created;
            $post['memberId'] = $Me->id;
            $table->insert($post);
            
            $this->_redirect('/Forum/listTopic/forumId/' . $forumId);
        }
        else {
            $subject = '';
            $message = '';
        }
        
        ob_start();
?>
<form method="post" action="">
<table class="form_table">
<tr><th>Subject:</th><td>
<input type="text" name="subject" size="60" value="<?php echo $subject ?>" /></td></tr>
<tr><th>message:</th><td>
<textarea name="message" rows="4" cols="60">
<?php echo $message ?>
</textarea></td></tr>
<tr><th></th><td>
<input type="submit" /></td></tr>
</table>
</form>

<?php
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->config = $config;
        $view->contents = $contents;
        echo $view->render('module.php');
    }
    
    /**
     * トピックの削除
     */
    function deleteTopicAction() {
    }
    
    /**
     * トピックへの投稿一覧
     */
    function listPostAction() {
        global $db, $config, $Me;
        
        $request = $this->getRequest();
        $topicId = intval($request->getParam('topicId'));
        
        // Topicのviewをカウントアップ
        $sql = "UPDATE Platy_Forum_Topic SET view=view+1 WHERE id={$topicId}";
        $db->query($sql);
        
        ob_start();
        
        echo '<table class="list_table">' . "\n";
        echo '<th>Author</th><th>Message</th>' . "\n";
        $sql = "SELECT id, subject, message, created, memberId FROM Platy_Forum_Post WHERE topicId=" . $topicId;
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo '<tr>';
            echo '<td>';
            echo $row['id'] . "<br />\n";
            if ($row['uid'] > 0) { echo Platy_Util::getUsername($row['memberId']); }
            echo '</td>';
            echo '<td>';
            echo 'subject:' . $row['subject'];
            echo '&nbsp;' . 'posted:' . $row['created'];
            echo "<br />\n";
            echo $row['message'];
            echo '</td>';
            echo '</tr>';
        }
        echo '</table>' . "\n";
        
        // 新規Postへのリンク
        echo '<a href="' . BASE_URL . 'Forum/postReply/topicId/' . $topicId . '">' . "\n";
        echo '返信する';
        echo '</a>' . "<br />\n";
        
        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->config = $config;
        $view->contents = $contents;
        echo $view->render('module.php');
    }
    
    /**
     * postReply
     */
    function postReplyAction()
    {
        global $db, $config, $Me;
        
        $request = $this->getRequest();
        $topicId = intval($request->getParam('topicId'));
        
        $sql = "SELECT forumId FROM Platy_Forum_Topic WHERE id={$topicId}";
        $row = $db->fetchRow($sql);
        $forumId = $row['forumId'];
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $subject = h($_POST['subject']);
            $message = h($_POST['message']);
            $table = new DBForumPost();
            $post['subject'] = $subject;
            $post['message'] = $message;
            $post['forumId'] = $forumId;
            $post['topicId'] = $topicId;
            $post['memberId'] = $Me->id;
            $post['created'] = date('Y-m-d H:i:s');
            $post['modified'] = $post['created'];
            $table->insert($post);
            
            $this->_redirect('/Forum/listPost/TopocId/' . $topicId);
        }
        else {
            $subject = '';
            $message = '';
        }
        
        ob_start();
        
        echo '<h2>postReply</h2>' . "\n";
        echo 'topic:' . $topic->title . "<br />\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">';
        echo '<tr><th>subject:</th><td>';
        echo '<input type="text" name="subject" size="60" value="' . $subject . '" />' . "</td></tr>\n";
        echo '<tr><th>message:</th><td>';
        echo '<textarea name="message" rows="4" cols="60">';
        echo $message;
        echo '</textarea>' . "</td></tr>\n";
        echo '<tr><th></th><td>';
        echo '<input type="submit" />' . "\n";
        echo '</td></tr></table>' . "\n";
        echo '</form>' . "\n";

        $contents = ob_get_contents();
        ob_end_clean();
        
        Zend_Loader::loadClass('Zend_View');
        $view = new Zend_View();
        $view->setScriptPath(APP_PATH . 'views');
        $view->config = $config;
        $view->contents = $contents;
        echo $view->render('module.php');
    }
}
?>