<?php
/**
 * Tag CExt
 */
require_once 'Platy/CExt.php';

class Platy_CExt_Tag extends Platy_CExt
{
    function install() 
    {
        global $db;
        
        $sql[] = "CREATE TABLE Platy_CExt_Tag("
             . "id          integer PRIMARY KEY,"
             . "tag         varchar(64),"
             . "created     datetime);";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    function uninstall() 
    {
        global $db;
        
        $sql[] = "DROP TABLE Platy_CExt_Tag";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    // イベントハンドラ
    
    function event_PostContentFooter() 
    {
        global $db, $currentContent, $Me;
        
        echo '<p>タグ:';
        $sql = "SELECT tag "
             . "FROM Platy_CExt_Tag "
             . "WHERE id={$currentContent['id']} ";
        $rows = $db->fetchAll($sql);
        for ($i = 0; $i < count($rows); $i++) {
            echo '&nbsp;' . $rows[$i]['tag'];
        }
        echo '</p>' . "\n";
    }
    
    function event_AddContentFormExtras()
    {
        echo '<tr><th>タグ</th><td>';
        echo '<input type="text" name="CExt_Tag" size="60" />' . "\n";
        echo '</td></tr>' . "\n";
    }
    
    function event_PostAddContent()
    {
        global $db, $currentContent, $Me;
        
        $tags = h($_POST['CExt_Tag']);
        $tag_list = split(',', $tags);
        $id = $currentContent['id'];
        
        for ($i = 0; $i < count($tag_list); $i++) {
            $tag = trim($tag_list[$i]);
            if (strlen($tag)) {
                $sql = "INSERT INTO Platy_CExt_Tag(id, tag) VALUES({$id},'{$tag}')";
                $db->query($sql);
            }
        }
    }
    
    function event_EditContentFormExtras()
    {
        global $db, $currentContent, $Me;
        
        $id = $currentContent['id'];
        $sql = "SELECT tag FROM Platy_CExt_Tag WHERE id={$id}";
        $rows = $db->fetchAll($sql);
        $tags = '';
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            if ($i > 0) { $tags .= ','; }
            $tags .= $row['tag'];
        }
        echo '<tr><th>タグ</th><td>';
        echo '<input type="text" name="CExt_Tag" size="60" value="' . $tags . '" />' . "\n";
        echo '</td></tr>' . "\n";
    }
    
    function event_PostEditContent()
    {
        global $db, $currentContent, $Me;
        
        $id = $currentContent['id'];
        $sql = "DELETE FROM Platy_CExt_Tag WHERE id={$id}";
        $db->query($sql);
        
        $tags = h($_POST['CExt_Tag']);
        $tag_list = split(',', $tags);
        
        for ($i = 0; $i < count($tag_list); $i++) {
            $tag = trim($tag_list[$i]);
            if (strlen($tag)) {
                $sql = "INSERT INTO Platy_CExt_Tag(id, tag) VALUES({$id},'{$tag}')";
                $db->query($sql);
            }
        }
    }
    
    function event_DeleteContent() 
    {
        global $db, $currentContent, $Me;
        $sql = "DELETE "
             . "FROM Platy_CExt_Tag "
             . "WHERE id={$currentContent['id']} ";
        $db->query($sql);
    }
    
    function deleteCType($name) 
    {
    }
    
    public function getSummary()
    {
        return 'コンテンツにタグを付加します';
    }
    
    function event_PostContent() {
        global $db, $currentContent, $Me;
        
        $sql = "SELECT tag FROM Platy_CExt_Tag WHERE id={$currentContent['id']}";
        $rows = $db->fetchAll($sql);
        
        if (count($rows)) {
            echo '<p>タグ:';
            foreach($rows as $row) {
                echo $row['tag'] . '&nbsp;';
            }
            echo '</p>' . "\n";
        }
    }
    
}
?>
