<?php
/**
 * 不動産 モジュール
 */
require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Platy/Module.php';
require_once 'Platy/SystemDB.php';
require_once 'Platy/Form.php';

class Platy_Module_Realestate extends Platy_Module
{
    public function install()
    {
        global $db;
        
        $sql[] = "CREATE TABLE Platy_Realestate_Item ("
               . "id                integer PRIMARY KEY,"
               . "category          int,"
               . "name              varchar(255),"
               . "title             varchar(255),"
               . "address           varchar(255),"
               . "station           varchar(255),"
               . "bus               varchar(255),"
               . "price             int,"
               . "kanri             int,"
               . "shikikin          double,"
               . "reikin            double,"
               . "madori            varchar(255),"
               . "senyu_menseki     double,"
               . "completion        varchar(32),"
               . "img_madori        varchar(255),"
               . "img_gaikan        varchar(255),"
               . "structure         varchar(255),"
               . "type              varchar(255),"
               . "rooms             varchar(255),"
               . "madori_desc       text,"
               . "kaiken            varchar(255),"
               . "muki              varchar(255),"
               . "parking           varchar(255),"
               . "condition         text,"
               . "equipment         text,"
               . "note              text,"
               . "kenpei            int,"
               . "youseki           int,"
               . "shikichi_menseki  double,"
               . "tatemono_menseki  double,"
               . "chimoku           varchar(255),"
               . "genkyou           varchar(255),"
               . "road              varchar(255),"
               . "status            varchar(64),"
               . "lat               double,"
               . "lng               double,"
               . "created           datetime,"
               . "modified          datetime);";
        $sql[] = "CREATE TABLE Platy_Realestate_Category ("
               . "id            integer DEFAULT 0,"
               . "name          varchar(64));";
        $sql[] = "INSERT INTO Platy_Realestate_Category(id, name) VALUES(1,'アパート');";
        $sql[] = "INSERT INTO Platy_Realestate_Category(id, name) VALUES(2,'賃貸マンション');";
        $sql[] = "INSERT INTO Platy_Realestate_Category(id, name) VALUES(11,'新築一戸建て');";
        $sql[] = "INSERT INTO Platy_Realestate_Category(id, name) VALUES(12,'中古一戸建て');";
        $sql[] = "CREATE TABLE Platy_Realestate_Provider ("
               . "id            integer PRIMARY KEY,"
               . "name          varchar(255) DEFAULT '',"
               . "address       varchar(255) DEFAULT '',"
               . "opening_hour  varchar(255) DEFAULT '',"
               . "closure       varchar(255) DEFAULT '',"
               . "phone         varchar(16) DEFAULT '',"
               . "url           varchar(255) DEFAULT '',"
               . "email         varchar(255) DEFAULT '',"
               . "director      varchar(64) DEFAULT '',"
               . "created       datetime,"
               . "modified      datetime);";
        $sql[] = "INSERT INTO Platy_Realestate_Provider(id) VALUES(1)";
        $sql[] = "CREATE TABLE Platy_Realestate_Area ("
               . "id            integer PRIMARY KEY,"
               . "name          varchar(255));";
        $sql[] = "CREATE TABLE Platy_Realestate_Item_To_Area ("
               . "itemId        integer,"
               . "areaId        integer);";
        for ($i = 0; $i < count($sql); $i++) {
            echo $sql[$i] . "<br />\n";
            $db->query($sql[$i]);
        }
        
        // メニューアイテム追加
        $item = array('bar'=>'global', 'type'=>'module', 'title'=>'不動産情報', 'module_name'=>'Realestate', 'module_param' => '');
        addToMenu($item);
        
        return true;
    }
    
    public function uninstall()
    {
        global $db;
        
        $sql[] = "DROP TABLE Platy_Realestate_Item";
        $sql[] = "DROP TABLE Platy_Realestate_Category";
        $sql[] = "DROP TABLE Platy_Realestate_Provider";
        $sql[] = "DROP TABLE Platy_Realestate_Area";
        $sql[] = "CREATE TABLE Platy_Realestate_Item_To_Area";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function getName()
    {
        return 'Realestate';
    }
    
    public function getTitle()
    {
        return '不動産';
    }
    
    public function getSummary()
    {
        return '不動産情報';
    }
    
    public function getAuthor()
    {
        return 'altkraft';
    }
}
?>