<?php
/**
 * カスタムボックス
 */
require_once 'Platy/Widget.php';

class Platy_Widget_CustomBox extends Platy_Widget
{
    public function install() {
        global $db;
        
        $sql = 'CREATE TABLE Platy_W_CustomBox ('
             . 'code            varchar(64) UNIQUE,'
             . 'title           varchar(255),'
             . 'summary         text,'
             . 'f_widget        int DEFAULT 1,'
             . 'f_title         int DEFAULT 1,'
             . 'f_main          int DEFAULT 1);';
        $db->query($sql);
        
        return true;
    }
    
    public function uninstall() {
        global $db;
        
        $sql = 'DROP TABLE Platy_W_CustomBox';
        $db->query($sql);
        
        return true;
    }

    public function getSummary()
    {
        return 'タイトルと内容を自由に設定できるウィジェット';
    }
    
    public function isMulti() { return true; }
    
    public function property($code = '')
    {
        global $db;
        
        if ($code == '') { return; }
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $title = h($_POST['title']);
            //ブログパーツではhtmlを変換しない。DBにはescapeした文字列をセットする。
            //$summary = h($_POST['summary']);
            //$summary = e($_POST['summary']);
            $summary = $_POST['summary'];
            $f_widget = intval($_POST['f_widget']);
            $f_widget ? $f_widget = 1: $f_widget = 0;
            $f_title = intval($_POST['f_title']);
            $f_title ? $f_title = 1 : $f_title = 0;
            $f_main = intval($_POST['f_main']);
            $f_main ? $f_main = 1 : $f_main = 0;
            if ($title != '' && $summary != '') {
                $sql = "SELECT COUNT(*) FROM Platy_W_CustomBox WHERE code='{$code}'";
                $row = $db->fetchRow($sql);
                var_dump($row);
                if ($row['COUNT(*)'] == 0) {
                    $sql = "INSERT INTO Platy_W_CustomBox(code, title, summary, f_widget, f_title, f_main) VALUES('{$code}', '{$title}', '{$summary}', {$f_widget}, {$f_title}, {$f_main})";
                    $db->query($sql);
                }
                else {
                    $sql = "UPDATE Platy_W_CustomBox SET title='{$title}', summary='{$summary}', f_widget={$f_widget}, f_title={$f_title}, f_main={$f_main} WHERE code='{$code}'";
                    $db->query($sql);
                }
                //echo $sql;
                return false;
                //return true;
            }
        }
        else {
            $sql = "SELECT title, summary, f_widget, f_title, f_main FROM Platy_W_CustomBox WHERE code='{$code}'";
            $row = $db->fetchRow($sql);
            if ($row != false) {
                $title = $row['title'];
                $summary = $row['summary'];
                $f_widget = $row['f_widget'];
                $f_title = $row['f_title'];
                $f_main = $row['f_main'];
            }
            else {
                $title = '';
                $summary = '';
                $f_widget = 1;
                $f_title = 1;
                $f_main = 1;
            }
        }
        //echo $sql . "<br />\n";
        //var_dump($row);
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>title</th><td>';
        echo '<input type="text" name="title" value="' . $title . '" size="60" />';
        echo '</td></tr>' . "\n";
        echo '<tr><th>description</th><td>';
        echo '<textarea name="summary" rows="8" cols="60">';
        echo $summary;
        echo '</textarea>' . "\n";
        echo '</td></tr>' . "\n";
        
        echo "<tr><th>ウィジェット枠の表示</th><td>";
        echo '<input type="radio" name="f_widget" VALUE="1"';
        if ($f_title == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="f_widget" VALUE="0"';
        if ($f_title == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo "</td></tr>\n";
        
        echo "<tr><th>タイトル枠の表示</th><td>";
        echo '<input type="radio" name="f_title" VALUE="1"';
        if ($f_title == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="f_title" VALUE="0"';
        if ($f_title == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo "</td></tr>\n";
        
        echo "<tr><th>メイン枠の表示</th><td>";
        echo '<input type="radio" name="f_main" VALUE="1"';
        if ($f_main == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="f_main" VALUE="0"';
        if ($f_main == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo "</td></tr>\n";
        
        echo '<tr><th></th><td>';
        echo '<input type="submit" value="更新する" />' . "\n";
        echo '</td></tr></table>' . "\n";
        echo '</form>' . "\n";
        
        return false;
    }
    
    public function view($code = '')
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $sql = "SELECT title, summary, f_widget, f_title, f_main FROM Platy_W_CustomBox WHERE code='{$code}'";
        $row = $db->fetchRow($sql);
        if ($row == false) { return; }
        
        $title = $row['title'];
        $summary = $row['summary'];
        //$f_widget = $row['f_widget'];
        //$f_title = $row['f_title'];
        //$f_main = $row['f_main'];
        
        $a['title'] = $title;
        $a['main'] = $summary;
        
        return $a;
    }
}
?>