<?php
/**
 * ノード ナビゲージョン(タイプ1)
 *
 * 現在の階層のノードを表示する
 *
 NodeがFolderならば、そのFolder内のNodeすべてを表示する。TitleはFolderタイトル
 NodeがFolderでなければ、その上のFolder内のNodeすべてを表示する。TitleはFolderタイトル。Nodeは強調表示する。

 */
require_once 'Platy/Widget.php';


define(DISPLAY_ICON, 1);    // アイコンの表示(0:しない,1:する)

class Platy_Widget_NodeNavOne extends Platy_Widget
{
    public function install() { return true; }
    public function uninstall() { return true; }
    
    public function getSummary()
    {
        return '現在の階層だけを表示するノードナビゲーション';
    }
    
    public function show()
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $currentPath = $_SERVER['REQUEST_URI'];
        $currentNode = substr($_SERVER['REQUEST_URI'], strlen('/Platy'), strlen($_SERVER['REQUEST_URI']) - strlen(strlen('/Platy')));
        
        $str = substr($currentNode, strlen($currentNode)-1, 1);
        ($str == '/') ? $type = 'Folder' : $type = 'Content';
        //echo $type . "<br />\n";
        
        $a = split('/', $currentNode);
        //var_dump($a);
        
        $title = '';
        $nodeId = 0;
        
        for ($i = 1; $i < count($a)-1; $i++) {
            $name = $a[$i];
            //echo $name . "<br />\n";
            $sql = "SELECT n.id, b.type, b.name, b.title "
                 . "FROM Platy_Content_Node n, Platy_Content_Base b "
                 . "WHERE n.id=b.id AND b.type='Folder' AND n.parentId={$nodeId} AND b.name='{$name}' "
                 . "ORDER BY n.ordering";
            //echo $sql . "<br />\n";
            $row = $db->fetchRow($sql);
            if (!is_array($row)) {
                return -2;
            }
            else {
                $nodeId = $row['id'];
                $title = $row['title'];
                $link .= $name . '/';
            }
        }
        if ($title == '') { $title = 'ホーム'; }
        $g_title = '<a href="' .  BASE_URL . $link . '">' . $title . '</a>';

        // Folder内のコンテンツ一覧の表示

        $sql = "SELECT id FROM Platy_Content_Node WHERE parentId={$nodeId} ";
        //echo $sql . "<br />\n";
        $rows = $db->fetchAll($sql);
        //var_dump($rows);

        $g_main .=  '<ul>' . "\n";
        foreach ($rows as $row) {
            
            $contentId = $row['id'];
            $sql2 = "SELECT id, type, name, title, status, startDate, endDate FROM Platy_Content_Base WHERE id={$contentId}";
            $row2 = $db->fetchRow($sql2);
            
            $ctype_name = $row2['type'];
            
            $c_name = $row2['name'];
            $c_title = $row2['title'];
            $c_link = BASE_URL . $link . $row2['name'];
            $c_status = $row2['status'];
            $c_startDate = $row2['startDate'];
            $c_endDate = $row2['endDate'];
            //echo $link . "<br />\n";
            
            if ($ctype_name != 'Folder') {
                if ($c_status == 'public' && checkPeriod($c_startDate, $c_endDate) == true) {
                    $g_main .= '<li>';
                    $g_main .= '<a href="'. $c_link . '">';
                    if (DISPLAY_ICON==1) {
                        $g_main .= '<img src="' . BASE_URL . 'media/system/' . $ctype_name . '.png" alt="icon" />';
                    }
                    $g_main .= $c_title . '</a>' . "</li>\n";
                }
            }
            else {
                $g_main .= '<li>';
                $g_main .= '<a href="'. $c_link . '/">';
                if (DISPLAY_ICON==1) {
                    $g_main .= '<img src="' . BASE_URL . 'media/system/' . $ctype_name . '.png" alt="icon" />';
                }
                $g_main .= $c_title . '</a>' . "</li>\n";
            }
        }

        // $type=='Folder'であれば、上に戻るリンクを表示する
        if ($type=='Folder' && count($a) > 2) {
            $link = '';
            for ($i = 1; $i < count($a)-2; $i++) {
                $link .= $a[$i] . '/';
            }
            $s = '<li>' . '<a href="' . BASE_URL . $link . '">' . '一つ上に戻る' . '</a>' . "</li>\n";
            $g_main .= $s;
        }
        $g_main .= '</ul>' . "\n";

        $a['title'] = $g_title;
        $a['main'] = $g_main;
        return $a;
    }
}
?>
