<?php
/**
 * ノード ナビゲージョン 基本タイプ (dtree対応版)
 * Plone のナビゲーションを参考
 */
require_once 'Platy/Widget.php';

class Platy_Widget_NodeNavTree extends Platy_Widget
{
    private $show_n;        // フォルダ内のコンテンツ数を表示するか？
    private $show_icon;     // コンテンツタイプのアイコンを表示するか？
    
    private $currentPath;
    private $currentName;
    
    function __construct() {
        $this->show_n = true;
        $this->show_icon = true;
        $this->currentPath = '';
        $this->currentName = '';
    }
    
    public function install() {
        global $db;
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('W_NODENAVTREE_CNUM', '0')";
        $sql[] = "INSERT INTO Platy_Config(name, value) VALUES('W_NODENAVTREE_ICON', '1')";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function uninstall() {
        global $db;
        $sql[] = "DELETE FROM Platy_Config WHERE name='W_NODENAVTREE_CNUM'";
        $sql[] = "DELETE FROM Platy_Config WHERE name='W_NODENAVTREE_ICON'";
        for ($i = 0; $i < count($sql); $i++) {
            $db->query($sql[$i]);
        }
        return true;
    }
    
    public function getSummary()
    {
        return '基本タイプのノードナビゲーション(dtree対応版)';
    }
    
    public function view()
    {
        global $db, $config, $js_helper, $css_helper;
        
        $js_helper->addFile(BASE_URL . 'libs/dtree/dtree.js');
        $css_helper->addFile(BASE_URL . 'libs/dtree/dtree.css');
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $a['title'] = 'ツリーナビゲーション';
        
        ob_start();
        
        echo '<div class="dtree">' . "\n";
        
        echo '<p><a href="javascript: d.openAll();">open all</a> | <a href="javascript: d.closeAll();">close all</a></p>' . "\n";
        
        echo '<script type="text/javascript">' . "\n";
        echo '<!--' . "\n";
        
        echo "d = new dTree('d');" . "\n";
        echo "d.setImgUrl('" . BASE_URL . 'libs/dtree/img/' . "');" . "\n";
        echo "d.add(0,-1,'" . $config['S_SITE_NAME'] . "');" . "\n";
        
        $this->r();
        
        echo 'document.write(d);' . "\n";
        echo 'd.openAll();' . "\n";
        
        echo '//-->' . "\n";
        echo '</script>' . "\n";
        echo '</div><!-- /dtree -->' . "\n";
        
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
    
    /**
     * 
     */
    private function getChildNode(&$path_array, $id, &$depth)
    {
        global $db;
        
        //echo "getChildNode";
        //var_dump($path_array);
        //echo "id=" . $id . ',';
        //echo "depth=" . $depth;
        //echo "<br />\n";
        
        $sql = "SELECT n.id, b.type, b.name, b.title, b.modified, b.status, b.startDate, b.endDate "
             . "FROM Platy_Content_Node n, Platy_Content_Base b "
             . "WHERE n.id=b.id AND parentId={$id} AND b.status='public' ORDER BY ordering";
        $rows = $db->fetchAll($sql);
        
        $pid = $id;
        for ($i = 0; $i < count($rows); $i++) {
            $row = $rows[$i];
            $id = $row['id'];
            $type = $row['type'];
            $name = $row['name'];
            $title = $row['title'];
            $modified = $row['modified'];
            $status = $row['status'];
            $startDate = $row['startDate'];
            $endDate = $row['endDate'];
            if (Platy_Util::checkPeriod($startDate, $endDate) == false) {
                continue;
            }
            
            if ($type == 'Folder') {
                //for ($k = 0; $k < $depth; $k++) { echo '&nbsp;&nbsp;&nbsp;&nbsp;'; }
                
                $path = '';
                foreach ($path_array as $p) { $path .= $p . '/'; }
                $path_name = $path . $name . '/';
                $path_name = substr($path_name, 5);
                //echo '<a href="' . BASE_URL . $path_name . '">';
                //echo $title;
                //echo '</a>';
                //echo "<br />\n";
                $url = BASE_URL . $path_name;
                
                //$title = $title . '(' . $startDate . '-' . $endDate . ')';
                if ($pid == 1) { $pid = 0; }
                if ($id != 1) {
                    echo "d.add(" . $id . "," . $pid . ",'" . $title . "','" . $url . "');" . "\n";
                }
                $parentId = $id;
                $depth++;
                
                //echo "push<br />\n";
                array_push($path_array, $name);
                $this->getChildNode($path_array, $parentId, $depth);
            }
            else {  // not Folder
                //for ($k = 0; $k < $depth; $k++) { echo '&nbsp;&nbsp;&nbsp;&nbsp;'; }
                
                $path = '';
                foreach ($path_array as $p) { $path .= ($p . '/'); }
                $path_name = $path . $name;
                $path_name = substr($path_name, 5);
                //echo '<a href="' . BASE_URL . $path_name . '">';
                //echo $title;
                //echo '</a>';
                //echo "<br />\n";
                $url = BASE_URL . $path_name;
                
                //$title = $title . '(' . $startDate . '-' . $endDate . ')';
                
                if ($pid == 1) { $pid = 0; }
                echo "d.add(" . $id . "," . $pid . ",'" . $title . "','" . $url . "');" . "\n";
            }
        }
        //echo "pop<br />\n";
        $depth--;
        array_pop($path_array);
    }
    
    /**
     * 再帰表示
     */
    public function r()
    {
        $path_array = array();
        $id = 0;
        $depth = 0;
        $this->getChildNode($path_array, $id, $depth);
    }
    
    public function config()
    {
        global $db, $config;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $config['W_NODENAVTREE_CNUM'] = intval($_POST['cnum']);
            $config['W_NODENAVTREE_ICON'] = intval($_POST['icon']);
            $sql[] = "UPDATE Platy_Config set value='" . $config['W_NODENAVTREE_CNUM'] . "' WHERE name='W_NODENAVTREE_CNUM'";
            $sql[] = "UPDATE Platy_Config set value='" . $config['W_NODENAVTREE_ICON'] . "' WHERE name='W_NODENAVTREE_ICON'";
            for ($i = 0; $i < count($sql); $i++) {
                $db->query($sql[$i]);
            }
        }
        
        echo '<h2>NodeNavTree設定</h2>' . "\n";
        
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        
        echo '<tr><th>フォルダ内コンテンツ数の表示</th><td>';
        echo '<input type="radio" name="cnum" VALUE="1"';
        if ($config['W_NODENAVTREE_CNUM'] == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="cnum" VALUE="0"';
        if ($config['W_NODENAVTREE_CNUM'] == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo '</td></tr>' . "\n";
        
        echo '<tr><th>アイコンの表示</th><td>';
        echo '<input type="radio" name="icon" VALUE="1"';
        if ($config['W_NODENAVTREE_ICON'] == 1) { echo ' checked="true"'; }
        echo ' />表示する&nbsp;';
        echo '<input type="radio" name="icon" VALUE="0"';
        if ($config['W_NODENAVTREE_ICON'] == 0) { echo ' checked="true"'; }
        echo ' />表示しない';
        echo '</td></tr>' . "\n";
        
        echo '<tr><th></th><td>';
        echo '<input type="submit" value="設定を更新する" />';
        echo '</td></tr>' . "\n";
        
        echo '</table>' . "\n";
        echo '</form>' . "\n";
    }
}
?>