<?php
/**
 * クイックリンク
 * 
 */
require_once 'Platy/Widget.php';

class Platy_Widget_QuickLink extends Platy_Widget
{
    public function install() {
        global $db;
        
        $sql = 'CREATE TABLE Platy_W_QuickLink ('
             . 'id              integer PRIMARY KEY,'
             . 'title           varchar(255),'
             . 'url             varchar(255),'
             . 'ordering        int DEFAULT 0);';
        $db->query($sql);
        
        return true;
    }
    
    public function uninstall() {
        global $db;
        
        $sql = 'DROP TABLE Platy_W_QuickLink';
        $db->query($sql);
        
        return true;
    }
    
    public function getSummary()
    {
        return 'クイックリンク';
    }
    
    public function view()
    {
        global $db;
        
        $a = array('title' => '', 'icons' => '', 'main' => '', 'footer' => '');
        
        $a['title'] = 'クイックリンク';
        
        ob_start();
        $sql = "SELECT title, url FROM Platy_W_QuickLink ORDER BY ordering";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo '<a href="' . $row['url'] . '">';
            echo $row['title'];
            echo '</a>' . "<br />\n";
        }
        $a['main'] = ob_get_contents();
        ob_end_clean();
        
        return $a;
    }
    
    public function config()
    {
        global $db;
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $title = h($_POST['title']);
            $url = h($_POST['url']);
            $ordering = intval($_POST['ordering']);
            $sql = "INSERT INTO Platy_W_QuickLink(title, url, ordering) VALUES('{$title}', '{$url}', {$ordering})";
            $db->query($sql);
        }
        
        echo '<h2>QuickLinkの設定</h2>' . "\n";
        
        echo '<table class="list_table">' . "\n";
        echo '<th>id</th><th>title</th><th>url</th><th>ordering</th><th>action</th>' . "\n";
        $sql = "SELECT id, title, url, ordering FROM Platy_W_QuickLink ORDER BY ordering";
        $rows = $db->fetchAll($sql);
        foreach ($rows as $row) {
            echo '<tr>';
            echo '<td>';
            echo $row['id'];
            echo '</td>';
            echo '<td>';
            echo $row['title'];
            echo '</td>';
            echo '<td>';
            echo $row['url'];
            echo '</td>';
            echo '<td>';
            echo $row['ordering'];
            echo '</td>';
            echo '<td>';
            echo '</td>';
            echo '</tr>' . "\n";
        }
        echo '</table>' . "\n";
        
        echo '<h3>リンクアイテムの追加</h3>' . "\n";
        echo '<form method="post" action="">' . "\n";
        echo '<table class="form_table">' . "\n";
        echo '<tr><th>title</th>';
        echo '<td><input type="text" name="title" value="' . $title . '" size="80"></td></tr>' . "\n";
        echo '<tr><th>url</th>';
        echo '<td><input type="text" name="url" value="' . $url . '" size="80"></td></tr>' . "\n";
        echo '<tr><th></th>';
        echo '<td><input type="submit" value="リンクアイテムを追加する" /></td></tr></table>' . "\n";
        echo '</form>' . "\n";
    }
}
?>