/*
 * interrupt.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include"lib.h"
#include"proc.h"
#include"segment.h"
#include"interrupt.h"
#include"mp.h"
#include"fs.h"
/***************************/
#include"test.h"
/****************************/


enum{IDT_ENTRY=256};		/* Interrupt descriptorȥ꡼ */


DESCRIPTOR idt[IDT_ENTRY];		/* IDT */
DTR idtr={IDT_ENTRY*8-1,idt};	/* IDT Reg */

/* System calls entry table */
SYSCALL syscall_table[SYS_ENTRYS]={
	sys_open,
	sys_read,
	sys_write,
	sys_lseek,
	sys_rename,
	sys_creat,
	sys_unlink,
	sys_lock,
	sys_mount,
	sys_umount,
	sys_fork,
	sys_exit,
	sys_exec,
	sys_sleep,
};


static int temp();


/*
 * ߥϥɥơ֥
 * returns : task switch on 1,off 0
 */
int (*irq_entry[IRQ_ENTRY])()={
	temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp
};

/*
 * ϡɳѣţϣɴؿ
 * parameters : IRQ number
 */
void (*irq_eoi)(uchar);

/*
 * Release hard interrupt mask
 * parameters : IRQ number
 */
void (*release_irq_mask)(uchar);

/*
 * Set hard interrupt mask
 * parameters : IRQ number
 */
void (*set_irq_mask)(uchar);


/*
 * IDTꤹ
 * parameters : IDT number,Hnadler address,Gate flag(IDT_INTR or IDT_TRAP)
 */
void set_idt(int num,void *func,int flag)
{
	idt[num].low=((uint)func&0xffff)|(KERNEL_CODE_DES<<16);
	idt[num].high=0x8000|((uint)func&0xffff0000)|flag;
}


/*
 * Set call gate discriptor
 * parameters : Value of discritor,Offset,Parameter count
 */
void set_gate(int des,void *addr,uchar para_num)
{
	gdt[des/8].low=((uint)addr&0xffff)|(KERNEL_CODE_DES<<16);
	gdt[des/8].high=((uint)addr&0xffff0000)|0xec00|para_num;
}


/*
 * Init system call
 */
int init_syscall()
{
	set_gate(GATE_DES,syscall0,0);
	set_gate(GATE_DES+8,syscall1,1);
	set_gate(GATE_DES+16,syscall2,2);
	set_gate(GATE_DES+24,syscall3,3);

	return 0;
}

int temp()
{
	return 0;
}
