/*
 * segmnet.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include"types.h"
#include"segment.h"


enum{GDT_ENTRY=256};		/* GDȥ꡼ */


/* GDT */
DESCRIPTOR gdt[GDT_ENTRY]=
{
	{0,0},
	{0x0000ffff,0x00cf9a00},	/* ͥ륳ɥ */
	{0x0000ffff,0x00cf9200},	/* ͥǡ */
	{0x0000ffff,0x00cffa00},	/* 桼ɥ */
	{0x0000ffff,0x00cff200},	/* 桼ǡ */
	{0,0}
};

/* GDT Reg */
DTR gdtr={GDT_ENTRY*8-1,gdt};


/*
 * ǥץ˥ɥ쥹ꤹ
 *  : ǥץ͡١ɥ쥹ߥåȥץե饰
 */
void set_gdt(int des,void *addr,uint size,int flag)
{
	gdt[des/8].low=0;
	gdt[des/8].high=0;

	/* ١ɥ쥹 */
	gdt[des/8].low|=(uint)addr<<16;
	gdt[des/8].high|=((uint)addr>>16)&0xff;
	gdt[des/8].high|=(uint)addr&0xff000000;

	/* ߥåȥ */
	if(flag&0x100000)size>>=12;
	gdt[des/8].low|=(uint)size&0xffff;
	gdt[des/8].high|=(uint)size&0xf0000;

	/* ץե饰 */
	gdt[des/8].high|=flag;
}
