/*
 * mm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꡼ץ
 *
 * ǡΡ
 * 	ǡ̾phis_link
 * 	ؿlink_phys_page()
 * 	unlink_phys_page()
 * 	alloc_kernel_page()
 * 	alloc_user_page()
 *		phis_linkξ֤ǥڡ꡼¾ץ鲣ꤵΤǡڡơ֥륨ȥ꡼ѹ
 * 		phis_linkäPHYS_PAGEǤpage_tbl_addƱɬפ롣
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"lock.h"
#include"interrupt.h"
#include"proc.h"
#include"mp.h"
#include"segment.h"
#include"errno.h"
#include"fs.h"
#include"device.h"
#include"mm.h"
/****************************/
extern void test_program();
/*****************************/


enum{
	PAGE_NUM=0x400,				/* Number of pages in a table or a directory */
	HEAP_NUM=11,				/* kmallocMEM¤κ */

	INT_BIT=sizeof(int)*8,		/* Number of integer bit */

	PT_TYPE_PAGING=0x9b,		/* ڡХååץǥХѡƥֹʲ */

	PT_COPY_ON_WRITE=0x200		/* ڡơ֥륨ȥ꡼Υԡ饤ȥե饰 */
};


/*
 * ʪ꡼ơ֥빽¤
 * Page
 */
typedef struct PHYS_PAGE{
	short ref_count;			/* reference count */
	ushort heap_num;			/* Heap number */
	PROC *proc;					/* ƤƤץ */
	struct PHYS_PAGE *next;
	struct PHYS_PAGE *prev;
}PHYS_PAGE;

typedef struct{
	PHYS_PAGE free_top;			/* ʪ꡼󥯥ȥå */
	PHYS_PAGE free_end;			/* ʪ꡼󥯥 */
	PHYS_PAGE used_top;			/* ʲġʪ꡼󥯥ȥå */
	PHYS_PAGE used_end;			/* ʲġʪ꡼󥯥 */
	PHYS_PAGE *used_usr_new;	/* Υ桼ʪ꡼ */
	int gate;					/* PHYS_PAGE lock gate */
}PHYS_PAGE_LINK;

typedef struct FREE{
	char* last;
	struct FREE *prev;
	struct FREE *next;
}FREE;

typedef struct{
	uint size;
	FREE *free;
	int gate;
}HEAP;


/* ꡼setup.S */
uint all_memory_size;

/*
 * ꡼ơ֥
 * free_top (kernel mem)  (user mem) free_end
 * used_top (new kernel mem)  (old kernel mem)  (new user mem)  (old user mem) used_end
 */
static PHYS_PAGE_LINK phis_link={
	{0,0,NULL,NULL,NULL},
	{0,0,NULL,NULL,NULL},
	{0,0,NULL,NULL,NULL},
	{0,0,NULL,NULL,NULL},
	NULL,
	0
};

/* kfreeʼ */
static FREE guard[HEAP_NUM];

/* kmallocѹ¤ */
static HEAP heap[]={
	{0,NULL,0},
	{0x8,   &guard[1], 0},
	{0x10,  &guard[2], 0},
	{0x20,  &guard[3], 0},
	{0x40,  &guard[4], 0},
	{0x80,  &guard[5], 0},
	{0x100, &guard[6], 0},
	{0x200, &guard[7], 0},
	{0x400, &guard[8], 0},
	{0x800, &guard[9], 0},
	{0x1000,&guard[10],0}
};


/*
 * Physical addressPHYS_PAGE address֤
 * parameters : Physical address
 * return : PHYS_PAGE address
 */
extern inline PHYS_PAGE *get_physpage_from_addr(void *addr)
{
	return (PHYS_PAGE*)((uint)addr/PAGE_SIZE*sizeof(PHYS_PAGE)+PHYSICAL_PAGE_TABLE_ADD);
}


/*
 * PHYS_PAGE addressPhysical addres֤
 * parameters : PHYS_PAGE address
 * return : Physical address
 */
extern inline void *get_addr_from_physpage(PHYS_PAGE *memtable)
{
	return (void*)(((uint)memtable-PHYSICAL_PAGE_TABLE_ADD)/sizeof(PHYS_PAGE)*PAGE_SIZE);
}


/*
 * ɥ쥹ڡơ֥륨ȥ꡼ɥ쥹롣
 * parameters : ɥ쥹
 * return : ڡɥ쥹
 */
extern inline uint *get_page_addr(uint addr,uint *page_dir)
{
	uint *page_tbl;


	page_tbl=(uint*)(page_dir[addr>>22]&0xfffff000);
	return &page_tbl[(addr>>12)&0x3ff];
}


/***********************************************************************************
 *
 * ؿ
 *
 ***********************************************************************************/

static uint find_all_memsize();
static void init_physical_page_table();
static int mount_page_backup_dev(const char*);


/*
 * ꡼ƥν
 */
void init_mm()
{
	/* Find size of physical memory  */
	printk("Memory size = %d MB\n",find_all_memsize()/0x100000);

	/* ʪ꡼ơ֥ */
	init_physical_page_table();

	/* ڡѵΰν */
/*	int mount_page_backup_dev();*/
}


/***********************************************************************************
 *
 * ꡼ؿ
 *
 ***********************************************************************************/

static int buckup_page(void*);


/*
 * Find size of all physical memory
 */
uint find_all_memsize()
{
	enum{EXIST_MEM_SIZE=0x800000};		/* ꡼¬ñ */

	uint volatile *point;


	/* ꡼ñ̤Ȥ¬ꤹ*/
	for(point=(uint*)EXIST_MEM_SIZE-1;;point+=EXIST_MEM_SIZE/sizeof(uint))
	{
		*point=0x5a5a5a5a;
		if(*point!=0x5a5a5a5a)break;
		else
		{
			*point=0xf0f0f0f0;
			if(*point!=0xf0f0f0f0)break;
		}
	}

	return (all_memory_size=(uint)point-EXIST_MEM_SIZE+sizeof(uint));
}


/*
 * ʪ꡼ơ֥롣
 */
void init_physical_page_table()
{
	int i,last;
	PHYS_PAGE *p=(PHYS_PAGE*)PHYSICAL_PAGE_TABLE_ADD;


	/* ǽ1Mbyteʬ꡼Ƥ0ˡ */
	memset(p,0,0x100000/PAGE_SIZE*sizeof(PHYS_PAGE));

	/* Ĥե꡼ꤹ롣 */
	for(i=0x100000/PAGE_SIZE,last=all_memory_size/PAGE_SIZE;i<last;++i)
	{
		p[i].ref_count=0;
		p[i].heap_num=0;
		p[i].proc=NULL;
		p[i].next=&p[i+1];
		p[i].prev=&p[i-1];
	}
	phis_link.free_top.next=&p[0x100000/PAGE_SIZE];
	phis_link.free_end.prev=&p[i-1];
	p[0x100000/PAGE_SIZE].prev=&phis_link.free_top;
	p[i-1].next=&phis_link.free_end;

	/* ꡼ơ֥ʬ꡼ƤʲԲġˡ */
	last=ROUNDUP(PHYSICAL_PAGE_TABLE_ADD+all_memory_size/PAGE_SIZE*sizeof(PHYS_PAGE),PAGE_SIZE)/PAGE_SIZE;
	if(&p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE]==phis_link.free_top.next)
		phis_link.free_top.next=&p[last];
	else p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE-1].next=&p[last];

	/* Used link롣 */
	phis_link.used_top.next=&phis_link.used_end;
	phis_link.used_end.prev=&phis_link.used_top;
	phis_link.used_usr_new=&phis_link.used_end;
}


/*
 * ʪ꡼ڡλȥȤ䤹
 * parameters : ʪɥ쥹
 */
void link_phys_page(uint addr)
{
	PHYS_PAGE *p;


	p=get_physpage_from_addr((void*)addr);

	enter_spinlock(&phis_link.gate);
	{
		if(++p->ref_count==1)
		{
			/* used link˲ä롣 */
			if(addr<KERNEL_DATA_END)
			{
				p->prev=&phis_link.used_top;
				p->next=phis_link.used_top.next;
				phis_link.used_top.next=p;
				p->next->prev=p;
			}
			else
			{
				p->prev=phis_link.used_usr_new->prev;
				p->next=phis_link.used_usr_new;
				phis_link.used_usr_new->prev=p;
				p->prev->next=p;
				phis_link.used_usr_new=p;
			}

			p->proc=get_current_task();
		}
		else if(p->ref_count==2)
		{
			/* Used link */
			p->prev->next=p->next;
			p->next->prev=p->prev;
			if(phis_link.used_usr_new==p)phis_link.used_usr_new=p->next;

			p->proc=NULL;
		}
	}
	exit_spinlock(&phis_link.gate);
}


/*
 * ȥȤ򸺤餷ʪ꡼ڡ롣
 * parameters : ʪɥ쥹,ԡ饤ȥե饰
 * return : 0 or 1=ԡ饤ȤǻȲѤ餺
 */
int unlink_phys_page(uint addr,int cow_flag)
{
	int rest=0;
	PHYS_PAGE *p;


	p=get_physpage_from_addr((void*)addr);

	enter_spinlock(&phis_link.gate);
	{
		/* ˻ȤƤʤޤϳԲĤΥڡ */
		if(--p->ref_count<0)
			p->ref_count=0;
		else if(p->ref_count==0)
		{
			if(cow_flag==1)
			{
				/* used link˲ä롣 */
				if(addr<KERNEL_DATA_END)
				{
					p->prev=&phis_link.used_top;
					p->next=phis_link.used_top.next;
					phis_link.used_top.next=p;
					p->next->prev=p;
				}
				else
				{
					p->prev=phis_link.used_usr_new->prev;
					p->next=phis_link.used_usr_new;
					phis_link.used_usr_new->prev=p;
					p->prev->next=p;
					phis_link.used_usr_new=p;
				}

				p->proc=get_current_task();
				p->ref_count=1;

				rest=1;
			}
			else
			{
				/* Used link */
				p->prev->next=p->next;
				p->next->prev=p->prev;
				if(phis_link.used_usr_new==p)phis_link.used_usr_new=p->next;

				if(addr<KERNEL_DATA_END)
				{
					p->next=phis_link.free_top.next;
					p->prev=&phis_link.free_top;
					phis_link.free_top.next=p;
					p->next->prev=p;
				}
				else
				{
					p->prev=phis_link.free_end.prev;
					p->next=&phis_link.free_end;
					phis_link.free_end.prev=p;
					p->prev->next=p;
				}

				p->heap_num=0;
				p->proc=NULL;
			}
		}
	}
	exit_spinlock(&phis_link.gate);

	return rest;
}


/*
 * ֤ͥʪڡƤ롣
 * ƤڡϲԲ
 * return : Allocate addres or NULL
 */
void *alloc_kernel_page()
{
	void *address=NULL;
	bool used=0;
	PHYS_PAGE *p;


	enter_spinlock(&phis_link.gate);
	{
		p=phis_link.free_top.next;
		if((p!=&phis_link.free_end)&((address=get_addr_from_physpage(p))<(void*)KERNEL_DATA_END))
		{
			p->ref_count=1;
			phis_link.free_top.next=p->next;
			p->next->prev=&phis_link.free_top;
		}
		else if(((p=phis_link.used_top.next)!=&phis_link.used_end)&(phis_link.used_usr_new!=p))
		{
			address=get_addr_from_physpage(p);
			phis_link.used_top.next=p->next;
			p->next->prev=&phis_link.used_top;
			used=1;
		}
	}
	exit_spinlock(&phis_link.gate);

	/* ꡼ƤХååפ롣 */
	if(used&&(buckup_page(address)==-1))return NULL;

	return address;
}


/*
 * 桼֤ʪڡƤ롣
 * Ƥڡϲ
 * parameters : ڡơ֥륢ɥ쥹
 * return : Allocate addres or error=NULL
 */
void *alloc_user_page(uint *page_tbl)
{
	void *addr=NULL;
	PHYS_PAGE *p;


	for(;;)
	{
		if((p=phis_link.free_end.prev)!=&phis_link.free_top)
		{
			enter_spinlock(&phis_link.gate);

			if(p==phis_link.free_end.prev)
			{
				addr=(void*)get_addr_from_physpage(p);
				p->ref_count=1;

				/* ե꡼󥯤 */
				phis_link.free_end.prev=p->prev;
				p->prev->next=&phis_link.free_end;

				/* 󥯤˲ä롣 */
				if(addr<(void*)KERNEL_DATA_END)
				{
					p->prev=&phis_link.used_top;
					p->next=phis_link.used_top.next;
					phis_link.used_top.next=p;
					p->next->prev=p;
				}
				else
				{
					p->prev=phis_link.used_usr_new->prev;
					p->next=phis_link.used_usr_new;
					phis_link.used_usr_new->prev=p;
					p->prev->next=p;
					phis_link.used_usr_new=p;
				}

				p->proc=get_current_task();

				exit_spinlock(&phis_link.gate);

				break;
			}

			exit_spinlock(&phis_link.gate);
		}
		else if((p=phis_link.used_end.prev)!=&phis_link.used_top)
		{
			enter_spinlock(&p->proc->pagedir_gate);
			enter_spinlock(&phis_link.gate);

			if(p==phis_link.used_end.prev)
			{
				/* 󥯤 */
				addr=(void*)get_addr_from_physpage(p);
				phis_link.used_end.prev=p->prev;
				p->prev->next=&phis_link.used_end;
				if(phis_link.used_usr_new==p)phis_link.used_usr_new=&phis_link.used_end;

				exit_spinlock(&phis_link.gate);

				/* ꡼Ƥback up */
				if(buckup_page(addr)==-1)return NULL;

				exit_spinlock(&p->proc->pagedir_gate);

				break;
			}

			exit_spinlock(&phis_link.gate);
			exit_spinlock(&p->proc->pagedir_gate);
		}
		else break;
	}

	return addr;
}


/*
 * 2Ѿ襵Ȥ˥ڡ꡼ʬ䤹
 * ϥڡ
 * parameters : Size by byte
 * return : address
 */
void *kmalloc(size_t size)
{
	char *addr=NULL;
	int i;


	if((size==0)||(size>PAGE_SIZE))return NULL;		/* Require size is over */

	for(i=1;size>heap[i].size;++i);					/* Require size=heap[i].size */

	enter_spinlock(&heap[i].gate);
	{
		if(heap[i].free==&guard[i])
		{
			if((heap[i].free=(FREE*)alloc_kernel_page())==NULL)goto OUT;

			/*
			 * Ȥaddress狼褦ˤ
			 */
			get_physpage_from_addr((void*)heap[i].free)->heap_num=i;

			heap[i].free->prev=&guard[i];
			heap[i].free->next=&guard[i];
			guard[i].prev=heap[i].free;
			guard[i].next=heap[i].free;
			heap[i].free->last=(char*)heap[i].free+PAGE_SIZE;
		}

		addr=(char*)heap[i].free->last-heap[i].size;

		if(heap[i].free==(FREE*)addr)
		{
			heap[i].free=((FREE*)addr)->next;
			((FREE*)addr)->prev->next=((FREE*)addr)->next;
			((FREE*)addr)->next->prev=((FREE*)addr)->prev;
		}
		else heap[i].free->last=addr;
	}
OUT:
	exit_spinlock(&heap[i].gate);

	return addr;
}


/*
 * ꡼
 * parameters : Address
 */
void kfree(void *ptr)
{
	uint i;
	FREE *p,*end;


	if(ptr==NULL)return;

	if((i=(int)get_physpage_from_addr(ptr)->heap_num)==0)return;

	enter_spinlock(&heap[i].gate);
	{
		/* Free linkϾ */
		for(p=heap[i].free;p!=&guard[i];p=p->next)
			if(p>(FREE*)ptr)break;

		/* Link */
		p->prev->next=(FREE*)ptr;
		((FREE*)ptr)->prev=p->prev;
		((FREE*)ptr)->next=p;
		((FREE*)ptr)->last=(char*)ptr+heap[i].size;
		p->prev=(FREE*)ptr;

		/* ɥ쥹³ƤХ꡼Ĥʤ */
		end=((FREE*)ptr)->prev;
		do
		{
			p=p->prev;

			if(p->last==(char*)p->next)
			{
				p->last=p->next->last;
				p->next=p->next->next;
			}

			/* ꡼PAGE_SIZEʤڡ */
			if(!((uint)p&(PAGE_SIZE-1))&&(p->last>=(char*)p+PAGE_SIZE))
			{
				if(p->last>(char*)p+PAGE_SIZE)
				{
					p->prev->next=(FREE*)((char*)p+PAGE_SIZE);
					p->prev->next->next=p->next;
					p->prev->next->prev=p->prev;
					p->prev->next->last=p->last;
					p->next->prev=p->prev->next;
				}
				else
				{
					p->prev->next=p->next;
					p->next->prev=p->prev;
				}
				unlink_phys_page((uint)p,0);

				break;
			}

		}while(p!=end);

		/* Free memory link Ƭ */
		heap[i].free=guard[i].next;
	}
	exit_spinlock(&heap[i].gate);
}


/***********************************************************************************
 *
 * ڡ󥰴ؿ
 *
 * ڡȤξ
 * ȥȤǤ뤳
 *
 ***********************************************************************************/

enum{
	EMPTY_PB_SIZE=PAGE_SIZE/sizeof(uint),
	EMPTY_PB_START_SECTER=2					/* Ѳĥϥǥå */
};

typedef struct{
	int next;					/* index */
	int gate;					/* ԥå */
	uint index[EMPTY_PB_SIZE];
}PAGE_BACKUP;

/* ڡХåå׶ΰ襤ǥå */
static PAGE_BACKUP page_backup={0,0};
static int pb_din;
static int pb_secters;
static uchar *pb_count[PAGE_BACKUP_SIZE_MAX/(PAGE_SIZE*PAGE_SIZE)];


/*
 * ͥڡơ֥ꤹ
 * return : Page directory or NULL
 */
uint *init_idle_page()
{
	void *stack;
	uint *idle_pagedir,*pagetable;
	uint i;


	/* ͥڡǥ쥯ȥ */
	if((idle_pagedir=(uint*)alloc_kernel_page())==NULL)return NULL;
	memset(idle_pagedir,0,PAGE_SIZE);
	for(i=0;i<KERNEL_STACK_BEG/PAGEDIR_SIZE;++i)
		idle_pagedir[i]=i*PAGEDIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M;

	/* ͥ륹åڡƤ */
	if((pagetable=(uint*)alloc_kernel_page())==NULL)return NULL;
	memset(pagetable,0,PAGE_SIZE);
	idle_pagedir[KERNEL_STACK_BEG/PAGEDIR_SIZE]=(uint)pagetable|PAGE_PRESEN|PAGE_RW;
	if((stack=alloc_kernel_page())==NULL)return NULL;
	pagetable[1023]=(uint)stack|PAGE_PRESEN|PAGE_RW;

	/* ꡼ޥåץIOڡѥǥ쥯ȥ */
	for(i=IOMAP_BEG/PAGEDIR_SIZE;i<1024;++i)
	   	idle_pagedir[i]=i*PAGEDIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M|PAGE_CASH_DISABLE;

	/* ڡ󥰳 */
	asm volatile(
			"movl	%%eax,%%cr3\n"			/* Set page directory address */
			"movl	$0x10,%%eax\n"
			"movl	%%eax,%%cr4\n"			/* 4Mڡĥ */
			"movl	%%cr0,%%eax\n"
			"orl	$0x80010000,%%eax\n"	/* Enable paging,Enable wp(ѡХν񤭹ݸ) */
			"movl	%%eax,%%cr0\n"
			"jmp	1f\n"
		"1:"
		::"a"(idle_pagedir)
	);

	return idle_pagedir;
}


/*
 * ڡХååѥǥХΥޥȡ
 * parameters : device path
 * return : 0 or error=-1
 */
int mount_page_backup_dev(const char *dev_path)
{
	int fd;
	int din;
	DEV_STAT dev_stat;
	uint i,j,last,index;


	/* Device open */
	if((fd=sys_open(dev_path,0))==-1)return -1;
	if((din=get_inode(fd))==-1)return -1;
	pb_din=din;

	/* ѡƥ󥿥פγǧ */
	if(get_dev_stat(din,&dev_stat)==-1)return -1;
	if(dev_stat.prt_type!=PT_TYPE_PAGING)return -1;

	/* ڡХååפꡣ */
	pb_secters=PAGE_SIZE/dev_stat.sect_size;
	last=dev_stat.all_sect;
	if(last>PAGE_BACKUP_SIZE_MAX/pb_secters+EMPTY_PB_START_SECTER)
		last=PAGE_BACKUP_SIZE_MAX/pb_secters+EMPTY_PB_START_SECTER;
	index=pb_secters*(EMPTY_PB_SIZE-1)+EMPTY_PB_START_SECTER;
	j=0;
	for(i=index+pb_secters;i<last;i+=pb_secters)
	{
		page_backup.index[j++]=i;

		if(j>=EMPTY_PB_SIZE)
		{
			j=0;
			if(write_direct(din,page_backup.index,pb_secters,index)!=pb_secters)return -1;
			index=i;

			/* ʹԾɽ */
			printk("Mount page backup device %d%%\r",i/(last/100));
		}
	}
	page_backup.index[j]=0;
	if(write_direct(din,page_backup.index,pb_secters,index)!=pb_secters)return -1;

	/* ʹԾɽ */
	printk("Mount page backup device 100%%\n");

	/* ǽΥڡХååץǥåꡣ */
	i=EMPTY_PB_START_SECTER;
	for(j=0;j<EMPTY_PB_SIZE;++j)
	{
		if(i>=last)
		{
			page_backup.index[j]=0;
			break;
		}
		page_backup.index[j]=i;
		i+=pb_secters;
	}

	/* ȥơ֥ν */
	last=(last*dev_stat.sect_size+(PAGE_SIZE*PAGE_SIZE)-1)/(PAGE_SIZE*PAGE_SIZE);
	for(i=0;i<last;++i)
	{
		if((pb_count[i]=(uchar*)alloc_kernel_page())==NULL)return -1;
		memset(pb_count[i],0,PAGE_SIZE);
	}

	return 0;
}


/*
 * ڡХååפ롣
 * return : ֥å or error=-1
 */
int get_empty_bp()
{
	int blk;


	enter_spinlock(&page_backup.gate);
	{
		if((blk=page_backup.index[page_backup.next])==0)return -1;		/* ֥åʤ */

		if(page_backup.next++==EMPTY_PB_SIZE)
		{
			if(read_cache(pb_din,page_backup.index,pb_secters,blk)!=pb_secters)return -1;
			page_backup.next=0;
		}
	}
	exit_spinlock(&page_backup.gate);

	return blk;
}


/*
 * ڡХååפɲä롣
 * parameters : ڡХååץ֥å
 * return : 0 or error=-1
 */
int add_empty_bp(int blk)
{
	enter_spinlock(&page_backup.gate);
	{
		if(--page_backup.next<0)
		{
			if(write_cache(pb_din,page_backup.index,pb_secters,blk)!=pb_secters)return -1;
			page_backup.next=EMPTY_PB_SIZE;
		}

		page_backup.index[page_backup.next]=blk;
	}
	exit_spinlock(&page_backup.gate);

	return 0;
}


/*
 * ڡХååץǥХλȲ1䤹
 * parameters : block number
 */
void increment_pb_count(uint block)
{
	int tmp=pb_secters*PAGE_SIZE;


	block-=EMPTY_PB_START_SECTER;
	++pb_count[block/tmp][(block%tmp)/pb_secters];
}


/*
 * ڡХååץǥХλȲ1餹
 * parameters : block number
 */
void decrement_pb_count(uint block)
{
	int tmp=pb_secters*PAGE_SIZE;


	block-=EMPTY_PB_START_SECTER;
	if(--pb_count[block/tmp][(block%tmp)/pb_secters]==0)
		add_empty_bp(block);
}


/*
 * Buck up used page into page store device
 * parameters : physical address
 * returns : 0 or Error number
 */
int buckup_page(void *addr)
{
	PROC *proc;
	uint *page_entry;
	int blk;


	proc=get_physpage_from_addr(addr)->proc;
	page_entry=get_page_addr((uint)addr,proc->pagedir);

	/* page tableԺߤ */
	*page_entry&=~PAGE_PRESEN;

	/* process¹ʤpage tableTBLեå夹 */
	if((proc->cpu!=get_current_cpu())&&(cputask[proc->cpu].current_task==proc))
		issue_interrupt_to_cpu(proc->cpu,FLASH_PAGEDIR_VECT);

	/* Store page */
	if((blk=get_empty_bp())==0)goto ERR;
	if(write_cache(pb_din,addr,pb_secters,blk)!=pb_secters)goto ERR;
	increment_pb_count(blk);
	*page_entry=blk;

	return 0;

ERR:
	*page_entry|=PAGE_PRESEN;

	return -1;
}


/*
 * ڡХååץǥХ꡼˽᤹
 * parmeters : memory buffer,device block
 * return : 0 or error=-1
 */
int restore_page(void *buf,uint blk)
{
	/* ǥХɤ߹ߡ */
	if(read_cache(pb_din,buf,pb_secters,blk)!=pb_secters)return -1;

	/* ȥ󥿤򸺤餹 */
	decrement_pb_count(blk);

	return 0;
}


/******************************** ̤ ***********************************************
 *
 * Set pagetable
 * parameters : Load page address,Sorce page address,Page flag,Load process
 * return : 0 or Error number
 *
int load_user_page(void *dist,int flag,PROC *proc)
{
	void *page;
	uint *pagetable;


	enter_spinlock(&proc->pagedir_gate);
	{
		pagetable=(uint*)proc->pagedir[(uint)dist/PAGEDIR_SIZE];

	    if(pagetable==0)
	    {
	    	***page tableƤ
	    	if((pagetable=(uint*)alloc_kernel_page())==NULL)goto ERROR;
	    	memset(pagetable,0,PAGE_SIZE);
	    	proc->pagedir[(uint)dist/PAGEDIR_SIZE]=(uint)pagetable|PAGE_PRESEN|PAGE_USER|PAGE_RW;
	    }
	    else pagetable=(uint*)((uint)pagetable&PAGE_ROUNDDOWN);

		****pageƤ
		if((page=alloc_user_page(&pagetable[((uint)dist&(PAGEDIR_SIZE-1))/PAGE_SIZE]))==NULL)goto ERROR;
		pagetable[((uint)dist&(PAGEDIR_SIZE-1))/PAGE_SIZE]=(uint)page|PAGE_PRESEN|PAGE_USER|flag;
	}
	exit_spinlock(&proc->pagedir_gate);

	return 0;

ERROR:
	exit_spinlock(&proc->pagedir_gate);

	return -ENOMEM;
}


 *
 * page table
 * text sectionstackʳdata section롣user stack1pageĤƳ롣
 * parameters : process
 *
void free_user_page(PROC *proc)
{
	uint *page;
	int i,j;


	enter_spinlock(&proc->pagedir_gate);
	{
		***user stackκǽpageĤƳ
		page=(uint*)(proc->pagedir[USER_STACK_BEG/PAGEDIR_SIZE]&PAGE_ROUNDDOWN);
	    for(j=0;j<PAGE_SIZE/sizeof(uint)-1;++j)
	    {
	    	if(page[j]==0)continue;
	    	else if(page[j]&PAGE_PRESEN)
	    		unlink_phys_page((void*)page[j]);
			else
			{
				if(--page_store_ref_table[page[j]>>1]==0)
					clear_page_store_use(page[j]>>1);
			}

			page[j]=0;
		}

		***Ĥuser page򤹤٤Ƴ
		for(i=USER_BEG/PAGEDIR_SIZE;i<USER_STACK_BEG/PAGEDIR_SIZE;++i)
	    	if(proc->pagedir[i]&PAGE_PRESEN)
	    	{
	    		page=(uint*)(proc->pagedir[i]&PAGE_ROUNDDOWN);
	    		for(j=0;j<PAGE_SIZE/sizeof(uint);++j)
	    		{
	    			if(page[j]==0)continue;
	    			else if(page[j]&PAGE_PRESEN)unlink_phys_page((void*)page[j]);
					else
					{
						if(--page_store_ref_table[page[j]>>1]==0)
							clear_page_store_use(page[j]>>1);
					}
				}

				***page table
				unlink_phys_page(page);

				***page direstory0ꥢ
				proc->pagedir[i]=0;
			}
	}
	exit_spinlock(&proc->pagedir_gate);
}
*****************************************************************************************************/

/*
 * ڡե㳰
 * parameters : page fault address,Exception frame
 */
void page_fault(uint fault_addr,EXCEPT_FRAME frame)
{
	/* 顼ɥӥåȥޥ */
	enum{
		PRESEN=1,
		RW_MODE=2,
		USER_MODE=4,
		RSVBIT=8,
	};

	void *alloc_page;
	uint *current_page;
	uint *page_dir;
	int array;


	/* øڡȿ */
	if(((fault_addr<KERNEL_END)||(fault_addr>IOMAP_BEG))&&(frame.error&USER_MODE))
	{
		printk("Page privilege violation!\n");
		goto ERR;
	}

	current_page=get_page_addr(fault_addr,get_current_task()->pagedir);

	/* ڡԺߡ */
	if((frame.error&PRESEN)==0);
	{
		/* ʪڡγơ */
		if((alloc_page=alloc_user_page(current_page))==NULL)
		{
			printk("Fail alloc physical page!\n ");
			goto ERR;
		}

		/* Хååפꡣ */
		if(*current_page!=0)
			if(restore_page(alloc_page,*current_page)==-1)
			{
				printk("Fail restore page!\n ");
				goto ERR;
			}

		*current_page|=(uint)alloc_page|PAGE_PRESEN|PAGE_RW|PAGE_USER;

		return;
	}

	if((frame.error&RW_MODE)==RW_MODE)
	{
		/* ԡ饤Ƚ */
		if(*current_page&PT_COPY_ON_WRITE)
		{
			page_dir=get_current_task()->pagedir;

			if(unlink_phys_page(*current_page&~(PAGE_SIZE-1),1)==1)
			{
				*current_page=(*current_page&~PT_COPY_ON_WRITE)|PAGE_RW;
				page_dir[fault_addr/PAGEDIR_SIZE]&=~PT_COPY_ON_WRITE;

				return;
			}

			/*
			 * ڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤵƤϡ
			 * ڡơ֥Ƥ롣
			 */
			if(page_dir[fault_addr/PAGEDIR_SIZE]&PT_COPY_ON_WRITE)
			{
				array=fault_addr/PAGEDIR_SIZE;

				if((alloc_page=alloc_kernel_page())==NULL)
				{
					printk("Fail alloc physical page!\n ");
					goto ERR;
				}
				memcpy(alloc_page,(void*)(page_dir[array]&~(PAGE_SIZE-1)),PAGE_SIZE);
				page_dir[array]=((page_dir[array]&(PAGE_SIZE-1))|(uint)alloc_page)&~PT_COPY_ON_WRITE;
			}

			/* ʪڡγơ */
			if((alloc_page=alloc_user_page(current_page))==NULL)
			{
				printk("Fail alloc physical page!\n ");
				goto ERR;
			}

			/* ڡƤƤڡ˥ԡ롣 */
			memcpy(alloc_page,(void*)(*current_page&~(PAGE_SIZE-1)),PAGE_SIZE);

			*current_page=(uint)alloc_page|PAGE_PRESEN|PAGE_RW|PAGE_USER;
		}

		/* 񤭹߰ȿ */
		else
		{
			printk("Page writing violation!\n ");
			goto ERR;
		}

		return;
	}

	/* ޤϲǽΥ顼 */
	printk("Can not recover page fault!");
ERR:
	/* ץ */
/************************************************/
	cli();
	idle();
/************************************************/
}


/***********************************************************************************
 *
 * ƥॳѴؿ
 *
 ***********************************************************************************/


/*
 * forkˤ꡼ƥȤ򥳥ԡ
 * parameters : Destination page directory,Return stack offset
 * return : New Page directory or NULL
 */
uint *fork_page(PROC *org_proc,void **stack)
{
	uint *dir,*org_page_tbl,*page_tbl;
	int i;


	/* ƤΥڡǥ쥯ȥҤ˥ԡ롣 */
	if((dir=(uint*)alloc_kernel_page())==NULL)return NULL;
	memcpy(dir,org_proc->pagedir,PAGE_SIZE);

	/* ͥ륹åƤ롣 */
	if((page_tbl=(uint*)alloc_kernel_page())==NULL)goto ERR;

	dir[KERNEL_STACK_BEG/PAGEDIR_SIZE]=(uint)page_tbl|PAGE_PRESEN|PAGE_RW;
	org_page_tbl=(uint*)(org_proc->pagedir[KERNEL_STACK_BEG/PAGEDIR_SIZE]&~(PAGE_SIZE-1));
	if((*stack=alloc_kernel_page())==NULL)goto ERR;
	memcpy(*stack,(void*)(org_page_tbl[1023]&~(PAGE_SIZE-1)),PAGE_SIZE);
	page_tbl[1023]=(uint)*stack|PAGE_PRESEN|PAGE_RW;
	memset(page_tbl,0,1023*sizeof(uint));

	/*
	 * Userΰ򥳥ԡ饤Ȥꤹ롣
	 * ƤΥڡơ֥륨ȥ꡼񤭹߲Ĥʤ顢񤭹ԲĤˤƥԡ饤ȥե饰ꤹ롣
	 * ҤΥڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤹ롣
	 */
	enter_spinlock(&org_proc->pagedir_gate);
	{
		for(i=USER_BEG/PAGEDIR_SIZE;i<USER_END/PAGEDIR_SIZE;++i)
			if(dir[i]!=0)
			{
				org_page_tbl=(uint*)(dir[i]&~(PAGE_SIZE-1));
				for(i=0;i<PAGE_SIZE/sizeof(uint);++i)
				{
					if(org_page_tbl[i]==0)continue;
					else if((org_page_tbl[i]&PAGE_PRESEN)==0)		/* Хåå */
						increment_pb_count(org_page_tbl[i]);
					else if(org_page_tbl[i]&PAGE_RW)
					{
						org_page_tbl[i]=(org_page_tbl[i]&~PAGE_RW)|PT_COPY_ON_WRITE;
						link_phys_page(org_page_tbl[i]&~(PAGE_SIZE-1));
					}
				}

				dir[i]|=PT_COPY_ON_WRITE;
			}
	}
	exit_spinlock(&org_proc->pagedir_gate);

	return dir;


ERR:
	kfree(dir);

	return NULL;
}
