/*
 * mm.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * mm.c ѥإåե
 */


#ifndef mm_h
#define mm_h


#include"types.h"
#include"proc.h"


#ifndef ASM_FILE


enum{
	PAGE_SIZE=0x1000,			/* Page size */
	PAGEDIR_SIZE=0x400000,		/* Page directory size */

	/* Page table flag */
	PAGE_PRESEN=		0x1,	/* Is presence */
	PAGE_RW=			0x2,	/* Is read and write,not read only */
	PAGE_USER=			0x4,	/* Privilege is user,not supervisor */
	PAGE_CASH_DISABLE=	0x10,	/* Disable cash,not able cash */
	PAGE_4M=			0x80	/* Page size is 4M,not 4K */
};


extern uint all_memory_size;


extern inline void flash_tbl(uint *pagedir)
{
	asm volatile(
		"movl	%%eax,%%cr3"
		::"a"(pagedir)
	);
}

extern void init_mm();
extern uint *init_idle_page();
extern uint *fork_page(PROC*,void**);
extern int load_user_page(void*,int,PROC*);
extern void free_user_page(PROC*);
extern void *kmalloc(size_t);
extern void kfree(void*);


#endif


#endif
