/*
 * unistd.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<stddef.h>
#include<callgate.h>
#include<system.h>
#include<share/syscall.h>
#include<unistd.h>


int execve(const char *path, char *const argv[], char *const envp[])
{
	return syscall4(SYS_EXEC,(int)path,(int)argv,(int)envp);
}


void _exit(int state)
{
	syscall2(SYS_EXIT,(int)state);
}


pid_t fork(void)
{
	return syscall1(SYS_FORK);
}


off_t lseek(int fildes,off_t offset,int whence)
{
	int rest;


	if((rest=syscall4(SYS_LSEEK,fildes,offset,whence))<0)
	{
		sys_info->errorNo=-rest;
		return -1;
	}
	
	return rest;
}


ssize_t read(int fildes,void *buf,size_t nbyte)
{
	int rest;
	
	
	if((rest=syscall4(SYS_READ,fildes,(int)buf,(int)nbyte))<0)
	{
		sys_info->errorNo=-rest;
		return -1;
	}
	
	return rest;
}


int rmdir(const char *path)
{
	int rest;


	if((rest=syscall2(SYS_RMDIR,(int)path))<0)
	{
		sys_info->errorNo=-rest;
		return -1;
	}
	
	return 0;
}


ssize_t write(int fildes,const void *buf,size_t nbyte)
{
	int rest;
	
	
	if((rest=syscall4(SYS_WRITE,fildes,(int)buf,(int)nbyte))<0)
	{
		sys_info->errorNo=-rest;
		return -1;
	}
	
	return rest;
}


int close(int fildes)
{
	int rest;
	
	
	if((rest=syscall2(SYS_CLOSE,fildes))<0)
	{
		sys_info->errorNo=-rest;
		return -1;
	}
	
	return 0;
}


int brk(void *end_segment)
{
	static uint allocLast=0;
	uint alloc_last;


	if((alloc_last=ROUNDUP((uint)end_segment,PAGE_SIZE)-1)>allocLast)
	{
		if(syscall2(SYS_BRK,alloc_last)!=0)return -1;
		allocLast=alloc_last;
	}

	return 0;
}


void *sbrk(ptrdiff_t increment)
{
	void *begin;


	begin=(void*)(sys_info->lastAddr+1);

	if(increment>0)
	{
		if(brk((void*)(sys_info->lastAddr+increment))!=0)return NULL;
		sys_info->lastAddr+=increment;
	}

	return begin;
}


int unlink(const char *path)
{
	int rest;


	if((rest=syscall2(SYS_UNLINK,(int)path))<0)
	{
		sys_info->errorNo=-rest;
		return -1;
	}
	else return 0;
}
