/*
 * fs.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef fs_h
#define fs_h


#include"types.h"
#include"proc.h"
#include"user/include/share/fcntl.h"
#include"user/include/share/unistd.h"
#include"user/include/share/stat.h"
#include"user/include/share/dirent.h"


#ifndef ASM_FILE


enum{
	/* File type */
	NORMAL_FILE=1,
	DIRECTORY=2,
	SYMBOL_LINK=3,
	DEVICE_FILE=4,
};


/* fstatѥե¤Ρ */
typedef struct stat FSTAT;

/* ե륷ƥ।ե᡼¤ */
typedef struct{
	const char *name;
	uint (*mount)(int);							/* prm:device inode ret:root directory block or error=0 */
	int (*umount)(int);							/* prm:device inode ret:0 or error=-1 */
	int (*open)(const char*,int,uint,int);		/* prm:path,device inode,directory inode,flag ret:inode block or error number */
	int (*close)(int,uint);						/* prm:device inode,inode ret:0 or error=-1 */
	int (*read)(int,uint,void*,size_t,size_t);	/* prm:device inode,inode,bffer,read bytes,begin byte ret:read bytes or error=-1 */
	int (*write)(int,uint,void*,size_t,size_t);	/* prm:device inode,inode,bffer,write bytes,begin byte ret:write bytes or error=-1 */
	int (*ioctr)(int,uint,int,void*);			/* prm:device inode,inode,command,parameter ret:0 or error=-1 */
	/* prm:device inode,old dir inode,old path,new dir inode,new path ret:0 or error number */
	int (*rename)(int,uint,const char*,uint,const char*);
	int (*creat)(const char*,int,uint,int);		/* prm:path,device inode,directory inode,mode ret:directory block or error=0 */
	int (*opendir)(const char*,int,uint,DIR*);	/* prm:path,device inode,directory inode,DIR struct ret:inode block or error number */
	int (*mkdir)(const char*,int,uint,int);		/* prm:path,device inode,parent directory block,mode ret:directory block or error=0 */
	int (*fstat)(uint,FSTAT*);					/* prm:inode,FSTAT buffer ret:0 or error number */
	int (*delete)(const char*,int,uint,int);	/* prm:path,device inod,directory block,file type ret:0 or error number */
	int (*readdir)(int,uint,DIR*,char*);		/* prm:device inode,inode,DIR struct,name buffer ret:0 or error number */
}FS;

/* ե륪ץؿѹ¤ */
typedef struct{
	ushort din;			/* device inode number */
	uint inode;			/* inode֥å */
	size_t offset;		/* ɤ߽񤭳ϥեå */
}OPEN_F;


extern FS *fs_info[];


/*
 * ʸNULLʸޤӤפХȿ֤
 * parameters : Destination string,Sorce string
 */
extern inline int cmpString(const char *str1,const char *str2)
{
	int i;


	for(i=0;str1[i]&str2[i];++i)
		if(str1[i]!=str2[i])break;

	return i;
}


/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =Υѥݥ or ԰=NULL;
 */
extern inline const char *cmpPathNull(const char *path1,const char *path2)
{
	while(*path1==*path2++)
		if(*path1++=='\0')return path2-1;

	if((*(path2-1)=='/')&&(*path1=='\0'))return path2;
	else return NULL;
}

/*
 * ̾ʸȥѥʸӤ롣
 * parameters : destination name string,sorce path string,ӥХȿ
 * return : =0 or 礭=1 or =-1
 */
extern inline int cmpPathLength(const char *name,const char *path,int count)
{
	int i;


	for(i=0;i<count;++i)
		if(name[i]!=path[i])
		{
			if((uchar)name[i]>(uchar)path[i])return 1;
			else return -1;
		}

	if((path[count]=='/')||(path[count]=='\0'))return 0;

	return -1;
}

/*
 * ̾ʸȥѥʸӤ롣
 * פ˼Υѥɥ쥹롣
 * parameters : destination name string,sorce path string pointer
 * return : =0 or 礭=1 or =-1
 */
extern inline int cmpPath(const char *name,const char **path)
{
	const char *p=*path;


	while(*name==*p++)
		if(*name++=='\0')
		{
			*path=p-1;
			return 0;
		}

	if((*--p=='/')&&(*name=='\0'))
	{
		*path=p+1;
		return 0;
	}
	if(*name>*p)return 1;
	return -1;
}

/*
 * ѥ'/'ޤ'\0'ޤǥԡơ'\0'ղä롣
 * parameters : Destination string,Sorce string
 * return : next path
 */
extern inline const char *cpyPath(char *str,const char *path)
{
	while((*str=*path++)!='\0')
		if(*str++=='/')
		{
			*(str-1)='\0';
			return path;
		}

	return path-1;
}

/*
 * ѥʸ󥵥Ϥ롣
 * parmeters : path
 */
extern inline size_t pathLen(const char *path)
{
	const char *p=path;


	while(*p++!='/')
		if(*p=='\0')break;

	return (size_t)(p-path-1);
}

/*
 * ѥ饹ȥѥɤȽꤹ롣
 * parameters : path
 * return : name size or failed=-1;
 */
extern inline int isLastPath(const char *path)
{
	int i;


	for(i=0;path[i]!='\0';++i)
		if(path[i]=='/')return -1;

	return i;
}

extern void init_fs();
extern int mount_dev_fs(int);
extern int regist_fs(FS*);
extern int init_file_struct(PROC*);
extern int cpy_file_struct(PROC*,PROC*);
extern void releaseFileStruct(void *);
extern int get_inode(int);
extern int mountRoot(const char*,const char*);
extern int mountPageBackupDev(const char*);
extern int exec_open(const char*,OPEN_F*);
extern int exec_read(OPEN_F*,void*,size_t);
extern int sys_open();
extern int sys_close();
extern int sys_read();
extern int sys_write();
extern int sys_ioctr();
extern int sys_lseek();
extern int sys_mkdir();
extern int sys_creat();
extern int sys_rename();
extern int sys_unlink();
extern int sys_rmdir();
extern int sys_lock();
extern int sys_mount();
extern int sys_umount();
extern int sys_opendir();
extern int sys_closedir();
extern int sys_readdir();
extern int chdir();


#endif


#endif
