/*
 * lib.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ͥ饤֥꡼
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"time.h"
#include"console.h"
#include"mm.h"


int (*write_tty)(const char*,size_t,size_t);


/*
 * ̽ϴؿ
 *  : ʸ(%d,%u,%x,%sб)...
 */
void printk(const char *str,...)
{
	enum{BUF_SIZE=16};

	char buf[BUF_SIZE];
	uint *arg;
	int ivalue;
	uint uvalue;
	int i,j,begin;


	arg=(uint*)&str+1;

	for(i=begin=0;str[i]!='\0';++i)
	{
		if(str[i]=='%')
		{
			write_tty(&str[begin],i-begin,0);

			switch(str[++i])
			{
				case 'd':							/* Ѵ */
					ivalue=*arg++;
					if(ivalue>=0)
						for(j=BUF_SIZE-1;;--j)
						{
							buf[j]=ivalue%10+'0';
							if(!(ivalue/=10))break;
						}
					else
					{
						for(j=BUF_SIZE-1;;--j)
						{
							buf[j]=(ivalue%10)*-1+'0';
							if(!(ivalue/=10))break;
						}
						buf[--j]='-';
					}
					write_tty(&buf[j],BUF_SIZE-j,0);
					break;
				case 'u':							/* ̵Ѵ */
					uvalue=*arg++;
					for(j=BUF_SIZE-1;;--j)
					{
						buf[j]=uvalue%10+'0';
						if(!(uvalue/=10))break;
					}
					write_tty(&buf[j],BUF_SIZE-j,0);
					break;
				case 'x':							/* 16ʿѴ */
					uvalue=*arg++;
					for(j=BUF_SIZE-1;;--j)
					{
						buf[j]=uvalue%16+'0';
						if(buf[j]>'9')buf[j]+='a'-'9'-1;
						if(!(uvalue/=16))break;
					}
					write_tty(&buf[j],BUF_SIZE-j,0);
					break;
				case 's':							/* ʸɽ */
					write_tty((char*)*arg,strlen((char*)*arg),0);
					++arg;
					break;
				case '%':
					write_tty("%",1,0);
					break;
				default:
					write_tty("%",1,0);
					--i;
			}
			begin=i+1;
		}
		else if(str[i]=='\n')
		{
			write_tty(&str[begin],i-begin,0);
			write_tty("\n\r",2,0);
			begin=i+1;
		}
	}

	write_tty(&str[begin],i-begin,0);
}


/*
 * micro seccond ޡ
 *  : (1microseccondñ)
 */
void micro_timer(uint count)
{
	uint64 end;


	end=rdtsc();
	end+=count*clock_1micro;
	while(rdtsc()<end);
}


/*
 * mili seccond timer
 * param : value of counts(1ms)
 */
void mili_timer(uint count)
{
	uint64 end;


	end=rdtsc();
	end+=count*clock_1m;
	while(rdtsc()<end);
}


/*
 * Convert ascii to integer
 * parameters : string
 * return : integer or 0(Ǥʤ)
 */
int atoi(const char *str)
{
	int rest=0;


	for(;*str!='\0';++str)
	{
		if((*str<'0')||(*str>'9'))return 0;
		rest=rest*10+*str-'0';
	}

	return rest;
}
