/*
 * proc.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץط
 */


#include"types.h"
#include"mm.h"
#include"fs.h"
#include"errno.h"
#include"interrupt.h"
#include"lock.h"
#include"segment.h"
#include"time.h"
#include"elf.h"
#include"proc.h"
#include"except.h"
#include"test.h"


/* tssǼ¤(104Х) */
typedef struct{
	uint link,esp0,ss0,esp1,ss1,esp2,ss2,cr3,eip,eflags,eax,ecx,
		edx,ebx,esp,ebp,esi,edi,es,cs,ss,ds,fs,gs,ldts,tflag_iomap;
}TSS;


CPU cputask[MAX_CPU];		/* Task infomations for each cpu */

/* TSS󥰻Υååɬ */
static TSS kernel_tss={
	0,
	KERNEL_ESP_BEG,		/* esp0 */
	KERNEL_DATA_DES,	/* ss0 */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
static PROC *idle_proc[MAX_CPU];	/* Idle process */


/******************************************************************************************************
 *
 * < 塼륯饹 >
 *
 * ա
 *  Υ塼ؤadddeleteؿϥåԤäƤʤΤǡꥢ˸ƤФʲä줿ȣ
 *  ϼ¹Ԥɬפ롣
 *
 *******************************************************************************************************/

/*
 * GLOBAL
 * Add task to shedule.
 * NOTE!
 * 	¾ץƤФ롣
 * parameters : Process,wait flag
 */
void add_to_schedule(PROC *proc,int flag)
{
/*	int eflag;*/
	int cpu=proc->cpu;
	PROC *p;


/*	enterCli(&eflag);*/
/*	enter_spinlock(&cputask[cpu].gate);*/
	{		
		/* ȥե饰γǧ */
		if(proc->state==flag)
		{
			proc->state=TASK_RUNNING;

			if(cputask[cpu].current_task==idle_proc[cpu])
			{
				if(idle_proc[cpu]->next==idle_proc[cpu])
				{
					proc->next=proc;
					proc->prev=proc;
					idle_proc[cpu]->next=proc;
				}
				else
				{
					p=idle_proc[cpu]->next;
					proc->prev=p->prev;
					proc->next=p;
					p->prev=proc;
					proc->prev->next=proc;
				}
			}
			else
			{
	   	     	/* ȥץμ˲ä */
				p=cputask[cpu].current_task;
				proc->prev=p;
				proc->next=p->next;
				p->next->prev=proc;
				p->next=proc;
			}
		}
	}
/*	exit_spinlock(&cputask[cpu].gate);*/
/*	exitCli(&eflag);*/
}


/*
 * GLOBAL
 * Delete process.
 * NOTE!
 *  ץƤ֡
 * parameters : wait flag
 */
void del_from_schedule(int flag)
{
/*	int eflag;*/
	int cpu=get_current_cpu();
	PROC *proc=cputask[cpu].current_task;


/*	enterCli(&eflag);*/
/*	enter_spinlock(&cputask[cpu].gate);*/
	{
		proc->state=flag;

		/* Delete current task */
		if(proc->next==proc)
		{
			idle_proc[cpu]->next=idle_proc[cpu]->prev=idle_proc[cpu];
			proc->next=idle_proc[cpu];
		}
		else
		{
			proc->next->prev=proc->prev;
			proc->prev->next=proc->next;
		}
	}
/*	exit_spinlock(&cputask[cpu].gate);*/
/*	exitCli(&eflag);*/
}


/*
 * GLOBAL
 * Process switch
 * parameters : γ߻Υ֥åȥåesp,γ߻espͤ¸륹å
 * returns : Page directory
 */
uint *switch_task(uint esp,volatile uint before_esp)
{
	uint volatile *pbefore_esp=&before_esp;
	uint volatile *pesp=&esp;
	int cpu;
	PROC *current;


	cpu=get_current_cpu();
	current=cputask[cpu].current_task;
	*pbefore_esp=current->esp;
	current->esp=esp;

	current=current->next;
	*pesp=(uint)&current->esp;
	cputask[cpu].current_task=current;

	return getPageDir(current->mm_struct);
}


/******************************************************************************************************
 *
 * < ץ饹 >
 *
 *******************************************************************************************************/

extern int active_cpu;	/* ư CPU */


/*
 * PRIVATE
 * ֥ξʤCPU롣
 * retuuns : cpu number
 */
static int GetFewTaskCpu()
{
	int cpu=0;
	uint num;
	int i;


	num=cputask[0].proc_num;
	for(i=1;i<active_cpu;++i)
		if(cputask[i].proc_num<num)
		{
			num=cputask[i].proc_num;
			cpu=i;
		}

	return cpu;
}


/*
 * PUBLIC
 * ץ¹Բǽˤ
 * parameters : process
 */
void addNewProc(PROC *proc)
{
	proc->cpu=GetFewTaskCpu();
	proc->state=TASK_WAIT;
	add_to_schedule(proc,TASK_WAIT);
	++cputask[proc->cpu].proc_num;
}


/*
 * PUBLIC
 * exit()ǥץ򥹥塼뤫롣
 * parameters : process
 */
static void exitFromSchedule(PROC *proc)
{
	static PROC tmp_proc[MAX_CPU];
	int cpu=get_current_cpu();


	del_from_schedule(TASK_WAIT);
	tmp_proc[cpu].next=proc->next;
	cputask[cpu].current_task=&tmp_proc[cpu];
	--cputask[cpu].proc_num;
}


/******************************************************************************************************
 *
 * < ȥ饹 >
 *
 *******************************************************************************************************/

typedef struct PROC_LINK{
	struct PROC_LINK *next;
	struct PROC_LINK *prev;
}PROC_LINK;


/* PRIVATE ȥ塼󥯡 */
static WAIT_QUEUE waitQueueLink={NULL,NULL,0,0,&waitQueueLink,&waitQueueLink};

/* PRIVATE ߥȥ󥯡 */
static WAIT_INTR waitIntrLink={NULL,0,&waitIntrLink,&waitIntrLink};


/*
 * PRIVATE
 * PROC_LINK¤Υɥ쥹PROCɥ쥹롣
 */
static inline PROC *procLinkToProc(PROC_LINK *p)
{
	return (PROC*)((uint)p-(uint)&((PROC*)0)->wait_next);
}


/*
 * PRIVATE
 * ȥ󥯤˲ä롣
 * parameters : process
 */
static inline void addWaitQueueLink(WAIT_QUEUE *p)
{
	p->prev->next=p->next;
	p->next->prev=p->prev;
	p->next=waitQueueLink.next;
	p->prev=&waitQueueLink;
	waitQueueLink.next=p;
	p->next->prev=p;
}


/*
 * PRIVATE
 * ȥ󥯤
 * parameters : process
 */
static inline void delWaitQueueLink(WAIT_QUEUE *p)
{
	p->prev->next=p->next;
	p->next->prev=p->prev;
	p->next=p;
	p->prev=p;
}


/*
 * PRIVATE
 * ȥ󥯤˲ä롣
 * parameters : process
 */
static inline void addWaitIntrLink(WAIT_INTR *p)
{
	p->prev->next=p->next;
	p->next->prev=p->prev;
	p->next=waitIntrLink.next;
	p->prev=&waitIntrLink;
	waitIntrLink.next=p;
	p->next->prev=p;
}


/*
 * PRIVATE
 * ȥ󥯤
 * parameters : process
 */
static inline void delWaitIntrLink(WAIT_INTR *p)
{
	p->prev->next=p->next;
	p->next->prev=p->prev;
	p->next=p;
	p->prev=p;
}


/*
 * GLOBAL
 * Wait process
 * ñ
 * parameters : Wait queue
 */
void wait_proc(WAIT_QUEUE *queue)
{
	PROC *proc;
	PROC_LINK *p,*wait;


	wait=(PROC_LINK*)&queue->wait_next;

	enter_spinlock(&queue->gate);

	if(queue->flag==0)
	{
		queue->flag=1;
		wait->next=wait->prev=wait;
		exit_spinlock(&queue->gate);

		return;
	}
	else
	{
		proc=get_current_task();
		p=(PROC_LINK*)&proc->wait_next;

		/* Add process to wait queue */
		p->next=wait;
		p->prev=wait->prev;
		wait->prev->next=p;
		wait->prev=p;
		addWaitQueueLink(queue);

		exit_spinlock(&queue->gate);

		del_from_schedule(TASK_WAIT);
	}

	wait_task();
}


/*
 * GLOBAL
 * Wake up process
 * parameters : Wait queue
 */
void wake_proc(WAIT_QUEUE *queue)
{
	PROC *proc;
	PROC_LINK *p,*wait;


	wait=(PROC_LINK*)&queue->wait_next;

	/* Delete process from wait queue */
	enter_spinlock(&queue->gate);
	{
		if(wait->next!=wait)
		{
			p=wait->next;
			wait->next=p->next;
			wait->next->prev=wait;

			/* Add process to schedule */
			proc=procLinkToProc(p);
			add_to_schedule(proc,TASK_WAIT);

			if(wait->next==wait)delWaitQueueLink(queue);
		}
		else queue->flag=0;
	}
	exit_spinlock(&queue->gate);
}


/*
 * GLOBAL
 * ޡԤ
 * parameters : ޡ߹¤,(ms)
 * return : 0,ॢ-1
 */
int wait_intr(WAIT_INTR *wait,int time)
{
	wait->proc=get_current_task();

	cli();
	{
		if(wait->flag==1)
		{
			wait->flag=0;
			sti();
			return 0;
		}

		addWaitIntrLink(wait);
		set_timer(time);
		wait->flag=2;
		del_from_schedule(TASK_DEVICE_WAIT);
	}
	sti();

	wait_task();

	if(wait->flag==1)wait->flag=0;
	else
	{
		wait->flag=0;
		return -1;
	}

	return 0;
}


/*
 * GLOBAL
 * ޡԤ롣
 * parameters : ޡ߹¤
 * return : åɬ1
 */
int wake_intr(WAIT_INTR *wait)
{
	if(wait->flag==2)
	{
		delWaitIntrLink(wait);
		del_timer(wait->proc);
		wait->flag=1;

		/*
		 * 塼ؤɲäϽκǸ˹Ԥʤߤ
		 * θ夬̤ˤʤäƤޤ顼θˤʤ롣
		 */
		add_to_schedule(wait->proc,TASK_DEVICE_WAIT);
	}
	else wait->flag=1;

	return 1;
}


/******************************************************************************************************
 *
 * ƥॳ
 *
 *******************************************************************************************************/

/*
 * return : ƥץʤҥץID,ҥץʤ0,error=error number
 */
int sys_fork()
{
	void *stack;
	uint esp;
	PROC *parent,*child;


	parent=cputask[get_current_cpu()].current_task;
	if(parent->count_child>=MAX_CHILD)return -EAGAIN;

	/* PROC¤ΤƤ */
	if((child=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	memset(child,0,sizeof(PROC));
	child->parent=parent;
	child->brother=parent->child;
	parent->child=child;
	child->uid=parent->uid;
	child->gid=parent->gid;

	/* եط¤Τγơ */
	if(cpy_file_struct(parent,child)==-1)goto ERR;

	/* Page tableƤ */
	if((child->mm_struct=forkPage(parent->mm_struct,&stack))==NULL)goto ERR;

	/* ҥץstack˥ƥȤꤹ */
	if((esp=setContext((uint)stack))==0)return 0;		/* ҥץ */
	child->esp=esp;

	/* Add child process to schedule queue */
	addNewProc(child);

	++parent->count_child;

	return (int)child;

ERR:
	kfree(child);

	return -ENOMEM;
}


int sys_exec(const char *path,char **argv,char **envp,volatile SYSCALL4_FRAME frame)
{
	enum{PARAM=sizeof(int)*4};	/* ƥॳΰο  Хȿ */

	uint entry_addr,stack_esp;
	int rest;
	OPEN_F open_f;
	SYS_INFO *sys_info;


	if((rest=exec_open(path,&open_f))<0)return rest;

	/* ȴĶѿ桼å˥ԡ롣 */
	if((stack_esp=setArgAndEnv(argv,envp))==0)return -1;

	/* 桼ڡ롣 */
	releaseUserTextDataPage(get_current_task()->mm_struct);

	/* ELFХʥΥɡ */
	if((entry_addr=loadElf(&open_f))==0)return -1;

	/* å˥ƥꡣ */
	sys_info=(SYS_INFO*)(USER_ESP_BEG-sizeof(SYS_INFO));
	sys_info->lastAddr=getLastLinearAddr();

	/* ʥ륢ν */

	/* ƥॳե졼ꡣ */
	frame.es=USER_DATA_DES;
	frame.ds=USER_DATA_DES;
	frame.eip=entry_addr;
	frame.cs=USER_CODE_DES;
	frame.esp=stack_esp-PARAM;
	frame.ss=USER_DATA_DES;

	return 0;
}


/*
 * ڡǥ쥯ȥγ̥ץԤ
 * parameters : ƥץϤ
 */
int sys_exit(int state)
{
	void *mm_struct;
	PROC *proc=get_current_task();


	/* եǥץγ */
	releaseFileStruct(proc->file_struct);

	/* ޡγ */

	/* 塼뤫 */
	cli();
	exitFromSchedule(proc);

	/* ץ¤Τγ */
	mm_struct=proc->mm_struct;
	kfree(proc);

	/* Υ˥åơڡǥ쥯ȥ롣 */
	returnExit(mm_struct);

	return 0;
}


/******************************************************************************************************
 *
 * < 饹 >
 *
 *******************************************************************************************************/

/*
 * GLOBAL
 * Init taskcpu
 * cpu˥ꥢꤹɬפ
 * parameters : number of cpu
 * returns : NOERROR
 */
int init_cputask(int cpu)
{
	cputask[cpu].cpu=cpu;
	cputask[cpu].current_task=NULL;
	cputask[cpu].proc_num=0;
	cputask[cpu].gate=0;

	return 0;
}


/*
 * GLOBAL
 * TSSǥץꤹ
 *  : ǥץ͡TSSɥ쥹
 */
void set_tss(int des)
{
	set_gdt(des,&kernel_tss,104,TYPE_TSS);

	asm volatile(
		"movl	%0,%%eax\n"
		"ltr	%%ax"
		::"m"(des)
	);
}


/*
 * GLOBAL
 * Set idle process table
 * parameters : Page directory
 * returns : 0 or Error number
 */
int set_idle_proc(int cpu)
{
	/* Set process table */
	if((idle_proc[cpu]=(PROC*)kmalloc(sizeof(PROC)))==NULL)return -ENOMEM;
	memset(idle_proc[cpu],0,sizeof(PROC));
	idle_proc[cpu]->next=idle_proc[cpu];
	idle_proc[cpu]->prev=idle_proc[cpu];
	idle_proc[cpu]->cpu=cpu;
	idle_proc[cpu]->state=TASK_RUNNING;

	/* init paging */
	if((idle_proc[cpu]->mm_struct=initPaging())==NULL)return -1;

	if(init_file_struct(idle_proc[cpu])==-1)return -ENOMEM;

	/* add to schedule queue */
	cputask[cpu].current_task=idle_proc[cpu];

	return 0;
}
/*************************************************************************************************/
void test_proc()
{
}
/**************************************************************************************************/
