/*
 * proc.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץطإåե
 */


#ifndef proc_h
#define proc_h


#include"segment.h"


#ifndef ASM_FILE


enum{
	MAX_CHILD=8,		/* Max number of child processes */

	/* ץξ֡ */
	TASK_RUNNING=1,
	TASK_WAIT,
	TASK_DEVICE_WAIT,	/* ǥХԤ */
};


/* ץ¤ */
typedef struct PROC{
	struct PROC *next;			/* Schedule linkμΥץ */
	struct PROC *prev;			/* Schedule linkΥץ */
	struct PROC *wait_next;		/* next link for wait */
	struct PROC *wait_prev;		/* prev link for wait */
	uint esp;					/* ֤ƥȤΥåȥåesp */
	struct PROC *parent;		/* Parent process */
	struct PROC *child;			/* Child process */
	struct PROC *brother;		/* Link of brother process */
	ushort count_child;			/* Number of child processes */
	uchar cpu;					/* running cpu number ƯƤʤ-1ʲ*/
	uchar state;				/* ץξ֡ */
	ushort uid;					/* user ID. */
	ushort gid;					/* groupe ID. */
	int timer_count;			/* Counter for timer */
	int timer_type;				/* Timer type */
	void *signal_struct;		/* ʥ¤Ρ */
	void *mm_struct;			/* ꡼¤Υɥ쥹 */
	void *file_struct;			/* ե빽¤Υɥ쥹 */
}PROC;

/* ץȥ塼¤ */
typedef struct WAIT_QUEUE{
	void *wait_next;			/* ȥ󥯤μΥץ */
	void *wait_prev;			/* ȥ󥯤Υץ */
	int flag;					/* Wait flag */
	int gate;					/* Lock gate */
	struct WAIT_QUEUE *next;	/* Υȥ塼 */
	struct WAIT_QUEUE *prev;	/* Υȥ塼 */
}WAIT_QUEUE;

/* ޡԤѹ¤ */
typedef struct WAIT_INTR{
	PROC *proc;					/* Ԥץ */
	int flag;					/* ॢȥե饰 */
	struct WAIT_INTR *next;		/* γԤ¤Ρ */
	struct WAIT_INTR *prev;		/* γԤ¤Ρ */
}WAIT_INTR;

/* cpuȤΥ¤ */
typedef struct CPU{
	int cpu;				/* number of cpu */
	PROC *current_task;		/* ߤβƯprocess */
	uint proc_num;			/* ưץ */
	int gate;				/* Lock gate */
}CPU;


extern CPU cputask[];


/*
 * Get current cpu number
 * returns : current cpu number
 */
extern inline int get_current_cpu()
{
	int result;


	asm volatile(
		"xorl	%%eax,%%eax\n"\
		"str	%%ax\n"\
		"subl	%1,%%eax\n"\
		"shrl	$3,%%eax"
		:"=a"(result):"i"(TSS_DES)
	);

	return result;
}

/*
 * Get current task
 * return : Current process
 */
extern inline PROC *get_current_task()
{
	return cputask[get_current_cpu()].current_task;
}



extern void add_to_schedule(PROC*,int);
extern void del_from_schedule(int);
extern void wait_proc(WAIT_QUEUE*);
extern void wake_proc(WAIT_QUEUE*);
extern int wait_intr(WAIT_INTR*,int);
extern int wake_intr(WAIT_INTR*);
extern int init_cputask(int);
extern int set_idle_proc(int);
extern void set_tss(int);
extern void start_tasking();
extern int sys_fork();
extern int sys_exit();
extern int sys_exec();


#endif


#endif
