/*
 * stat.h
 */


#ifndef sys_stat_h
#define sys_stat_h


#include<sys/types.h>


enum{
	/* File type. */
	S_IFMT=0xF000,		/* format mask */

	/* File mode bits. */
	S_ISUID=0x0800,		/* Set-user-ID on execution. */
	S_ISGID=0x0400,		/* Set-group-ID on execution. */
	S_IRWXU=0x01C0,		/* Read, write, execute/search by owner. */
	S_IRUSR=0x0100,		/* Read permission, owner. */
	S_IWUSR=0x0080,		/* Write permission, owner. */
	S_IXUSR=0x0040,		/* Execute/search permission, owner. */
	S_IRWXG=0x0038,		/* Read, write, execute/search by group. */
	S_IRGRP=0x0020,		/* Read permission, group. */
	S_IWGRP=0x0010,		/* Write permission, group. */
	S_IXGRP=0x0008,		/* Execute/search permission, group. */
	S_IRWXO=0x0007,		/* Read, write, execute/search by others. */
	S_IROTH=0x0004,		/* Read permission, others. */
	S_IWOTH=0x0002,		/* Write permission, others. */
	S_IXOTH=0x0001,		/* Execute/search permission, others. */
};


/* The macro shall evaluate to a non-zero value if the test is true; 0 if the test is false. */
#define S_ISBLK(m)		/* Test for a block special file. */
#define S_ISCHR(m)		/* Test for a character special file. */
#define S_ISDIR(m)		/* Test for a directory. */
#define S_ISFIFO(m)		/* Test for a pipe or FIFO special file. */
#define S_ISREG(m)		/* Test for a regular file. */
#define S_ISLNK(m)		/* Test for a symbolic link. */
#define S_ISSOCK(m)		/* Test for a socket. */

/*
 * The implementation may implement message queues, semaphores, or shared memory objects as distinct
 * file types. The following macros shall be provided to test whether a file is of the specified type.
 * The value of the buf argument supplied to the macros is a pointer to a stat structure. The macro
 * shall evaluate to a non-zero value if the specified object is implemented as a distinct file type
 * and the specified file type is contained in the stat structure referenced by buf. Otherwise,
 * the macro shall evaluate to zero.
 */
#define S_TYPEISMQ(buf)			/* Test for a message queue. */
#define S_TYPEISSEM(buf)		/* Test for a semaphore. */
#define S_TYPEISSHM(buf)		/* Test for a shared memory object. */


/* The stat structure. */
struct stat{
	dev_t     st_dev;		/* Device ID of device containing file. */
	ino_t     st_ino;		/* File serial number. */
	mode_t    st_mode;		/* Mode of file. */
	nlink_t   st_nlink;		/* Number of hard links to the file. */
	uid_t     st_uid;		/* User ID of file. */
	gid_t     st_gid;		/* Group ID of file. */
	off_t     st_size;		/* For regular files, the file size in bytes. */
	time_t    st_atime;		/* Time of last access. */
	time_t    st_mtime;		/* Time of last data modification. */
	time_t    st_ctime;		/* Time of last status change. */
};


/* functions and may also be defined as macros. */
int    mkdir(const char*, mode_t);

/* 未実装 */
int    chmod(const char*, mode_t);
int    fchmod(int, mode_t);
int    fstat(int, struct stat*);
int    lstat(const char*, struct stat*);
int    mkfifo(const char*, mode_t);
int    stat(const char*, struct stat*);
mode_t umask(mode_t);


#endif
