/*
 * interrupt.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include"lib.h"
#include"proc.h"
#include"segment.h"
#include"interrupt.h"
#include"mp.h"
#include"fs.h"
#include"time.h"
#include"mm.h"
#include"device.h"
#include"signal.h"
#include"test.h"


enum{IDT_ENTRY=256};		/* Interrupt descriptorȥ꡼ */


DESCRIPTOR idt[IDT_ENTRY];		/* IDT */
DTR idtr={IDT_ENTRY*8-1,idt};	/* IDT Reg */

/* System calls entry table. */
SYSCALL syscall_table[SYS_ENTRYS];


static int temp();


/*
 * ߥϥɥơ֥
 * returns : task switch on 1,off 0
 */
int (*irq_entry[IRQ_ENTRY])()={
	temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp,temp
};

/*
 * ϡɳѣţϣɴؿ
 * parameters : IRQ number
 */
void (*irq_eoi)(uchar);

/*
 * Release hard interrupt mask
 * parameters : IRQ number
 */
void (*release_irq_mask)(uchar);

/*
 * Set hard interrupt mask
 * parameters : IRQ number
 */
void (*set_irq_mask)(uchar);


/*
 * IDTꤹ
 * parameters : IDT number,Hnadler address,Gate flag(IDT_INTR or IDT_TRAP)
 */
void set_idt(int num,void *func,int flag)
{
	idt[num].low=((uint)func&0xffff)|(KERNEL_CODE_DES<<16);
	idt[num].high=0x8000|((uint)func&0xffff0000)|flag;
}


/*
 * Set call gate discriptor
 * parameters : Value of discritor,Offset,Parameter count
 */
void set_gate(int des,void *addr,uchar para_num)
{
	gdt[des/8].low=((uint)addr&0xffff)|(KERNEL_CODE_DES<<16);
	gdt[des/8].high=((uint)addr&0xffff0000)|0xec00|para_num;
}


/*
 * Init system call
 */
int init_syscall()
{
	syscall_table[SYS_OPEN]=sys_open;
	syscall_table[SYS_READ]=sys_read;
	syscall_table[SYS_WRITE]=sys_write;
	syscall_table[SYS_CLOSE]=sys_close;
	syscall_table[SYS_LSEEK]=sys_lseek;
	syscall_table[SYS_MKDIR]=sys_mkdir;
	syscall_table[SYS_CREAT]=sys_creat;
	syscall_table[SYS_RENAME]=sys_rename;
	syscall_table[SYS_UNLINK]=sys_unlink;
	syscall_table[SYS_RMDIR]=sys_rmdir;
	syscall_table[SYS_OPENDIR]=sys_opendir;
	syscall_table[SYS_CLOSEDIR]=sys_closedir;
	syscall_table[SYS_READDIR]=sys_readdir;
	syscall_table[SYS_LOCK]=sys_lock;
	syscall_table[SYS_MOUNT]=sys_mount;
	syscall_table[SYS_UMOUNT]=sys_umount;
	syscall_table[SYS_FORK]=sys_fork;
	syscall_table[SYS_EXEC]=sys_exec;
	syscall_table[SYS_EXIT]=sys_exit;
	syscall_table[SYS_SLEEP]=NULL;
	syscall_table[SYS_TIME]=sys_time;
	syscall_table[SYS_SYNC]=sys_sync;
	syscall_table[SYS_SIGACTION]=sys_sigaction;
	syscall_table[SYS_SIGPROCMASK]=sys_sigprocmask;
	syscall_table[SYS_SIGPENDING]=sys_sigpending;
	syscall_table[SYS_SIGSUSPEND]=sys_sigsuspend;
	syscall_table[SYS_BRK]=sys_brk;
/*************************************************/
	syscall_table[TEST_EXT2]=test_ext2;
/*************************************************/

	set_gate(GATE_DES,syscall1,1);
	set_gate(GATE_DES+8,syscall2,2);
	set_gate(GATE_DES+16,syscall3,3);
	set_gate(GATE_DES+24,syscall4,4);

	return 0;
}

int temp()
{
	return 0;
}
