/*
 * apm.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef apm_h
#define apm_h


/* BIOS call. */
#define APM_BIOS 0x15
#define APM_FUNC 0x53
#define APM_FUNC_CHCK 0x00		/* APM Installation Check. */
#define APM_FUNC_32MODE 0x03	/* APM Protected Mode Connect 32 bit. */
#define APM_FUNC_DSCNCT 0x04	/* APM Interface Disconnect. */
#define APM_FUNC_CPUIDL 0x05	/* CPU Idle. */
#define APM_FUNC_CPUBSY 0x06	/* CPU Busy. */
#define APM_FUNC_SETPWR 0x07	/* Set Power State. */
#define APM_FUNC_PWRMNG 0x08	/* Enable/Disable Power Management. */
#define APM_FUNC_PWRDEF 0x09	/* Restore Power on Defaults. */
#define APM_FUNC_GETSTU 0x0a	/* Get Power Status. */
#define APM_FUNC_GETPM 0x0b		/* Get PM Event. */
#define APM_FUNC_GETSTA 0x0c	/* Get Power State. */
#define APM_FUNC_DEVPWR 0x0d	/* Enable/Disable Device Power Management. */
#define APM_FUNC_DRVVRS 0x0e	/* APM Driver Version. */
#define APM_FUNC_ENGPWR 0x0f	/* Engage/Disengage Power Management. */
#define APM_FUNC_GETCPB 0x10	/* Get Capabilities. */
#define APM_FUNC_RSMTIM 0x11	/* Get/Set/Disable Resume Timer. */
#define APM_FUNC_RSMRNG 0x12	/* Enable/Disable Resume on Ring Indicator. */
#define APM_FUNC_TIMRQS 0x13	/* Enable/Disable Timer Based Requests. */
#define APM_FUNC_OEMFNC 0x80	/* OEM APM Function. */

/* APM device ID. */
#define APM_DEV_APMBIOS 0x0000
#define APM_DEV_ALLDEV 0x0001

/* APM flags. */
#define APM_FLG_32MODE 0x2


#ifndef ASM_FILE


enum{
	/* Errpr coad. */
	APM_ERR_NOTPRESEN=0x86,		/* APM not present. */

	/* Power state flag. */
	APM_PWRFLG_ENABL=0x0,	/* APM Enabled. */
	APM_PWRFLG_STANDBY=0x1,	/* Standby. */
	APM_PWRFLG_SUSPEND=0x2,	/* Suspend. */
	APM_PWRFLG_OFF=0x3,		/* Off. */
};


extern int getApmDriverVersion();
extern int setPowerState(int);
extern void InitApm();


#endif


#endif
