/*
 * interrupt.S
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ߥ֥롼
 */


#define ASM_FILE


#include"interrupt.h"
#include"segment.h"
#include"mm.h"


/****************************************************************************
 *
 * ޥ
 *
 ****************************************************************************/

/*
 * ƥȥ
 * ƥȥ֤ѹϡproc.cset_context()˱ƶ롣
 */
.macro SAVE
	pushal
	pushl	%es
	pushl	%ds
/*	pushl	%fs
	pushl	%gs*/

	subl	$FPU_SAVE_SIZE,%esp
	fnsave	(%esp)				/* FPUƥȥ֡ */
.endm

/*
 * ƥȥꥹȥ
 */
.macro RESTORE
	frstor	(%esp)				/* FPUƥȥꥹȥ */
	addl	$FPU_SAVE_SIZE,%esp

/*	popl	%gs
	popl	%fs*/
	popl	%ds
	popl	%es
	popal
	iret
.endm

/*
 * 顼ɤꥳƥȥꥹȥ
 */
.macro RESTORE_ERR
	frstor	(%esp)				/* FPUƥȥꥹȥ */
	addl	$FPU_SAVE_SIZE,%esp

/*	popl	%gs
	popl	%fs*/
	popl	%ds
	popl	%es
	popal
	addl	$4,%esp
	iret
.endm

/*
 * å
 *  åϥɥ쥹֤Ѥޤǳߤػߤ롣å
 *åߤȡȥȥɥ쥹֤԰פ롣
 * eax˥ڡǥ쥯ȥ꤬롣
 */
.macro SWITCH
	pushl	$0				/* γ߻espͤ¸ */
	pushl	%esp			/* espͤ͡ϼΥesp¸ɥ쥹 */
	cli						/* ɥ쥹֤Ѥޤǳߤػߤ롣*/
	call	switch_task
	popl	%edx			/* ƥȤ֤줿åΥȥåesp */
	movl	(%edx),%esp
	movl	%eax,%cr3		/* ΥΥڡǥ쥯ȥ */
	sti
	popl	%eax			/* γ߻esp */
	movl	%eax,(%edx)
.endm

/*
 * 㳰顼ɤʤ
 */
.macro EXCEPT handler
	pushl	$0
	SAVE
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%es
	movl	%eax,%ds
	cld
	call	\handler

	call	doSignalFromExcept		/* Handle signal. */

	RESTORE_ERR
.endm

/*
 * 㳰顼ɤꡣ
 */
.macro EXCEPT_ERR handler
	SAVE
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%es
	movl	%eax,%ds
	cld
	call	\handler

	call	doSignalFromExcept		/* Handle signal. */

	RESTORE_ERR
.endm

/*
 * 
 */
.macro TRAP irq,handler
	SAVE
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%es
	movl	%eax,%ds
	cld
	call	*irq_entry+\handler*4

	call	doSignalFromTrap		/* Handle signal. */

	pushl	$\irq
	cli
	call	*irq_eoi
	addl	$4,%esp
	RESTORE
.endm

/*
 * å
 */
.macro TRAP_SWITCH irq,handler
	SAVE
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%es
	movl	%eax,%ds
	cld
	call	*irq_entry+\handler*4
	movl	%eax,%esi

	call	doSignalFromTrap		/* Handle signal. */

	orl		%esi,%esi
	jz		1f
	SWITCH

1:	pushl	$\irq
	cli
	call	*irq_eoi
	addl	$4,%esp
	RESTORE
.endm


.text

/********************************************************/
str:
	.string	"value=%x\n"
/*********************************************************/
/*******************************************************
	pushl	%ecx
	pushl	$str
	call	printk
	addl	$8,%esp
*******************************************************/

/****************************************************************************
 *
 * 
 *
 ****************************************************************************/

/*
 * 㳰
 */
.globl except0
except0:
	EXCEPT excDivideError

.globl except1
except1:
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%ds
	movl	%eax,%es
	call	debug

.globl except2
except2:
	EXCEPT excNonmaskableInterrupt

.globl except3
except3:
	EXCEPT excBreakpoint

.globl except4
except4:
	EXCEPT excOverflow

.globl except5
except5:
	EXCEPT excBoundsCheck

.globl except6
except6:
	EXCEPT excInvalidOpcode

.globl except7
except7:
	EXCEPT excCoprocessorNotAvailable

.globl except8
except8:
	EXCEPT_ERR excDoubleFault

.globl except9
except9:
	EXCEPT excCopressorOverrun

.globl except10
except10:
	EXCEPT_ERR excInvalidTss

.globl except11
except11:
	EXCEPT_ERR excSegmentNotPresent

.globl except12
except12:
	EXCEPT_ERR excStackException

.globl except13
except13:
	EXCEPT_ERR excGeneralProtection

.globl except14
except14:
	SAVE
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%es
	movl	%eax,%ds
	cld
	movl	%cr2,%edx	/* եɥ쥹 */
	pushl	%edx
	sti
	call	pageFault
	addl	$4,%esp

	call	doSignalFromExcept		/* Handle signal. */

	RESTORE_ERR

.globl except15
except15:
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%ds
	movl	%eax,%es
	pushl	$0
	pushl	$15
	call	tmp_except

.globl except16
except16:
	EXCEPT excFpuError

.globl except17
except17:
	EXCEPT_ERR excAlignmentCheck

.globl except18
except18:
	EXCEPT excMachineCheck

.globl except19
except19:
	EXCEPT excSimdFpuError


/*
 * ϡɥ
 */
.globl apictimer
apictimer:
	TRAP_SWITCH 0,APIC_TIMER

.globl irq0
irq0:
	TRAP_SWITCH 0,IRQ0

.globl irq1
irq1:
	TRAP_SWITCH 1,IRQ1

.globl irq3
irq3:
	TRAP_SWITCH 3,IRQ3

.globl irq4
irq4:
	TRAP_SWITCH 4,IRQ4

.globl irq5
irq5:
	TRAP 5,IRQ5

.globl irq6
irq6:
	TRAP_SWITCH 6,IRQ6

.globl irq7
irq7:
	TRAP 7,IRQ7

.globl irq8
irq8:
	TRAP 8,IRQ8

.globl irq9
irq9:
	TRAP 9,IRQ9

.globl irq10
irq10:
	TRAP 10,IRQ10

.globl irq11
irq11:
	TRAP 11,IRQ11

.globl irq12
irq12:
	TRAP 12,IRQ12

.globl irq13
irq13:
	TRAP 13,IRQ13

.globl irq14
irq14:
	TRAP_SWITCH 14,IRQ14

.globl irq15
irq15:
	TRAP_SWITCH 15,IRQ15

.globl flash_pagedir
flash_pagedir:
	TRAP 0,FLASH_PAGEDIR


/****************************************************************************
 *
 * ƥॳ
 *
 ****************************************************************************/

.globl syscall1
syscall1:
	pushl	%ds
	pushl	%es
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%ds
	movl	%eax,%es
	cld
	movl	16(%esp),%eax
	call	*syscall_table(,%eax,4)
	popl	%es
	popl	%ds
	lret	$4*1

.globl syscall2
syscall2:
	pushl	%ds
	pushl	%es
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%ds
	movl	%eax,%es
	cld
	movl	16(%esp),%eax
	movl	20(%esp),%edx
	pushl	%edx
	call	*syscall_table(,%eax,4)
	addl	$4*1,%esp
	popl	%es
	popl	%ds
	lret	$4*2

.globl syscall3
syscall3:
	pushl	%ds
	pushl	%es
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%ds
	movl	%eax,%es
	cld
	movl	16(%esp),%eax
	movl	24(%esp),%edx
	pushl	%edx
	movl	24(%esp),%ecx
	pushl	%ecx
	call	*syscall_table(,%eax,4)
	addl	$4*2,%esp
	popl	%es
	popl	%ds
	lret	$4*3


.globl syscall4
syscall4:
	pushl	%ds
	pushl	%es
	movl	$KERNEL_DATA_DES,%eax
	movl	%eax,%ds
	movl	%eax,%es
	cld
	movl	16(%esp),%eax
	movl	28(%esp),%edx
	pushl	%edx
	movl	28(%esp),%ecx
	pushl	%ecx
	movl	28(%esp),%edx
	pushl	%edx
	call	*syscall_table(,%eax,4)
	addl	$4*3,%esp	
	popl	%es
	popl	%ds
	lret	$4*4


/****************************************************************************
 *
 * ץؿ
 *
 ****************************************************************************/

/*
 * void wait_task()
 */
.globl wait_task
wait_task:
	popl	%eax			/* Ƥӽиeip */
	pushfl
	pushl	$KERNEL_CODE_DES
	pushl	%eax
	SAVE
	SWITCH
	RESTORE


/*
 * sys_exitؿ
 * Υ˥åͥڡȥڡǥ쥯ȥ롣
 * void returnExit(uint *)
 * parameters : ڡǥ쥯ȥ
 */
.globl returnExit
returnExit:
	movl	4(%esp),%ebp	/* memory struct address. */
	
	pushl	$0				/* γ߻espͤ¸ */
	pushl	%esp			/* espͤ͡ϼΥesp¸ɥ쥹 */
	call	switch_task
	popl	%edx			/* ƥȤ֤줿åΥȥåesp */
	movl	(%edx),%esp
	movl	%eax,%cr3		/* ΥΥڡǥ쥯ȥ */
	popl	%eax			/* γ߻esp */
	movl	%eax,(%edx)

	pushl	%ebp
	call	releasePageDir
	cli
	addl	$4,%esp
	RESTORE


/*
 * uint setContext(uint);
 * forkλҥץΥƥȤۤ롣
 * ҥץϤδؿ꤫鳫Ϥ롣
 * ƥȤϡinterrupt.SΥƥ¸ɤ˰¸롣
 * parameters : ҥץΥåʪɥ쥹
 * return : ҥץΥå,ҥץ0
 */
.globl setContext
setContext:
	/* ƥåҥåإԡ */
	movl	%esp,%edx
	addl	$4,%edx
	movl	%edx,%ecx
	movl	$KERNEL_ESP_BEG,%eax
	subl	%edx,%eax
	pushl	%eax				/* memcpy()Υ */
	pushl	%ecx				/* memcpy()ΥХåե */
	movl	(%ecx),%edx
	addl	$0x1000,%edx
	subl	%eax,%edx
	pushl	%edx				/* memcpy()Υǥƥ͡Хåե */
	call	memcpy				/* memcpy() */
	addl	$12,%esp

	/* espҥץΥåꡣ */
	movl	%esp,%edx
	addl	$4,%esp
	andl	$0xfff,%esp
	orl		4(%edx),%esp

	/* ƥȤꡣ */
	pushfl
	pushl	%cs
	pushl	(%edx)
	xorl	%eax,%eax			/* ҥץ=0 */
	SAVE
	pushl	$0					/* before_esp */

	/* ҥץϥåͤꡣ */
	movl	4(%edx),%eax
	andl	$~0xfff,%eax
	andl	$0xfff,%esp
	orl		%esp,%eax
	movl	%edx,%esp

	ret


/****************************************************************************
 *
 * 桼⡼ɥʥϥɥ¹
 *
 ****************************************************************************/

/*
 * void doUserHandler(int signal,uint handler,uint user_esp,uint *esp,uint *kentry);
 *                        36          40           44             48        52
 * ͥ⡼ɤ桼⡼ɥϥɥ顼ذܹԤ롣
 * return : 0 or error=-1
 */
.globl doUserHandler
doUserHandler:
	pushal
	movl	40(%esp),%ebp		/* handler */									/* ebp */
	movl	48(%esp),%eax		/* *esp */
	movl	%esp,(%eax)			/* ͥ륹åݥ󥿤¸ */

	/* ͥ륹åȥ꡼ͤ롣 */
	call	getKernelStackEntry
	movl	%eax,%esi			/* kernel stack page entry address. */			/* esi */
	movl	52(%esp),%eax		/* *kentry */
	movl	(%esi),%edx
	movl	%edx,(%eax)			/* ͥ륹åڡȥ꡼¸ */

	/* 桼åꤹ롣 */
	movl	44(%esp),%eax		/* user_esp */
	movl	36(%esp),%edx		/* signal */
	movl	%edx,-4(%eax)
	movl	$returnUserHandler,-8(%eax)		/* return function address. */
	subl	$8,%eax
	movl	%eax,%edi			/* user esp */									/* edi */

	/* ͥ륹åȥ꡼촹롣 */
	pushl	$PAGE_SIZE
	call	kmalloc
	addl	$4,%esp
	cmpl	$0,%eax				/* physical memory for kernel page. */
	jne		1f
	popal
	ret
1:	movl	(%esi),%edx
	andl	$(PAGE_SIZE-1),%edx
	orl		%eax,%edx
	movl	%edx,(%esi)

	/* ڡι */
	call	getPageDir
	movl	%eax,%cr3

	/* å˥ƥȤꡣ */
	pushl	$USER_DATA_DES		/* user ss. */
	pushl	%edi				/* user esp. */
	pushl	$USER_CODE_DES		/* user cs. */
	pushl	%ebp				/* handler point. */
	movl	$USER_DATA_DES,%eax
	movl	%eax,%ds
	movl	%eax,%es
	lret


/*
 * void returnUserHandler();
 * 桼⡼ɥϥɥ顼
 */
.globl returnUserHandler
returnUserHandler:
	/* espͤ롣 */
	call	getBeforeEsp
	movl	%eax,%ebp			/* before esp. */							/* ebp */

	/* ͥ륹åȥ꡼촹롣 */
	call	getBeforeStackEntry
	movl	%eax,%edx			/* Υͥ륹åڡȥ꡼ */
	call	getKernelStackEntry
	movl	(%eax),%edi			/* ͥ륹åڡȥ꡼ */		/* edi */
	movl	%edx,(%eax)

	/* ѹƤͥ륹å꡼γ */
	pushl	%edi
	call	kfree

	/* ڡι */
	call	getPageDir
	movl	%eax,%cr3

	/* esp᤹ͤ */
	movl	%ebp,%esp

	popal
	ret
