/*
 * segmnet.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include"types.h"
#include"segment.h"


/* GDT */
DESCRIPTOR gdt[GDT_ENTRY]=
{
	{0,0},
	{0x0000ffff,0x00cf9a00},	/* ͥ륳ɥ */
	{0x0000ffff,0x00cf9200},	/* ͥǡ */
	{0x0000ffff,0x00cffa00},	/* 桼ɥ */
	{0x0000ffff,0x00cff200},	/* 桼ǡ */
	{0,0}
};


/*
 * GLOBAL
 * ǥץ˥ɥ쥹ꤹ롣
 * ߥåȥ-1Τǡͤ0Ȥʤ롣
 *  : ǥץ͡١ɥ쥹ߥåȥץե饰
 */
void set_gdt(int des,uint addr,uint size,int flag)
{
	gdt[des/8].low=0;
	gdt[des/8].high=0;
	
	size-=1;

	/* ١ɥ쥹 */
	gdt[des/8].low|=addr<<16;
	gdt[des/8].high|=(addr>>16)&0xff;
	gdt[des/8].high|=addr&0xff000000;

	/* ߥåȥ */
	if(flag&0x100000)size>>=12;
	gdt[des/8].low|=size&0xffff;
	gdt[des/8].high|=size&0xf0000;

	/* ץե饰 */
	gdt[des/8].high|=flag;
}
