/*
 * stdio.h
 */


#ifndef stdio_h
#define stdio_h


#include<unistd.h>
#include<stddef.h>
#include<stdarg.h>


enum{
	BUFSIZ,				/* Size of <stdio.h> buffers. */
	_IOFBF,				/* Input/output fully buffered. */
	_IOLBF,				/* Input/output line buffered. */
	_IONBF,				/* Input/output unbuffered. */
	L_tmpnam,			/* Maximum size of character array to hold tmpnam() output. */
	
	FILENAME_MAX=_PC_NAME_MAX,	/* Maximum size in bytes of the longest filename string. */
	FOPEN_MAX,			/* Number of streams.The value is at least eight. */
	TMP_MAX,			/* Minimum number of unique filenames generated by tmpnam().
						   Maximum number of times an application can call tmpnam() reliably.
						   The value of {TMP_MAX} is at least 25. */

	EOF=-1,				/* End-of-file return value. */

	stdin=STDIN_FILENO,
	stdout=STDOUT_FILENO,
	stderr=STDERR_FILENO,
};


/* File stream structure. */
typedef struct{

}FILE;

typedef unsigned int fpos_t;


/* Function declarations. */
extern int      printf(const char *, ...);
extern int      rename(const char *, const char *);

/* ̤ */
extern void     clearerr(FILE *);
extern int      fclose(FILE *);
extern int      feof(FILE *);
extern int      ferror(FILE *);
extern int      fflush(FILE *);
extern int      fgetc(FILE *);
extern int      fgetpos(FILE *, fpos_t *);
extern char    *fgets(char *, int, FILE *);
extern FILE    *fopen(const char *, const char *);
extern int      fprintf(FILE *, const char *, ...);
extern int      fputc(int, FILE *);
extern int      fputs(const char *, FILE *);
extern size_t   fread(void *, size_t, size_t, FILE *);
extern FILE    *freopen(const char *, const char *,FILE *);
extern int      fscanf(FILE *, const char *, ...);
extern int      fseek(FILE *, long, int);
extern int      fsetpos(FILE *, const fpos_t *);
extern long     ftell(FILE *);
extern size_t   fwrite(const void *, size_t, size_t, FILE *);
extern int      getc(FILE *);
extern int      getchar(void);
extern char    *gets(char *);
extern void     perror(const char *);
extern int      putc(int, FILE *);
extern int      putchar(int);
extern int      puts(const char *);
extern int      remove(const char *);
extern void     rewind(FILE *);
extern int      scanf(const char *, ...);
extern void     setbuf(FILE *, char *);
extern int      setvbuf(FILE *, char *, int, size_t);
extern int      snprintf(char *, size_t, const char *, ...);
extern int      sprintf(char *, const char *, ...);
extern int      sscanf(const char *, const char *, ...);
extern FILE    *tmpfile(void);
extern char    *tmpnam(char *);
extern int      ungetc(int, FILE *);
extern int      vfprintf(FILE *, const char *, va_list);
extern int      vfscanf(FILE *, const char *, va_list);
extern int      vprintf(const char *, va_list);
extern int      vscanf(const char *, va_list);
extern int      vsnprintf(char *, size_t, const char *, va_list);
extern int      vsprintf(char *, const char *, va_list);
extern int      vsscanf(const char *, const char *, va_list arg);


#endif
