/*
 * dirent.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<system.h>
#include<share/syscall.h>
#include<stdlib.h>
#include<errno.h>
#include<dirent.h>


enum{
	OPENDIR_MAX_OPEN=10,		/* ǥ쥯ȥꥪץ */
	DUMMY=1,					/* DIR֤ͤNULLƱˤʤ­͡ */
};


static DIR *dirTable[OPENDIR_MAX_OPEN];
static struct dirent *direntTable[OPENDIR_MAX_OPEN];
static int dirNum=0;


DIR *opendir(const char *dirname)
{
	int rest;
	DIR *dir;
	int i;


	if(dirNum>=OPENDIR_MAX_OPEN)
	{
		errno=EMFILE;
		return NULL;
	}

	if((dir=(DIR*)malloc(sizeof(DIR)))==NULL)
	{
		errno=ENOMEM;
		return NULL;
	}

	if((rest=syscall3(SYS_OPENDIR,(int)dirname,(int)dir))<0)
	{
		errno=-rest;	
		return NULL;
	}

	for(i=0;dirTable[i]!=NULL;)
		if(++i==OPENDIR_MAX_OPEN)
		{
			errno=EMFILE;
			return NULL;
		}

	if((direntTable[i]=(struct dirent*)malloc(sizeof(struct dirent)))==NULL)
	{
		errno=ENOMEM;
		free(dir);
		return NULL;
	}
	dirTable[i]=dir;
	++dirNum;

	return (DIR*)(i+DUMMY);
}


int closedir(DIR *dirp)
{
	int rest;
	int i=(int)dirp-DUMMY;


	if((i>=OPENDIR_MAX_OPEN)||(dirTable[i]==NULL))
	{
		errno=EBADF;
		return -1;
	}

	if((rest=syscall2(SYS_CLOSEDIR,(int)dirTable[i]))<0)
	{
		errno=-rest;
		return -1;
	}

	free(dirTable[i]);
	dirTable[i]=NULL;
	free(direntTable[i]);
	--dirNum;

	return 0;
}


struct dirent *readdir(DIR *dirp)
{
	int rest;
	int i=(int)dirp-DUMMY;


	if((i>=OPENDIR_MAX_OPEN)||(dirTable[i]==NULL))
	{
		errno=EBADF;
		return NULL;
	}

	if((rest=syscall3(SYS_READDIR,(int)dirTable[i],(int)direntTable[i]->d_name))<0)
	{
		errno=-rest;
		return NULL;
	}

	if(*direntTable[i]->d_name=='\0')return NULL;

	return direntTable[i];
}
