/*
 * stat.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<system.h>
#include<share/syscall.h>
#include<errno.h>
#include<sys/stat.h>


int mkdir(const char *path, mode_t mode)
{
	int rest;


	if((rest=syscall3(SYS_MKDIR,(int)path,(int)mode))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int fstat(int fildes,struct stat *buf)
{
	int rest;


	if((rest=syscall4(SYS_STAT,fildes,(int)NULL,(int)buf))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}


int stat(const char *path,struct stat *buf)
{
	int rest;


	if((rest=syscall4(SYS_STAT,0,(int)path,(int)buf))<0)
	{
		errno=-rest;
		return -1;
	}
	else return 0;
}
