/*
 * wait.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>
#include<system.h>
#include<share/syscall.h>
#include<errno.h>
#include<sys/wait.h>

pid_t wait(int *status)
{
	int rest;


	if((rest=syscall4(SYS_WAIT,-1,(int)status,0))<0)
	{
		errno=-rest;
		return -1;
	}
	else return rest;
}


pid_t waitpid(pid_t pid, int *status, int options)
{
	int rest;


	if((rest=syscall4(SYS_WAIT,pid,(int)status,options))<0)
	{
		errno=-rest;
		return -1;
	}
	else return rest;
}
