/*
 * pci.c (C) 2002 Minoru Murashima
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * PCI
 */


#include"types.h"
#include"lib.h"
#include"errno.h"
#include"pci.h"


enum{
	/* IO port */
	CONFIG_ADDR=0xcf8,
	CONFIG_DATA=0xcfc,
};


/*
 * Read pci config register
 * parameters : Bus number,Device number,Function number,Register
 * return : Read value
 */
uint read_pci_config(int bus,int dev,int func,int reg)
{
	uint value;


	/* Read IO */
	outdw(CONFIG_ADDR,(1<<31)|(bus<<16)|(dev<<11)|(func<<8)|(reg&~3));
	value=indw(CONFIG_DATA);
	outdw(CONFIG_ADDR,0);

	return value>>((reg&3)*8);
}


/*
 * Write double word value to pci config register
 * parameters : Bus number,Device number,Function number,Register,Write value
 */
void writedw_pci_config(int bus,int dev,int func,int reg,uint value)
{
	outdw(CONFIG_ADDR,(1<<31)|(bus<<16)|(dev<<11)|(func<<8)|(reg&~3));
	outdw(CONFIG_DATA+(reg&3),value);
	outdw(CONFIG_ADDR,0);
}


/*
 * Write word value to pci config register
 * parameters : Bus number,Device number,Function number,Register,Write value
 */
void writew_pci_config(int bus,int dev,int func,int reg,ushort value)
{
	outdw(CONFIG_ADDR,(1<<31)|(bus<<16)|(dev<<11)|(func<<8)|(reg&~3));
	outw(CONFIG_DATA+(reg&3),value);
	outdw(CONFIG_ADDR,0);
}


/*
 * Write byte value to pci config register
 * parameters : Bus number,Device number,Function number,Register,Write value
 */
void writeb_pci_config(int bus,int dev,int func,int reg,uchar value)
{
	outdw(CONFIG_ADDR,(1<<31)|(bus<<16)|(dev<<11)|(func<<8)|(reg&~3));
	outb(CONFIG_DATA+(reg&3),value);
	outdw(CONFIG_ADDR,0);
}


/*
 * Search PCI device from class coad.
 * Ϳ줿PCI饹ͤ鸡Ϥ롣
 * parameters : Class coad,Buffer for writing
 * return : 0 or error number
 */
int search_pci_class(int class,PCI_INFO *inf)
{
	int i,j,k;


	i=inf->bus;
	j=inf->dev;
	k=inf->func;
	for(;i<255;++i)
	{
		for(;j<32;++j)
		{
			for(;k<8;++k)
			{
				if((ushort)read_pci_config(i,j,k,PCI_CONF_VENDER)==0xffff)continue;
				if(read_pci_config(i,j,k,PCI_CONF_CLASS)==class)
				{
					inf->vidDid=read_pci_config(i,j,k,PCI_CONF_VENDER);
					inf->bus=i;
					inf->dev=j;
					inf->func=k;

					return 0;
				}
			}
			k=0;
		}
		j=0;
	}

	return -ENODEV;
}


static uint pciMem=0xfef00000;


/*
 * IO memory manager.
 * 0xfec000000xfec00040,0xfee000000xfee00400,
 * IO APIC,               LOCAL APIC
 * parameters : need size
 * return : memory address
 */
uint getPciMemAddress(int size)
{
	int addr;
	
	
	/* 0x100000Ȥ˥꡼Ƥ롣 */
	addr=pciMem;
	pciMem+=ROUNDUP(size,0x100000);
	
	return addr;
}
