/*
 * limits.h
 */


#ifndef limits_h
#define limits_h


enum{
	CHAR_BIT=sizeof(char)*8,	/* number of bits in a char. */
	CHAR_MAX=0x7f,				/* maximum value of type char. */
	CHAR_MIN=(char)0xff,		/* minimum value of type char. */
	SCHAR_MAX=CHAR_MAX,			/* maximum value of type signed char. */
	SCHAR_MIN=CHAR_MIN,			/* minimum value of type signed char. */
	UCHAR_MAX=0xff,				/* maximum value of type unsigned char. */
	SHRT_MAX=0x7fff,			/* maximum value of type short. */
	SHRT_MIN=(short)0xffff,		/* minimum value of type short. */
	USHRT_MAX=0xffff,			/* maximum value of type unsigned short. */
	INT_MAX=0x7fffffff,			/* maximum value of type int. */
	INT_MIN=(int)0xffffffff,	/* minimum value of type int. */
	UINT_MAX=(unsigned int)0xffffffff,	/* maximum value of type unsigned int. */
	LONG_MAX=INT_MAX,			/* maximum value of type long. */
	LONG_MIN=INT_MIN,			/* minimum value of type long. */
	ULONG_MAX=UINT_MAX,			/* maximum value of type unsigned long. */
};


#endif
