/*
 * stdio.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<callgate.h>
#include<share/syscall.h>
#include<string.h>
#include<stdarg.h>
#include<system.h>
#include<errno.h>
#include<fcntl.h>
#include<stdlib.h>
#include<ctype.h>
#include<stdio.h>


/**************** ǥХå ****************************
static int cnv(uint uvalue,char *buf)
{
	enum{TMP_BUF_SIZE=8};
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		buf[i]=uvalue%16+'0';
		if(buf[i]>'9')buf[i]+='a'-'9'-1;
		if(!(uvalue/=16))break;
	}
	memcpy(buf,&buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}
********************************************************/


/***************************************************************************
 *
 * ʸѴ
 *
 ***************************************************************************/

enum{
	/* ե饰ʸӥåȡ */
	FLG_FORM=   1<<0,		/* '#' */
	FLG_ZERO=   1<<1,		/* '0' */
	FLG_LEFT=   1<<2,		/* '-' */
	FLG_SPACE=  1<<3,		/* ' ' */
	FLG_PLUS=   1<<4,		/* '+' */

	/* IA32ưեޥåȡ */
	SIGN_BIT=63,		/* +-ӥåȰ֡ */
	EXP_BIT=52,			/* ؿӥåȰ֡ */
	MAX_DIGIT=20,		/* ͺ */
	EXP_BASE=0x3ff,		/* ؿ0 */

	TMP_BUF_SIZE=12,	/* ʸѴѺȥХåե */
};


/*
 * ꡼Ǹ夫饳ԡ
 * parameters : destination buffer,source buffer
 */
static inline void memcpyBack(char *dst,char *src,int n)
{
	while(--n>=0)dst[n]=src[n];
}


/*
 * 0ʸƬ롣
 * parameters : destination buffer,buffer size,fill size
 */
static inline int fillZero(char *buf,int size,int fill)
{
	memcpyBack(buf+fill,buf,size);
	memset(buf,'0',fill);

	return fill;
}


/*
 * ե
 * parameters : buffer,size,width,flag
 * return : field size
 */
static void setField(char *buf,int size,int width,int flag,int sign)
{
	int fill;


	fill=width-size-sign;
	if(flag&FLG_LEFT)memset(buf+size,' ',fill);
	else
	{
		if(flag&FLG_ZERO)
		{
			memcpyBack(buf+fill,buf,size);
			memset(buf,'0',fill);
		}
		else
		{
			buf-=sign;
			memcpyBack(buf+fill,buf,size+sign);
			memset(buf,' ',fill);
		}
	}
}


/*
 * PRIVATE
 * ưeʸѴ롣
 * parameters : ư,̳ǼʸХåե,ٷ,eʸ
 * return : Ѵʸ
 */
static int dtoe(double value,char *str_buf,int sdigit,int cnv)
{
	char tmpstr[MAX_DIGIT];
	char *buf=str_buf;
	int sign10;
	int exp,exp10;
	unsigned long long *vl=(unsigned long long*)&value;
	unsigned long long tmp,log10;
	int i;


	exp=(*vl>>EXP_BIT)&0x7ff;		/* ؿ͡ */

	*vl&=~((long long)1<<SIGN_BIT);		/* clear sign bit. */

	/* 10Ȥؿͤ׻ */
	if(exp<EXP_BASE)
	{
		tmp=(unsigned long long)2<<(EXP_BASE-exp);
		log10=10;
		for(i=0;(tmp/=10)!=0;++i)log10*=10;
		value*=log10;
		sign10='-';
		if(value<10)
		{
			exp10=i+1;
			log10=10;
		}
		else
		{
			exp10=i;
			log10=1;
		}
	}
	else
	{
		tmp=(unsigned long long)2<<(exp-EXP_BASE);
		log10=1;
		for(i=0;(tmp/=10)>=10;++i)log10*=10;
		value/=log10;
		sign10='+';
		if(value<10)
		{
			exp10=i;
			log10=10;
		}
		else
		{
			exp10=i+1;
			log10=1;
		}
	}

	/* ͤ׻ */
	for(i=0;i<sdigit;++i)log10*=10;		/* +sdigitʬ10**sdigit */
	value*=(double)log10;
	tmp=(long long)value;
	tmp+=5;								/* ͼθ */

	/* 10ʸѴ */
	i=0;
	do
	{
		tmpstr[i++]=tmp%10+'0';
	}while((tmp/=10)!=0);
	*buf++=tmpstr[--i];
	*buf++='.';
	while(--i>0)*buf++=tmpstr[i];
	*buf++=cnv;
	*buf++=sign10;
	*buf++=exp10/10+'0';
	*buf++=exp10%10+'0';

	return (int)buf-(int)str_buf;
}


/*
 * PRIVATE
 * ưfʸѴ롣
 * parameters : ư,̳ǼʸХåե,
 * return : Ѵʸ
 */
static int dtof(double value,char *str_buf,int sdigit)
{
	char tmpstr[MAX_DIGIT];
	char *buf=str_buf;
	int exp;
	unsigned long long *vl=(unsigned long long*)&value;
	unsigned long long integer,log10;
	int i;


	exp=(*vl>>EXP_BIT)&0x7ff;		/* ؿ͡ */

	*vl&=~((long long)1<<SIGN_BIT);		/* clear sign bit. */

	/* 10**(sdigit+1) */
	log10=10;
	for(i=0;i<sdigit;++i)log10*=10;
	value*=log10;
	integer=(long long)value;
	integer=(integer+5)/10;							/* ͼθ */

	/* 10ʸѴ */
	i=0;
	do
	{
		tmpstr[i++]=integer%10+'0';
	}while((integer/=10)!=0);

	if(i<=sdigit)
	{
		*buf++='0';
		*buf++='.';
		memset(buf,'0',sdigit-1);
		buf+=sdigit-1;
		while(--i>=0)buf[-i]=tmpstr[i];
		++buf;
	}
	else
	{
		while(--i>=0)
		{
			*buf++=tmpstr[i];
			if(i<=sdigit)
			{
				*buf++='.';
				break;
			}
		}
		while(--i>=0)*buf++=tmpstr[i];
	}

	return (int)buf-(int)str_buf;
}


/*
 * 10ʿʸѴХåեθƤ
 * parameters : string,buffer,buffer size,flag
 * return : string length
 */
static inline int iToDecimal(int value,char *buf)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%10+'0';
		if(!(value/=10))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * 16ʿʸѴ
 * parameters : string,buffer,buffer size,ʸ'X' or 'x'
 * return : string length
 */
static inline int uToHexa(uint value,char *buf,int c)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	c=c-('x'-'a');
	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%16+'0';
		if(tmp_buf[i]>'9')tmp_buf[i]+=c-'9'-1;
		if(!(value/=16))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * 8ʿʸѴХåեθƤ
 * parameters : string,buffer
 * return : string length
 */
static inline int uToOctal(uint value,char *buf)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%8+'0';
		if(!(value/=8))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * ʸѴƥХåե¸롣
 * return : converted string size
 */
static int formatToString(const char *str,char *buf,uint *org_arg)
{
	enum{
		/* Ĺե饰 */
		LENG_H=1,
		LENG_L,
		LENG_DL,
	};

	int flag,width,prec,leng;
	int ivalue,size,sign;
	uint *arg;
	uint uvalue;
	double *dvalue;
	int i;


	arg=org_arg;

	for(i=0;*str!='\0';++str)
	{
		if(*str=='%')
		{
			flag=width=leng=0;
			prec=-1;

			/* ե饰ʸ */
			for(;;)
				switch(*++str)
				{
					case '#':
						flag|=FLG_FORM;
						break;
					case '0':
						flag|=FLG_ZERO;
						break;
					case '-':
						flag|=FLG_LEFT;
						flag&=~FLG_ZERO;
						break;
					case ' ':
						flag|=FLG_SPACE;
						break;
					case '+':
						flag|=FLG_PLUS;
						flag&=~FLG_SPACE;
						break;
					default:
						goto EXIT_FLAG;
				}
EXIT_FLAG:
			/* ե */
			for(;isdigit(*str);++str)
			{
				width*=10;
				width+=*str-'0';
			}

			/* ١ */
			if(*str=='.')
			{
				if(isdigit(*(str+1)))
				{
					++str;
					prec=0;
					do
					{
						prec*=10;
						prec+=*str-'0';
					}while(isdigit(*++str));
				}
				else if(*(str+1)=='*')
				{
					int l;
					const char *s;

					s=(str+=2);
					if(isdigit(*s))
					{
						l=0;
						do
						{
							l*=10;
							l+=*s-'0';
						}while(isdigit(*++s));
						if(*s=='$')
						{
							prec=*(org_arg+l-1);
							str=s+1;
						}
						else prec=*arg++;
					}
					else prec=*arg++;
				}
			}

			/* Ĺʸ */
			switch(*str)
			{
				case 'h':
					leng=LENG_H;
					++str;
					break;
				case 'l':
				case 'L':
					/* ʤˤ⤷ʤ */
					++str;
			}

			/* Ѵʸ */
			switch(*str)
			{
				case 'd':
				case 'i':
					/* Ĺ */
					if(leng==LENG_H)(short)ivalue=*arg++;
					else ivalue=*arg++;

					/* ν */
					sign=1;
					if(ivalue<0)
					{
						buf[i++]='-';
						ivalue*=-1;
					}
					else if(flag&FLG_PLUS)buf[i++]='+';
					else if(flag&FLG_SPACE)buf[i++]=' ';
					else sign=0;
					size=iToDecimal(ivalue,&buf[i]);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~FLG_ZERO;	/* 0ե饰٤ͥ衣 */
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'x':
				case 'X':
					/* Ĺ */
					if(leng==LENG_H)(ushort)uvalue=*arg++;
					else uvalue=*arg++;

					/*  */
					if(flag&FLG_FORM)
					{
						buf[i++]='0';
						buf[i++]=*str;
						sign=2;
					}
					else sign=0;
					size=uToHexa(uvalue,&buf[i],*str);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~FLG_ZERO;
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 's':
					if(prec>=0)size=prec;
					else size=strlen((char*)*arg);
					memcpy(&buf[i],(void*)*arg,size);
					++arg;
					if((width>size)&&(flag&FLG_LEFT))
					{
						memset(&buf[i+size],' ',width-size);
						i+=width;
					}
					i+=size;
					break;
				case 'c':
					buf[i]=*arg++;
					if(width>1)
					{
						flag&=~FLG_ZERO;
						setField(&buf[i],1,width,flag,0);
						i+=width;
					}
					else i+=1;
					break;
				case 'u':
					/* Ĺ */
					if(leng==LENG_H)(ushort)uvalue=*arg++;

					size=iToDecimal(*arg++,&buf[i]);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~FLG_ZERO;
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size)
					{
						setField(&buf[i],size,width,flag,0);
						i+=width;
					}
					else i+=size;
					break;
				case 'o':
					/* Ĺ */
					if(leng==LENG_H)(ushort)uvalue=*arg++;

					/*  */
					if(flag&FLG_FORM)
					{
						buf[i++]='0';
						sign=1;
					}
					else sign=0;
					size=uToOctal(*arg++,&buf[i]);

					/* ٤ν */
					if(prec>0)
					{
						flag&=~FLG_ZERO;
						if(prec>size)
							size+=fillZero(&buf[i],size,prec-size);
					}

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'f':
					dvalue=(double*)arg;
					arg+=2;

					/* ν */
					sign=1;
					if(*dvalue<0)
					{
						buf[i++]='-';
						*dvalue*=-1;
					}
					else if(flag&FLG_PLUS)buf[i++]='+';
					else if(flag&FLG_SPACE)buf[i++]=' ';
					else sign=0;

					/* ٤ν */
					if(prec==-1)prec=6;

					size=dtof(*dvalue,&buf[i],prec);

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
				case 'e':
				case 'E':
					dvalue=(double*)arg;
					arg+=2;

					/* ν */
					sign=1;
					if(*dvalue<0)
					{
						buf[i++]='-';
						*dvalue*=-1;
					}
					else if(flag&FLG_PLUS)buf[i++]='+';
					else if(flag&FLG_SPACE)buf[i++]=' ';
					else sign=0;

					/* ٤ν */
					if(prec==-1)prec=6;

					size=dtoe(*dvalue,&buf[i],prec,*str);

					/* եν */
					if(width>size+sign)
					{
						setField(&buf[i],size,width,flag,sign);
						i+=width-sign;
					}
					else i+=size;
					break;
		/*		case 'g':
				case 'G':
				case 'p':
				case 'n':*/
				case '%':
					buf[i++]='%';
					break;
				default:
					buf[i++]=*str;
			}
		}
		else buf[i++]=*str;
	}

	buf[i]='\0';

	return i;
}


/***************************************************************************
 *
 * ʸ󤫤Ѵ
 *
 ***************************************************************************/

/*
 * 8ʸ
 */
static inline int isoctal(int c)
{
	return (c>='0')&&(c<='7');
}

/*
 * 10ʸ󤫤Ѵ
 * parameters : string
 * return : ɹߥ 0ʤ饨顼
 */
static inline int aToInt(const char *str,int *value)
{
	int sign;
	int rest;
	int i;


	sign=1;
	i=0;

	/* γǧ */
	if(str[i]=='+')++i;
	else if(str[i]=='-')
	{
		sign=-1;
		++i;
	}

	if(isdigit(str[i]))
	{
		rest=0;
		for(;str[i]=='0';++i);	/* Ƭ0 */
		for(;isdigit(str[i]);++i)
		{
			rest*=10;
			rest+=str[i]-'0';
		}
		*value=rest*sign;
	}
	else return 0;

	return i;
}


/*
 * 16ʸ󤫤Ѵ
 * parameters : string
 * return : ɹߥ 0ʤ饨顼
 */
static inline int hexToUint(const char *str,uint *value)
{
	uint rest;
	int i;


	i=0;
	if((str[i++]!='0')||((str[i]!='x')&&(str[i]!='X')))
		return 0;

	if(isxdigit(str[++i]))
	{
		rest=0;
		for(;str[i]=='0';++i);	/* Ƭ0 */
		for(;isxdigit(str[i]);++i)
		{
			rest*=16;
			if(str[i]<='9')rest+=str[i]-'0';
			else if(str[i]<='F')rest+=str[i]-'A'+10;
			else rest+=str[i]-'a'+10;
		}
		*value=rest;
	}
	else return 0;

	return i;
}


/*
 * 8ʸ󤫤Ѵ
 * parameters : string
 * return : ɹߥ 0ʤ饨顼
 */
static inline int octToUint(const char *str,uint *value)
{
	uint rest;
	int i;


	i=0;
	if(isoctal(str[i]))
	{
		rest=0;
		for(;str[i]=='0';++i);	/* Ƭ0 */
		for(;isoctal(str[i]);++i)
		{
			rest*=8;
			rest+=str[i]-'0';
		}
		*value=rest;
	}
	else return 0;

	return i;
}


/*
 * ʸ󤫤ѴưΥݥ󥿤롣
 * return : converte count
 */
static int formatFromString(char *str,const char *fmt,uint **arg)
{
	int count;
	int len;


	count=0;
	for(;*fmt!='0';++fmt)
	{
		if(*fmt=='%')
			switch(*++fmt)
			{
				case 'd':
					if((len=aToInt(str,(int*)*arg++))==0)return count;
					str+=len;
					++count;
					break;
				case 'x':
				case 'X':
					if((len=hexToUint(str,*arg++))==0)return count;
					str+=len;
					++count;
					break;
				case 'o':
					if((len=octToUint(str,*arg++))==0)return count;
					str+=len;
					++count;
					break;
				case '%':
					if(*fmt!=*str++)return count;
			}
		else if(*fmt!=*str++)break;
	}

	return count;
}


/***************************************************************************
 *
 * ե륹ȥ꡼
 *
 ***************************************************************************/

enum{
	F_FLAG_EOF=1<<0,	/* File sterm EOF flag. */
	F_FLAG_ERR=1<<1,	/* File sterm error flag. */
};


FILE _stdin= {0,0,0,0,NULL};
FILE _stdout={1,0,0,0,NULL};
FILE _stderr={2,0,0,0,NULL};
FILE *stdin	=&_stdin;
FILE *stdout=&_stdout;
FILE *strerr=&_stderr;


FILE *fopen(const char *filename,const char* mode)
{
	int fd;
	int aflg,oflg;
	FILE *fl;


	switch(*mode)
	{
		case 'r':
			aflg=O_RDONLY;
			oflg=0;
			break;
		case 'w':
			aflg=O_WRONLY;
			oflg=O_CREAT|O_TRUNC;
			break;
		case 'a':
			aflg=O_WRONLY;
			oflg=O_CREAT|O_APPEND;
			break;
		default:
			errno = EINVAL;
			return NULL;
	}
	if ((*++mode=='+')||((*mode=='b')&&(mode[1]=='+')))aflg=O_RDWR;

	if((fd=open(filename,aflg|oflg,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH))<0)return NULL;

	/* Set FILE structure. */
	if((fl=malloc(sizeof(FILE)))==NULL)return NULL;
	fl->fd=fd;
	fl->bufMode=_IONBF;
	fl->size=0;
	fl->buf=NULL;

	return fl;
}


int fclose(FILE *stream)
{
	int rest;


	rest=close(stream->fd);
	free(stream->buf);
	free(stream);

	if(rest<0)return EOF;
	else return 0;
}


size_t fread(void* ptr,size_t size,size_t nobj,FILE* stream)
{
	size_t all_size;
	int rest;


	all_size=size*nobj;
	if((rest=read(stream->fd,ptr,all_size))<0)return 0;

	return ROUNDUP(rest,size)/size;
}


size_t fwrite(const void* ptr,size_t size,size_t nobj,FILE* stream)
{
	size_t all_size;
	int rest;


	all_size=size*nobj;
	if((rest=write(stream->fd,ptr,all_size))<0)return 0;

	return nobj;
}


int setvbuf(FILE *stream, char* buf, int mode, size_t size)
{
	switch(mode)
	{
		case _IONBF:
			stream->bufMode=_IONBF;
			stream->size=0;
			stream->buf=NULL;
			break;
		case _IOFBF:
		case _IOLBF:
			stream->bufMode=mode;
			stream->size=size;
			if(buf!=NULL)stream->buf=NULL;
			else if((buf=malloc(size))==NULL)return -1;
			break;
		default:
			errno=EINVAL;
			return -1;
	}

	return 0;
}


void setbuf(FILE* stream, char* buf)
{
	if(buf==NULL)setvbuf(stream,NULL,_IONBF,0);
	else setvbuf(stream,buf,_IOFBF,BUFSIZ);
}


int fgetc(FILE *stream)
{
	uchar c;


	switch(read(stream->fd,&c,1))
	{
		case 1:return c;
		case 0:
			stream->flag|=F_FLAG_EOF;
			return EOF;
		default:
			stream->flag|=F_FLAG_ERR;
			return EOF;
	}

}


int getc(FILE *stream)
{
	return fgetc(stream);
}


int getchar(void)
{
	return fgetc(stdin);
}


char *fgets(char *s, int size, FILE *stream)
{
	int rest;
	int i;


	if(size<=0)return s;

	if((rest=read(stream->fd,s,size-1))<0)
	{
		stream->flag|=F_FLAG_ERR;
		return NULL;
	}
	s[rest]='\0';
	for(i=0;s[i]!='\n';++i)
		if(s[i]=='\0')
		{
			if(rest<size-1)
			{
				stream->flag|=F_FLAG_EOF;
				return NULL;
			}
			else return s;
		}
	s[i+1]='\0';

	/* ե륪եåȤԤμޤᤷƤ */
	lseek(stream->fd,rest-size+1,SEEK_CUR);

	return s;
}


char *gets(char *s)
{
	enum{READ_SIZE=512};

	char *p;
	int rest;
	int i;


	for(p=s;(rest=read(stdin->fd,p,READ_SIZE))==READ_SIZE;p+=READ_SIZE)
	{
		/* Ԥõ */
		for(i=0;i<READ_SIZE;++i)
			if(p[i]=='\n')
			{
				p[i]='\0';
				lseek(stdin->fd,i-READ_SIZE+1,SEEK_CUR);
				return s;
			}
	}


	if(rest<0)		/* ɹߥ顼 */
	{
		stdin->flag|=F_FLAG_ERR;
		return NULL;
	}
	else			/* EOF. */
	{
		p[rest]='\0';
		stdin->flag|=F_FLAG_EOF;
				return NULL;
	}
}


int fputc(int c, FILE *stream)
{
	uchar wc;


	wc=c;
	if(write(stream->fd,&wc,1)!=1)
	{
		stream->flag|=F_FLAG_EOF;
		return EOF;
	}
	else return (int)wc;
}


int putc(int c, FILE *stream)
{
	return fputc(c,stream);
}


int putchar(int c)
{
	return fputc(c,stdout);
}


int ungetc(int c, FILE *stream)
{
	return fputc(c,stream);
}


int fputs(const char *s, FILE *stream)
{
	int size;


	size=strlen(s);
	if(write(stream->fd,s,size)!=size)
	{
		stream->flag|=F_FLAG_ERR;
		return EOF;
	}
	return 0;
}


int puts(const char *s)
{
	int size;


	size=strlen(s);
	if(write(stdout->fd,s,size)!=size)
	{
		stdout->flag|=F_FLAG_ERR;
		return EOF;
	}
	if(write(stdout->fd,"\n",1)!=1)
	{
		stdout->flag|=F_FLAG_ERR;
		return EOF;
	}
	return 0;
}


int vfprintf(FILE *stream, const char *format, va_list ap)
{
	char buf[1024];
	int size;


	size=formatToString(format,buf,(uint*)ap);
	if(write(stream->fd,buf,size)!=size)
	{
		stream->flag|=F_FLAG_ERR;
		return EOF;
	}
	return size;
}


int vprintf(const char *format, va_list ap)
{
	return vfprintf(stdout,format,ap);
}


int fprintf(FILE *stream, const char *format, ...)
{
	va_list ap;


	va_start(ap,format);
	return vfprintf(stream,format,ap);
}


int printf(const char *format, ...)
{
	va_list ap;


	va_start(ap,format);
	return vfprintf(stdout,format,ap);
}


int vsprintf(char *str, const char *format, va_list ap)
{
	return formatToString(format,str,(uint*)ap);
}


int sprintf(char *str, const char *format, ...)
{
	va_list ap;


	va_start(ap,format);
	return formatToString(format,str,(uint*)ap);
}


/***************************************************************************
 *
 * ¾
 *
 ***************************************************************************/

int rename(const char *old, const char *new)
{
	int rest;


	if((rest=syscall3(SYS_RENAME,(int)old,(int)new))<0)
	{
		errno=-rest;
		return -1;
	}

	return 0;
}
