/*
 * lib.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ͥ饤֥꡼
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"time.h"
#include"console.h"
#include"mm.h"


/*--------------------------------------------------------------------------
 *
 * Format string.
 *
 *--------------------------------------------------------------------------*/

enum{
	TMP_BUF_SIZE=12,
};


/*
 * 10ʿʸѴХåեθƤ
 * parameters : string,buffer,buffer size,flag
 * return : string length
 */
static inline int iToDecimal(int value,char *buf)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%10+'0';
		if(!(value/=10))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * 16ʿʸѴ
 * parameters : string,buffer,buffer size
 * return : string length
 */
static inline int iToBinary(uint value,char *buf)
{
	char tmp_buf[TMP_BUF_SIZE];
	int i;


	for(i=TMP_BUF_SIZE-1;;--i)
	{
		tmp_buf[i]=value%16+'0';
		if(tmp_buf[i]>'9')tmp_buf[i]+='a'-'9'-1;
		if(!(value/=16))break;
	}
	memcpy(buf,&tmp_buf[i],TMP_BUF_SIZE-i);

	return TMP_BUF_SIZE-i;
}


/*
 * PRIVATE
 * ʸѴƥХåե¸롣
 * parameters :
 * return : converted string size
 */
static int formatString(const char *str,char *buf,uint *arg)
{
	int ivalue,size;
	int i;


	for(i=0;*str!='\0';++str)
	{
		if(*str=='%')
		{
			switch(*++str)
			{
				case 'd':
					ivalue=*arg++;
					if(ivalue<0)
					{
						buf[i++]='-';
						ivalue*=-1;
					}
					i+=iToDecimal(ivalue,&buf[i]);
					break;
				case 'x':
					i+=iToBinary(*arg++,&buf[i]);
					break;
				case 's':
					size=strlen((char*)*arg);
					memcpy(&buf[i],(char*)*arg,size);
					++arg;
					i+=size;
					break;
				case '%':
				default:
					buf[i++]='%';
			}
		}
		else buf[i++]=*str;
	}

	buf[i]='\0';

	return i;
}


/*------------------------------------------------------------------------*/


int (*write_tty)(void*,size_t,size_t);


/*
 * ̽ϴؿ
 *  : ʸ(%d,%u,%x,%sб)...
 */
void printk(const char *str,...)
{
	char buf[240];
	int size;
	uint *arg=(uint*)&str+1;


	size=formatString(str,buf,arg);
	write_tty(buf,size,0);
}


/*
 * Хåեϴؿ
 *  : ʸ(%d,%u,%x,%sб)...
 */
int sprintk(char *buf,const char *str,...)
{
	uint *arg=(uint*)&str+1;


	return formatString(str,buf,arg);
}


/*
 * micro seccond ޡ
 *  : (1microseccondñ)
 */
void micro_timer(uint count)
{
	uint64 end;


	end=rdtsc();
	end+=count*clock_1micro;
	while(rdtsc()<end);
}


/*
 * mili seccond timer
 * param : value of counts(1ms)
 */
void mili_timer(uint count)
{
	uint64 end;


	end=rdtsc();
	end+=count*clock_1m;
	while(rdtsc()<end);
}


/*
 * Convert ascii to integer
 * parameters : string
 * return : integer or 0(Ǥʤ)
 */
int atoi(const char *str)
{
	int rest=0;


	for(;*str!='\0';++str)
	{
		if((*str<'0')||(*str>'9'))return 0;
		rest=rest*10+*str-'0';
	}

	return rest;
}
